/*
 * Decompiled with CFR 0.152.
 */
package com.sandrios.sandriosCamera.internal.imageCropper;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.widget.ImageView;
import com.sandrios.sandriosCamera.R;
import com.sandrios.sandriosCamera.internal.imageCropper.BitmapUtils;

public class CropperImageView
extends ImageView {
    private static final String TAG = "CropperImageView";
    private float[] mMatrixValues = new float[9];
    protected GestureDetector mGestureDetector;
    private GestureListener mGestureListener;
    protected ScaleGestureDetector mScaleDetector;
    private ScaleListener mScaleListener;
    private float mMinZoom;
    private float mMaxZoom;
    private float mBaseZoom;
    private float mFocusX;
    private float mFocusY;
    private boolean isMaxZoomSet = false;
    private boolean mFirstRender = true;
    private Bitmap mBitmap;
    private boolean doPreScaling = false;
    private float mPreScale;
    private boolean mAddPaddingToMakeSquare = true;
    private GestureCallback mGestureCallback;
    private boolean showAnimation = true;
    private boolean isAdjusting = false;
    private int mPaintColor = -1;
    public boolean DEBUG = false;
    private boolean gestureEnabled = true;

    public CropperImageView(Context context) {
        super(context);
        this.init(context, null);
    }

    public CropperImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public CropperImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public CropperImageView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    public void setDEBUG(boolean DEBUG) {
        this.DEBUG = DEBUG;
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray mTypedArray = context.obtainStyledAttributes(attrs, R.styleable.CropperView);
            this.mPaintColor = mTypedArray.getColor(R.styleable.CropperView_padding_color, this.mPaintColor);
            this.mAddPaddingToMakeSquare = mTypedArray.getBoolean(R.styleable.CropperView_add_padding_to_make_square, true);
        }
        this.mGestureListener = new GestureListener();
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this.mGestureListener, null, true);
        this.mScaleListener = new ScaleListener();
        this.mScaleDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)this.mScaleListener);
        this.setScaleType(ImageView.ScaleType.MATRIX);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int orientation = this.getContext().getResources().getConfiguration().orientation;
        if (orientation == 1 || orientation == 0) {
            int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int height = View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000);
            this.setMeasuredDimension(width, height);
        } else {
            int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
            int width = View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000);
            this.setMeasuredDimension(width, height);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if ((changed || this.mFirstRender) && this.mFirstRender) {
            Drawable drawable = this.getDrawable();
            if (drawable == null) {
                if (this.DEBUG) {
                    Log.e((String)TAG, (String)"drawable is null");
                }
                return;
            }
            this.mMinZoom = (float)(bottom - top) / (float)Math.max(drawable.getIntrinsicHeight(), drawable.getIntrinsicWidth());
            this.mBaseZoom = (float)(bottom - top) / (float)Math.min(drawable.getIntrinsicHeight(), drawable.getIntrinsicWidth());
            this.cropToCenter(drawable, bottom - top);
            this.mFirstRender = false;
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.isAdjusting) {
            return true;
        }
        int action = event.getActionMasked();
        if (action == 0 && this.mGestureCallback != null) {
            this.mGestureCallback.onGestureStarted();
        }
        this.mScaleDetector.onTouchEvent(event);
        if (!this.mScaleDetector.isInProgress()) {
            this.mGestureDetector.onTouchEvent(event);
        }
        switch (event.getAction()) {
            case 1: {
                if (this.mGestureCallback != null) {
                    this.mGestureCallback.onGestureCompleted();
                }
                return this.onUp(event);
            }
        }
        return true;
    }

    public void setImageBitmap(Bitmap bm) {
        this.mFirstRender = true;
        if (bm == null) {
            this.mBitmap = null;
            super.setImageBitmap(null);
            return;
        }
        this.mBitmap = bm;
        if (this.doPreScaling) {
            int max_param = Math.max(bm.getWidth(), bm.getHeight());
            this.mPreScale = (float)max_param / (float)this.getWidth();
            Bitmap scaledBitmap = Bitmap.createScaledBitmap((Bitmap)bm, (int)((int)((float)bm.getWidth() / this.mPreScale)), (int)((int)((float)bm.getHeight() / this.mPreScale)), (boolean)false);
            super.setImageBitmap(scaledBitmap);
        } else {
            this.mPreScale = 1.0f;
            super.setImageBitmap(bm);
        }
        this.requestLayout();
    }

    public void replaceBitmap(Bitmap bitmap) {
        if (bitmap == null) {
            throw new NullPointerException("Can not replace with null bitmap");
        }
        if (this.mBitmap == null) {
            this.setImageBitmap(bitmap);
            return;
        }
        if (this.mBitmap.getWidth() != bitmap.getWidth() || this.mBitmap.getHeight() != bitmap.getHeight()) {
            Log.e((String)TAG, (String)"Bitmap is of different size. Not replacing");
            return;
        }
        super.setImageBitmap(bitmap);
        this.mBitmap = bitmap;
    }

    private void cropToCenter(Drawable drawable, int frameDimen) {
        if (drawable == null) {
            if (this.DEBUG) {
                Log.e((String)TAG, (String)"Drawable is null. I can't fit anything");
            }
            return;
        }
        if (frameDimen == 0) {
            if (this.DEBUG) {
                Log.e((String)TAG, (String)"Frame Dimension is 0. I'm quite boggled by it.");
            }
            return;
        }
        int width = drawable.getIntrinsicWidth();
        int height = drawable.getIntrinsicHeight();
        if (this.DEBUG) {
            Log.i((String)TAG, (String)("drawable size: (" + width + " ," + height + ")"));
        }
        int min_dimen = Math.min(width, height);
        float scaleFactor = (float)min_dimen / (float)frameDimen;
        Matrix matrix = new Matrix();
        matrix.setScale(1.0f / scaleFactor, 1.0f / scaleFactor);
        matrix.postTranslate(((float)frameDimen - (float)width / scaleFactor) / 2.0f, ((float)frameDimen - (float)height / scaleFactor) / 2.0f);
        this.setImageMatrix(matrix);
    }

    private void fitToCenter(Drawable drawable, int frameDimen) {
        if (drawable == null) {
            if (this.DEBUG) {
                Log.e((String)TAG, (String)"Drawable is null. I can't fit anything");
            }
            return;
        }
        if (frameDimen == 0) {
            if (this.DEBUG) {
                Log.e((String)TAG, (String)"Frame Dimension is 0. I'm quite boggled by it.");
            }
            return;
        }
        int width = drawable.getIntrinsicWidth();
        int height = drawable.getIntrinsicHeight();
        if (this.DEBUG) {
            Log.i((String)TAG, (String)("drawable size: (" + width + " ," + height + ")"));
        }
        int min_dimen = Math.max(width, height);
        float scaleFactor = (float)min_dimen / (float)frameDimen;
        Matrix matrix = new Matrix();
        matrix.setScale(1.0f / scaleFactor, 1.0f / scaleFactor);
        matrix.postTranslate(((float)frameDimen - (float)width / scaleFactor) / 2.0f, ((float)frameDimen - (float)height / scaleFactor) / 2.0f);
        this.setImageMatrix(matrix);
    }

    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        Matrix matrix = this.getImageMatrix();
        matrix.postTranslate(-distanceX, -distanceY);
        this.setImageMatrix(matrix);
        this.invalidate();
        return true;
    }

    private boolean onUp(MotionEvent event) {
        Drawable drawable = this.getDrawable();
        if (drawable == null) {
            return false;
        }
        Matrix matrix = this.getImageMatrix();
        float tx = this.getMatrixValue(matrix, 2);
        float ty = this.getMatrixValue(matrix, 5);
        float scaleX = this.getMatrixValue(matrix, 0);
        float scaleY = this.getMatrixValue(matrix, 4);
        if (this.DEBUG) {
            Log.i((String)TAG, (String)("onUp: " + tx + " " + ty));
            Log.i((String)TAG, (String)("scale: " + scaleX));
            Log.i((String)TAG, (String)("min, max, base zoom: " + this.mMinZoom + ", " + this.mMaxZoom + ", " + this.mBaseZoom));
            Log.i((String)TAG, (String)("imageview size: " + this.getWidth() + " " + this.getHeight()));
            Log.i((String)TAG, (String)("drawable size: " + drawable.getIntrinsicWidth() + " " + drawable.getIntrinsicHeight()));
            Log.i((String)TAG, (String)("scaled drawable size: " + scaleX * (float)drawable.getIntrinsicWidth() + " " + scaleY * (float)drawable.getIntrinsicHeight()));
        }
        if (scaleX <= this.mMinZoom) {
            if (this.DEBUG) {
                Log.i((String)TAG, (String)("set scale: " + this.mMinZoom));
            }
            float xx = (float)(this.getWidth() / 2) - this.mMinZoom * (float)drawable.getIntrinsicWidth() / 2.0f;
            float yy = (float)(this.getHeight() / 2) - this.mMinZoom * (float)drawable.getIntrinsicHeight() / 2.0f;
            if (this.showAnimation()) {
                this.animateAdjustmentWithScale(tx, xx, ty, yy, scaleX, this.mMinZoom);
            } else {
                matrix.reset();
                matrix.setScale(this.mMinZoom, this.mMinZoom);
                matrix.postTranslate(xx, yy);
                this.setImageMatrix(matrix);
                this.invalidate();
                if (this.DEBUG) {
                    Log.i((String)TAG, (String)("scale after invalidate: " + this.getScale(matrix)));
                }
            }
            return true;
        }
        if (scaleX < this.mBaseZoom) {
            float xTranslate;
            float yTranslate;
            int w;
            int h = drawable.getIntrinsicHeight();
            if (h <= (w = drawable.getIntrinsicWidth())) {
                float xDiff;
                yTranslate = (float)(this.getHeight() / 2) - scaleX * (float)h / 2.0f;
                xTranslate = tx >= 0.0f ? 0.0f : (tx < (xDiff = (float)this.getWidth() - scaleX * (float)drawable.getIntrinsicWidth()) ? xDiff : tx);
            } else {
                float yDiff;
                xTranslate = (float)(this.getWidth() / 2) - scaleX * (float)w / 2.0f;
                yTranslate = ty >= 0.0f ? 0.0f : (ty < (yDiff = (float)this.getHeight() - scaleY * (float)drawable.getIntrinsicHeight()) ? yDiff : ty);
            }
            if (this.showAnimation()) {
                matrix.reset();
                matrix.postScale(scaleX, scaleX);
                matrix.postTranslate(tx, ty);
                this.setImageMatrix(matrix);
                this.animateAdjustment(xTranslate - tx, yTranslate - ty);
            } else {
                matrix.reset();
                matrix.postScale(scaleX, scaleX);
                matrix.postTranslate(xTranslate, yTranslate);
                this.setImageMatrix(matrix);
                this.invalidate();
            }
            return true;
        }
        if (this.isMaxZoomSet && scaleX > this.mMaxZoom) {
            if (this.DEBUG) {
                Log.i((String)TAG, (String)"set to max zoom");
                Log.i((String)TAG, (String)("isMaxZoomSet: " + this.isMaxZoomSet));
            }
            if (this.showAnimation()) {
                this.animateOverMaxZoomAdjustment();
            } else {
                matrix.postScale(this.mMaxZoom / scaleX, this.mMaxZoom / scaleX, this.mFocusX, this.mFocusY);
                this.setImageMatrix(matrix);
                this.invalidate();
                this.adjustToSides();
            }
            return true;
        }
        if (this.DEBUG) {
            Log.i((String)TAG, (String)"adjust to sides");
        }
        this.adjustToSides();
        return true;
    }

    private boolean adjustToSides() {
        boolean changeRequired = false;
        Drawable drawable = this.getDrawable();
        if (drawable == null) {
            return changeRequired;
        }
        Matrix matrix = this.getImageMatrix();
        float sx = this.getMatrixValue(matrix, 2);
        float sy = this.getMatrixValue(matrix, 5);
        float tx = this.getMatrixValue(matrix, 2);
        float ty = this.getMatrixValue(matrix, 5);
        float scaleX = this.getMatrixValue(matrix, 0);
        float scaleY = this.getMatrixValue(matrix, 4);
        if (tx > 0.0f) {
            tx = -tx;
            changeRequired = true;
        } else {
            float xDiff = (float)this.getWidth() - scaleX * (float)drawable.getIntrinsicWidth();
            if (tx < xDiff) {
                tx = xDiff - tx;
                changeRequired = true;
            } else {
                tx = 0.0f;
            }
        }
        if (ty > 0.0f) {
            ty = -ty;
            changeRequired = true;
        } else {
            float yDiff = (float)this.getHeight() - scaleY * (float)drawable.getIntrinsicHeight();
            if (ty < yDiff) {
                ty = yDiff - ty;
                changeRequired = true;
            } else {
                ty = 0.0f;
            }
        }
        if (changeRequired) {
            if (this.showAnimation()) {
                this.animateAdjustment(tx, ty);
            } else {
                matrix.postTranslate(tx, ty);
                this.setImageMatrix(matrix);
                this.invalidate();
            }
        }
        return changeRequired;
    }

    private float getMatrixValue(Matrix matrix, int whichValue) {
        matrix.getValues(this.mMatrixValues);
        return this.mMatrixValues[whichValue];
    }

    private float getScale(Matrix matrix) {
        return this.getMatrixValue(matrix, 0);
    }

    public boolean isDoPreScaling() {
        return this.doPreScaling;
    }

    public void setDoPreScaling(boolean doPreScaling) {
        this.doPreScaling = doPreScaling;
    }

    public float getMaxZoom() {
        return this.mMaxZoom;
    }

    public void setMaxZoom(float mMaxZoom) {
        if (mMaxZoom <= 0.0f) {
            Log.e((String)TAG, (String)"Max zoom must be greater than 0");
            return;
        }
        this.mMaxZoom = mMaxZoom;
        this.isMaxZoomSet = true;
    }

    public float getMinZoom() {
        return this.mMinZoom;
    }

    public void setMinZoom(float mMInZoom) {
        if (mMInZoom <= 0.0f) {
            Log.e((String)TAG, (String)"Min zoom must be greater than 0");
            return;
        }
        this.mMinZoom = mMInZoom;
    }

    public void cropToCenter() {
        Drawable drawable = this.getDrawable();
        if (drawable != null) {
            this.cropToCenter(drawable, this.getWidth());
        }
    }

    public void fitToCenter() {
        Drawable drawable = this.getDrawable();
        if (drawable != null) {
            this.fitToCenter(drawable, this.getWidth());
        }
    }

    public Bitmap getCroppedBitmap() {
        Bitmap bitmap;
        if (this.mBitmap == null) {
            Log.e((String)TAG, (String)"original image is not available");
            return null;
        }
        Matrix matrix = this.getImageMatrix();
        if (this.doPreScaling) {
            matrix.postScale(1.0f / this.mPreScale, 1.0f / this.mPreScale);
        }
        float xTrans = this.getMatrixValue(matrix, 2);
        float yTrans = this.getMatrixValue(matrix, 5);
        float scale = this.getMatrixValue(matrix, 0);
        if (this.DEBUG) {
            Log.i((String)TAG, (String)("xTrans: " + xTrans + ", yTrans: " + yTrans + " , scale: " + scale));
        }
        if (this.DEBUG) {
            Log.i((String)TAG, (String)("old bitmap: " + this.mBitmap.getWidth() + " " + this.mBitmap.getHeight()));
        }
        if (xTrans > 0.0f && yTrans > 0.0f && scale <= this.mMinZoom) {
            if (this.mAddPaddingToMakeSquare) {
                return BitmapUtils.addPadding(this.mBitmap, this.mPaintColor);
            }
            return this.mBitmap;
        }
        float cropY = -yTrans / scale;
        float Y = (float)this.getHeight() / scale;
        float cropX = -xTrans / scale;
        float X = (float)this.getWidth() / scale;
        if (this.DEBUG) {
            Log.i((String)TAG, (String)("cropY: " + cropY));
            Log.i((String)TAG, (String)("Y: " + Y));
            Log.i((String)TAG, (String)("cropX: " + cropX));
            Log.i((String)TAG, (String)("X: " + X));
        }
        if (cropY + Y > (float)this.mBitmap.getHeight()) {
            cropY = (float)this.mBitmap.getHeight() - Y;
            if (this.DEBUG) {
                Log.i((String)TAG, (String)("readjust cropY to: " + cropY));
            }
        } else if (cropY < 0.0f) {
            cropY = 0.0f;
            if (this.DEBUG) {
                Log.i((String)TAG, (String)("readjust cropY to: " + cropY));
            }
        }
        if (cropX + X > (float)this.mBitmap.getWidth()) {
            cropX = (float)this.mBitmap.getWidth() - X;
            if (this.DEBUG) {
                Log.i((String)TAG, (String)("readjust cropX to: " + cropX));
            }
        } else if (cropX < 0.0f) {
            cropX = 0.0f;
            if (this.DEBUG) {
                Log.i((String)TAG, (String)("readjust cropX to: " + cropX));
            }
        }
        if (this.mBitmap.getHeight() > this.mBitmap.getWidth()) {
            if (xTrans >= 0.0f) {
                Rect src = new Rect(0, (int)cropY, this.mBitmap.getWidth(), (int)(Y + cropY));
                if (this.mAddPaddingToMakeSquare) {
                    int size = (int)Y;
                    bitmap = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)this.mBitmap.getConfig());
                    Canvas canvas = new Canvas(bitmap);
                    canvas.drawColor(this.mPaintColor);
                    int left = (size - this.mBitmap.getWidth()) / 2;
                    Rect dest = new Rect(left, 0, left + this.mBitmap.getWidth(), size);
                    canvas.drawBitmap(this.mBitmap, src, dest, null);
                } else {
                    bitmap = Bitmap.createBitmap((Bitmap)this.mBitmap, (int)0, (int)((int)cropY), (int)this.mBitmap.getWidth(), (int)((int)Y), null, (boolean)true);
                }
            } else {
                bitmap = Bitmap.createBitmap((Bitmap)this.mBitmap, (int)((int)cropX), (int)((int)cropY), (int)((int)X), (int)((int)Y), null, (boolean)true);
            }
        } else {
            if (yTrans >= 0.0f) {
                Rect src = new Rect((int)cropX, 0, (int)(cropX + X), this.mBitmap.getHeight());
                if (this.mAddPaddingToMakeSquare) {
                    int size = (int)X;
                    bitmap = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)this.mBitmap.getConfig());
                    Canvas canvas = new Canvas(bitmap);
                    canvas.drawColor(this.mPaintColor);
                    int top = (size - this.mBitmap.getHeight()) / 2;
                    Rect dest = new Rect(0, top, size, top + this.mBitmap.getHeight());
                    canvas.drawBitmap(this.mBitmap, src, dest, null);
                } else {
                    bitmap = Bitmap.createBitmap((Bitmap)this.mBitmap, (int)((int)cropX), (int)0, (int)((int)X), (int)this.mBitmap.getHeight(), null, (boolean)true);
                }
            } else {
                bitmap = Bitmap.createBitmap((Bitmap)this.mBitmap, (int)((int)cropX), (int)((int)cropY), (int)((int)X), (int)((int)Y), null, (boolean)true);
            }
            if (this.DEBUG) {
                Log.i((String)TAG, (String)("width should be: " + this.mBitmap.getWidth()));
                Log.i((String)TAG, (String)("crop bitmap: " + bitmap.getWidth() + " " + bitmap.getHeight()));
            }
        }
        return bitmap;
    }

    public boolean showAnimation() {
        return this.showAnimation;
    }

    public void setShowAnimation(boolean showAnimation) {
        this.showAnimation = showAnimation;
    }

    public int getPaddingColor() {
        return this.mPaintColor;
    }

    public void setPaddingColor(int mPaintColor) {
        this.mPaintColor = mPaintColor;
    }

    public boolean isMakeSquare() {
        return this.mAddPaddingToMakeSquare;
    }

    public void setMakeSquare(boolean mAddPaddingToMakeSquare) {
        this.mAddPaddingToMakeSquare = mAddPaddingToMakeSquare;
    }

    public boolean isGestureEnabled() {
        return this.gestureEnabled;
    }

    public void setGestureEnabled(boolean gestureEnabled) {
        this.gestureEnabled = gestureEnabled;
    }

    public void release() {
        this.setImageBitmap(null);
        if (this.mBitmap != null) {
            this.mBitmap.recycle();
        }
    }

    public void setGestureCallback(GestureCallback mGestureCallback) {
        this.mGestureCallback = mGestureCallback;
    }

    private void animateAdjustmentWithScale(final float xStart, final float xEnd, final float yStart, final float yEnd, final float scaleStart, final float scaleEnd) {
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{0, 20});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                Matrix matrix = CropperImageView.this.getImageMatrix();
                matrix.reset();
                Integer value = (Integer)animation.getAnimatedValue();
                matrix.postScale((scaleEnd - scaleStart) * (float)value.intValue() / 20.0f + scaleStart, (scaleEnd - scaleStart) * (float)value.intValue() / 20.0f + scaleStart);
                matrix.postTranslate((xEnd - xStart) * (float)value.intValue() / 20.0f + xStart, (yEnd - yStart) * (float)value.intValue() / 20.0f + yStart);
                CropperImageView.this.setImageMatrix(matrix);
                CropperImageView.this.invalidate();
            }
        });
        animator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                CropperImageView.this.isAdjusting = true;
            }

            public void onAnimationEnd(Animator animation) {
                CropperImageView.this.isAdjusting = false;
            }

            public void onAnimationCancel(Animator animation) {
                CropperImageView.this.isAdjusting = false;
            }

            public void onAnimationRepeat(Animator animation) {
                CropperImageView.this.isAdjusting = true;
            }
        });
        animator.start();
    }

    private void animateAdjustment(final float xDiff, final float yDiff) {
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{0, 20});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                Matrix matrix = CropperImageView.this.getImageMatrix();
                matrix.postTranslate(xDiff / 20.0f, yDiff / 20.0f);
                CropperImageView.this.setImageMatrix(matrix);
                CropperImageView.this.invalidate();
            }
        });
        animator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                CropperImageView.this.isAdjusting = true;
            }

            public void onAnimationEnd(Animator animation) {
                CropperImageView.this.isAdjusting = false;
            }

            public void onAnimationCancel(Animator animation) {
                CropperImageView.this.isAdjusting = false;
            }

            public void onAnimationRepeat(Animator animation) {
                CropperImageView.this.isAdjusting = true;
            }
        });
        animator.start();
    }

    private void animateOverMaxZoomAdjustment() {
        Matrix matrix = this.getImageMatrix();
        final float scale = this.getScale(matrix);
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{0, 20});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                Matrix matrix = CropperImageView.this.getImageMatrix();
                float currentScale = CropperImageView.this.getScale(matrix);
                if (currentScale <= CropperImageView.this.mMaxZoom) {
                    return;
                }
                double expScale = Math.pow(CropperImageView.this.mMaxZoom / scale, 0.05f);
                matrix.postScale((float)expScale, (float)expScale, CropperImageView.this.mFocusX, CropperImageView.this.mFocusY);
                CropperImageView.this.setImageMatrix(matrix);
                CropperImageView.this.invalidate();
            }
        });
        animator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                CropperImageView.this.isAdjusting = true;
            }

            public void onAnimationEnd(Animator animation) {
                CropperImageView.this.isAdjusting = false;
                CropperImageView.this.adjustToSides();
            }

            public void onAnimationCancel(Animator animation) {
                CropperImageView.this.isAdjusting = false;
            }

            public void onAnimationRepeat(Animator animation) {
                CropperImageView.this.isAdjusting = true;
            }
        });
        animator.start();
    }

    public static interface GestureCallback {
        public void onGestureStarted();

        public void onGestureCompleted();
    }

    private class ScaleListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        protected boolean mScaled = false;

        private ScaleListener() {
        }

        public boolean onScale(ScaleGestureDetector detector) {
            if (!CropperImageView.this.gestureEnabled) {
                return false;
            }
            Matrix matrix = CropperImageView.this.getImageMatrix();
            CropperImageView.this.mFocusX = detector.getFocusX();
            CropperImageView.this.mFocusY = detector.getFocusY();
            matrix.postScale(detector.getScaleFactor(), detector.getScaleFactor(), detector.getFocusX(), detector.getFocusY());
            CropperImageView.this.setImageMatrix(matrix);
            CropperImageView.this.invalidate();
            return true;
        }
    }

    private class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private GestureListener() {
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (!CropperImageView.this.gestureEnabled) {
                return false;
            }
            if (e1 == null || e2 == null) {
                return false;
            }
            if (e1.getPointerCount() > 1 || e2.getPointerCount() > 1) {
                return false;
            }
            CropperImageView.this.onScroll(e1, e2, distanceX, distanceY);
            return false;
        }
    }
}

