/*
 * Decompiled with CFR 0.152.
 */
package com.sandrios.sandriosCamera.internal.imageCropper;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.View;
import com.sandrios.sandriosCamera.R;

public class CropperGridView
extends View {
    private static final String TAG = "CropperGridView";
    private long HIDE_INTERVAL = 1500L;
    private Paint mPaint;
    private int mColor = 0xFFFFFFF;
    private int mAlpha = 200;
    private int mStrokeWidth = 3;
    private boolean showGrid = false;
    private Handler mHandler;
    private Path mPath;
    private Runnable mHideRunnable = new Runnable(){

        @Override
        public void run() {
            CropperGridView.this.showGrid = false;
            CropperGridView.this.invalidate();
        }
    };

    public CropperGridView(Context context) {
        super(context);
        this.init(context, null);
    }

    public CropperGridView(Context context, AttributeSet attrs) {
        super(context);
        this.init(context, attrs);
    }

    public CropperGridView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public CropperGridView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context);
        this.init(context, attrs);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int orientation = this.getContext().getResources().getConfiguration().orientation;
        if (orientation == 1 || orientation == 0) {
            int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int height = View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000);
            this.setMeasuredDimension(width, height);
        } else {
            int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
            int width = View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000);
            this.setMeasuredDimension(width, height);
        }
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray mTypedArray = context.obtainStyledAttributes(attrs, R.styleable.CropperView);
            this.mColor = mTypedArray.getColor(R.styleable.CropperView_grid_color, this.mColor);
            float alpha = 255.0f * mTypedArray.getFloat(R.styleable.CropperView_grid_opacity, 1.0f);
            if (alpha < 0.0f) {
                alpha = 0.0f;
            } else if (alpha > 255.0f) {
                alpha = 255.0f;
            }
            this.mAlpha = (int)alpha;
            this.mStrokeWidth = mTypedArray.getDimensionPixelOffset(R.styleable.CropperView_grid_thickness, this.mStrokeWidth);
            mTypedArray.recycle();
        }
        this.mPaint = new Paint();
        this.mPaint.setColor(this.mColor);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setStrokeWidth((float)this.mStrokeWidth);
        this.mPaint.setAlpha(this.mAlpha);
        this.mPath = new Path();
        this.mHandler = new Handler();
        if (this.isInEditMode()) {
            this.showGrid = true;
        }
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (!this.showGrid) {
            return;
        }
        int width = canvas.getWidth();
        int height = canvas.getHeight();
        this.mPath.reset();
        this.mPath.moveTo((float)(width / 3), 0.0f);
        this.mPath.lineTo((float)(width / 3), (float)height);
        this.mPath.moveTo((float)(2 * width / 3), 0.0f);
        this.mPath.lineTo((float)(2 * width / 3), (float)height);
        this.mPath.moveTo(0.0f, (float)(height / 3));
        this.mPath.lineTo((float)width, (float)(height / 3));
        this.mPath.moveTo(0.0f, (float)(2 * height / 3));
        this.mPath.lineTo((float)width, (float)(2 * height / 3));
        canvas.drawPath(this.mPath, this.mPaint);
    }

    public boolean showGrid() {
        return this.showGrid;
    }

    public void setShowGrid(boolean showGrid) {
        if (this.showGrid != showGrid) {
            this.showGrid = showGrid;
            if (this.showGrid) {
                this.mHandler.removeCallbacks(this.mHideRunnable);
                this.invalidate();
                return;
            }
            this.mHandler.postDelayed(this.mHideRunnable, this.HIDE_INTERVAL);
        }
    }
}

