/*
 * Decompiled with CFR 0.152.
 */
package com.sandrios.sandriosCamera.internal.ui.model;

import android.media.CamcorderProfile;
import java.util.concurrent.TimeUnit;

public class VideoQualityOption
implements CharSequence {
    private String title;
    private int mediaQuality;

    public VideoQualityOption(int mediaQuality, CamcorderProfile camcorderProfile, double videoDuration) {
        this.mediaQuality = mediaQuality;
        long minutes = TimeUnit.SECONDS.toMinutes((long)videoDuration);
        long seconds = (long)videoDuration - minutes * 60L;
        this.title = mediaQuality == 10 ? "Auto , (" + (minutes > 10L ? Long.valueOf(minutes) : "0" + minutes) + ":" + (seconds > 10L ? Long.valueOf(seconds) : "0" + seconds) + " min)" : String.valueOf(camcorderProfile.videoFrameWidth) + " x " + String.valueOf(camcorderProfile.videoFrameHeight) + (videoDuration <= 0.0 ? "" : ", (" + (minutes > 10L ? Long.valueOf(minutes) : "0" + minutes) + ":" + (seconds > 10L ? Long.valueOf(seconds) : "0" + seconds) + " min)");
    }

    public int getMediaQuality() {
        return this.mediaQuality;
    }

    @Override
    public int length() {
        return this.title.length();
    }

    @Override
    public char charAt(int index) {
        return this.title.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.title.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.title;
    }
}

