/*
 * Decompiled with CFR 0.152.
 */
package com.sandrios.sandriosCamera.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.IntRange;
import com.gun0912.tedpermission.PermissionListener;
import com.gun0912.tedpermission.TedPermission;
import com.sandrios.sandriosCamera.internal.ui.camera.Camera1Activity;
import com.sandrios.sandriosCamera.internal.ui.camera2.Camera2Activity;
import com.sandrios.sandriosCamera.internal.utils.CameraHelper;
import java.util.ArrayList;

public class SandriosCamera {
    private SandriosCamera mInstance = this;
    private Activity mActivity;
    private int requestCode;
    private int mediaAction = 102;
    private boolean showPicker = true;

    public SandriosCamera(Activity activity, @IntRange(from=0L) int code) {
        this.mActivity = activity;
        this.requestCode = code;
    }

    public SandriosCamera setShowPicker(boolean showPicker) {
        this.showPicker = showPicker;
        return this.mInstance;
    }

    public SandriosCamera setMediaAction(int mediaAction) {
        this.mediaAction = mediaAction;
        return this.mInstance;
    }

    public void launchCamera() {
        new TedPermission((Context)this.mActivity).setPermissionListener(new PermissionListener(){

            public void onPermissionGranted() {
                SandriosCamera.this.launchIntent();
            }

            public void onPermissionDenied(ArrayList<String> deniedPermissions) {
            }
        }).setPermissions(new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.RECORD_AUDIO"}).check();
    }

    private void launchIntent() {
        Intent cameraIntent = CameraHelper.hasCamera2((Context)this.mActivity) ? new Intent((Context)this.mActivity, Camera2Activity.class) : new Intent((Context)this.mActivity, Camera1Activity.class);
        cameraIntent.putExtra("com.sandrios.sandriosCamera.request_code", this.requestCode);
        cameraIntent.putExtra("com.sandrios.sandriosCamera.show_picker", this.showPicker);
        cameraIntent.putExtra("com.sandrios.sandriosCamera.media_action", this.mediaAction);
        this.mActivity.startActivityForResult(cameraIntent, this.requestCode);
    }
}

