/*
 * Decompiled with CFR 0.152.
 */
package com.sandrios.sandriosCamera.internal.ui.view;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.FileObserver;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.sandrios.sandriosCamera.R;
import com.sandrios.sandriosCamera.internal.ui.view.CameraSwitchView;
import com.sandrios.sandriosCamera.internal.ui.view.FlashSwitchView;
import com.sandrios.sandriosCamera.internal.ui.view.ImageGalleryAdapter;
import com.sandrios.sandriosCamera.internal.ui.view.MediaActionSwitchView;
import com.sandrios.sandriosCamera.internal.ui.view.RecordButton;
import java.io.File;
import java.util.concurrent.TimeUnit;

public class CameraControlPanel
extends RelativeLayout
implements RecordButton.RecordButtonListener,
MediaActionSwitchView.OnMediaActionStateChangeListener {
    private Context context;
    private CameraSwitchView cameraSwitchView;
    private RecordButton recordButton;
    private MediaActionSwitchView mediaActionSwitchView;
    private FlashSwitchView flashSwitchView;
    private TextView recordDurationText;
    private TextView recordSizeText;
    private ImageButton settingsButton;
    private RecyclerView recyclerView;
    private ImageGalleryAdapter imageGalleryAdapter;
    private RecordButton.RecordButtonListener recordButtonListener;
    private MediaActionSwitchView.OnMediaActionStateChangeListener onMediaActionStateChangeListener;
    private CameraSwitchView.OnCameraTypeChangeListener onCameraTypeChangeListener;
    private FlashSwitchView.FlashModeSwitchListener flashModeSwitchListener;
    private SettingsClickListener settingsClickListener;
    private PickerItemClickListener pickerItemClickListener;
    private TimerTaskBase countDownTimer;
    private long maxVideoFileSize = 0L;
    private String mediaFilePath;
    private boolean hasFlash = false;
    private int mediaActionState;
    private int mediaAction;
    private FileObserver fileObserver;

    public CameraControlPanel(Context context) {
        this(context, null);
    }

    public CameraControlPanel(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.init();
    }

    private void init() {
        this.hasFlash = this.context.getPackageManager().hasSystemFeature("android.hardware.camera.flash");
        LayoutInflater.from((Context)this.context).inflate(R.layout.camera_control_panel_layout, (ViewGroup)this);
        this.setBackgroundColor(0);
        this.imageGalleryAdapter = new ImageGalleryAdapter(this.context);
        this.settingsButton = (ImageButton)this.findViewById(R.id.settings_view);
        this.cameraSwitchView = (CameraSwitchView)this.findViewById(R.id.front_back_camera_switcher);
        this.mediaActionSwitchView = (MediaActionSwitchView)this.findViewById(R.id.photo_video_camera_switcher);
        this.recordButton = (RecordButton)this.findViewById(R.id.record_button);
        this.flashSwitchView = (FlashSwitchView)this.findViewById(R.id.flash_switch_view);
        this.recordDurationText = (TextView)this.findViewById(R.id.record_duration_text);
        this.recordSizeText = (TextView)this.findViewById(R.id.record_size_mb_text);
        this.recyclerView = (RecyclerView)this.findViewById(R.id.recycler_view);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.context, 0, false));
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.imageGalleryAdapter);
        this.cameraSwitchView.setOnCameraTypeChangeListener(this.onCameraTypeChangeListener);
        this.mediaActionSwitchView.setOnMediaActionStateChangeListener(this);
        this.setOnCameraTypeChangeListener(this.onCameraTypeChangeListener);
        this.setOnMediaActionStateChangeListener(this.onMediaActionStateChangeListener);
        this.setFlashModeSwitchListener(this.flashModeSwitchListener);
        this.setRecordButtonListener(this.recordButtonListener);
        this.settingsButton.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.ic_settings_white));
        this.settingsButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (CameraControlPanel.this.settingsClickListener != null) {
                    CameraControlPanel.this.settingsClickListener.onSettingsClick();
                }
            }
        });
        if (this.hasFlash) {
            this.flashSwitchView.setVisibility(0);
        } else {
            this.flashSwitchView.setVisibility(8);
        }
        this.countDownTimer = new TimerTask(this.recordDurationText);
        this.imageGalleryAdapter.setOnItemClickListener(new ImageGalleryAdapter.OnItemClickListener(){

            @Override
            public void onItemClick(View view, int position) {
                CameraControlPanel.this.pickerItemClickListener.onItemClick(CameraControlPanel.this.imageGalleryAdapter.getItem(position).getImageUri());
            }
        });
    }

    public void lockControls() {
        this.cameraSwitchView.setEnabled(false);
        this.recordButton.setEnabled(false);
        this.settingsButton.setEnabled(false);
        this.flashSwitchView.setEnabled(false);
    }

    public void unLockControls() {
        this.cameraSwitchView.setEnabled(true);
        this.recordButton.setEnabled(true);
        this.settingsButton.setEnabled(true);
        this.flashSwitchView.setEnabled(true);
    }

    public void setup(int mediaAction) {
        this.mediaAction = mediaAction;
        if (100 == mediaAction) {
            this.recordButton.setup(mediaAction, this);
            this.flashSwitchView.setVisibility(8);
        } else {
            this.recordButton.setup(101, this);
        }
        if (102 != mediaAction) {
            this.mediaActionSwitchView.setVisibility(8);
        } else {
            this.mediaActionSwitchView.setVisibility(0);
        }
    }

    public void setMediaFilePath(File mediaFile) {
        this.mediaFilePath = mediaFile.toString();
    }

    public void setMaxVideoFileSize(long maxVideoFileSize) {
        this.maxVideoFileSize = maxVideoFileSize;
    }

    public void setMaxVideoDuration(int maxVideoDurationInMillis) {
        this.countDownTimer = maxVideoDurationInMillis > 0 ? new CountdownTask(this.recordDurationText, maxVideoDurationInMillis) : new TimerTask(this.recordDurationText);
    }

    public void setFlasMode(int flashMode) {
        this.flashSwitchView.setFlashMode(flashMode);
    }

    public void setMediaActionState(int actionState) {
        if (this.mediaActionState == actionState) {
            return;
        }
        if (0 == actionState) {
            this.recordButton.setMediaAction(101);
            if (this.hasFlash) {
                this.flashSwitchView.setVisibility(0);
            }
        } else {
            this.recordButton.setMediaAction(100);
            this.flashSwitchView.setVisibility(8);
        }
        this.mediaActionState = actionState;
        this.mediaActionSwitchView.setMediaActionState(actionState);
    }

    public void setRecordButtonListener(RecordButton.RecordButtonListener recordButtonListener) {
        this.recordButtonListener = recordButtonListener;
    }

    public void rotateControls(int rotation) {
        if (Build.VERSION.SDK_INT > 10) {
            this.cameraSwitchView.setRotation(rotation);
            this.mediaActionSwitchView.setRotation(rotation);
            this.flashSwitchView.setRotation(rotation);
            this.recordDurationText.setRotation((float)rotation);
            this.recordSizeText.setRotation((float)rotation);
        }
    }

    public void setOnMediaActionStateChangeListener(MediaActionSwitchView.OnMediaActionStateChangeListener onMediaActionStateChangeListener) {
        this.onMediaActionStateChangeListener = onMediaActionStateChangeListener;
    }

    public void setOnCameraTypeChangeListener(CameraSwitchView.OnCameraTypeChangeListener onCameraTypeChangeListener) {
        this.onCameraTypeChangeListener = onCameraTypeChangeListener;
        if (this.cameraSwitchView != null) {
            this.cameraSwitchView.setOnCameraTypeChangeListener(this.onCameraTypeChangeListener);
        }
    }

    public void setFlashModeSwitchListener(FlashSwitchView.FlashModeSwitchListener flashModeSwitchListener) {
        this.flashModeSwitchListener = flashModeSwitchListener;
        if (this.flashSwitchView != null) {
            this.flashSwitchView.setFlashSwitchListener(this.flashModeSwitchListener);
        }
    }

    public void setSettingsClickListener(SettingsClickListener settingsClickListener) {
        this.settingsClickListener = settingsClickListener;
    }

    public void setPickerItemClickListener(PickerItemClickListener pickerItemClickListener) {
        this.pickerItemClickListener = pickerItemClickListener;
    }

    @Override
    public void onTakePhotoButtonPressed() {
        if (this.recordButtonListener != null) {
            this.recordButtonListener.onTakePhotoButtonPressed();
        }
    }

    public void onStartVideoRecord(final File mediaFile) {
        this.setMediaFilePath(mediaFile);
        if (this.maxVideoFileSize > 0L) {
            this.recordSizeText.setText((CharSequence)("1Mb / " + this.maxVideoFileSize / 0x100000L + "Mb"));
            this.recordSizeText.setVisibility(0);
            try {
                this.fileObserver = new FileObserver(this.mediaFilePath){
                    private long lastUpdateSize;
                    {
                        super(x0);
                        this.lastUpdateSize = 0L;
                    }

                    public void onEvent(int event, String path) {
                        final long fileSize = mediaFile.length() / 0x100000L;
                        if (fileSize - this.lastUpdateSize >= 1L) {
                            this.lastUpdateSize = fileSize;
                            CameraControlPanel.this.recordSizeText.post(new Runnable(){

                                @Override
                                public void run() {
                                    CameraControlPanel.this.recordSizeText.setText((CharSequence)(fileSize + "Mb / " + CameraControlPanel.this.maxVideoFileSize / 0x100000L + "Mb"));
                                }
                            });
                        }
                    }
                };
                this.fileObserver.startWatching();
            }
            catch (Exception e) {
                Log.e((String)"FileObserver", (String)"setMediaFilePath: ", (Throwable)e);
            }
        }
        this.countDownTimer.start();
    }

    public void allowRecord(boolean isAllowed) {
        this.recordButton.setEnabled(isAllowed);
    }

    public void showPicker(boolean isShown) {
        this.recyclerView.setVisibility(isShown ? 0 : 8);
    }

    public void allowCameraSwitching(boolean isAllowed) {
        this.cameraSwitchView.setVisibility(isAllowed ? 0 : 8);
    }

    public void onStopVideoRecord() {
        if (this.fileObserver != null) {
            this.fileObserver.stopWatching();
        }
        this.countDownTimer.stop();
        this.recordSizeText.setVisibility(8);
        this.cameraSwitchView.setVisibility(0);
        this.settingsButton.setVisibility(0);
        if (102 != this.mediaAction) {
            this.mediaActionSwitchView.setVisibility(8);
        } else {
            this.mediaActionSwitchView.setVisibility(0);
        }
        this.recordButton.setRecordState(1);
    }

    @Override
    public void onStartRecordingButtonPressed() {
        this.cameraSwitchView.setVisibility(8);
        this.mediaActionSwitchView.setVisibility(8);
        this.settingsButton.setVisibility(8);
        if (this.recordButtonListener != null) {
            this.recordButtonListener.onStartRecordingButtonPressed();
        }
    }

    @Override
    public void onStopRecordingButtonPressed() {
        this.onStopVideoRecord();
        if (this.recordButtonListener != null) {
            this.recordButtonListener.onStopRecordingButtonPressed();
        }
    }

    @Override
    public void onMediaActionChanged(int mediaActionState) {
        this.setMediaActionState(mediaActionState);
        if (this.onMediaActionStateChangeListener != null) {
            this.onMediaActionStateChangeListener.onMediaActionChanged(this.mediaActionState);
        }
    }

    private class TimerTask
    extends TimerTaskBase
    implements Runnable {
        public TimerTask(TextView timerView) {
            super(timerView);
        }

        @Override
        public void run() {
            ++this.recordingTimeSeconds;
            if (this.recordingTimeSeconds == 60L) {
                this.recordingTimeSeconds = 0L;
                ++this.recordingTimeMinutes;
            }
            this.timerView.setText((CharSequence)String.format("%02d:%02d", this.recordingTimeMinutes, this.recordingTimeSeconds));
            if (this.alive) {
                this.handler.postDelayed((Runnable)this, 1000L);
            }
        }

        @Override
        public void start() {
            this.alive = true;
            this.recordingTimeMinutes = 0L;
            this.recordingTimeSeconds = 0L;
            this.timerView.setText((CharSequence)String.format("%02d:%02d", this.recordingTimeMinutes, this.recordingTimeSeconds));
            this.timerView.setVisibility(0);
            this.handler.postDelayed((Runnable)this, 1000L);
        }

        @Override
        public void stop() {
            this.timerView.setVisibility(4);
            this.alive = false;
        }
    }

    private class CountdownTask
    extends TimerTaskBase
    implements Runnable {
        private int maxDurationMilliseconds;

        public CountdownTask(TextView timerView, int maxDurationMilliseconds) {
            super(timerView);
            this.maxDurationMilliseconds = 0;
            this.maxDurationMilliseconds = maxDurationMilliseconds;
        }

        @Override
        public void run() {
            --this.recordingTimeSeconds;
            int millis = (int)this.recordingTimeSeconds * 1000;
            this.timerView.setText((CharSequence)String.format("%02d:%02d", TimeUnit.MILLISECONDS.toMinutes(millis), TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(millis))));
            if (this.recordingTimeSeconds < 10L) {
                this.timerView.setTextColor(-65536);
            }
            if (this.alive && this.recordingTimeSeconds > 0L) {
                this.handler.postDelayed((Runnable)this, 1000L);
            }
        }

        @Override
        void stop() {
            this.timerView.setVisibility(4);
            this.alive = false;
        }

        @Override
        void start() {
            this.alive = true;
            this.recordingTimeSeconds = this.maxDurationMilliseconds / 1000;
            this.timerView.setTextColor(-1);
            this.timerView.setText((CharSequence)String.format("%02d:%02d", TimeUnit.MILLISECONDS.toMinutes(this.maxDurationMilliseconds), TimeUnit.MILLISECONDS.toSeconds(this.maxDurationMilliseconds) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(this.maxDurationMilliseconds))));
            this.timerView.setVisibility(0);
            this.handler.postDelayed((Runnable)this, 1000L);
        }
    }

    abstract class TimerTaskBase {
        protected Handler handler = new Handler(Looper.getMainLooper());
        protected TextView timerView;
        protected boolean alive = false;
        protected long recordingTimeSeconds = 0L;
        protected long recordingTimeMinutes = 0L;

        public TimerTaskBase(TextView timerView) {
            this.timerView = timerView;
        }

        abstract void stop();

        abstract void start();
    }

    public static interface PickerItemClickListener {
        public void onItemClick(Uri var1);
    }

    public static interface SettingsClickListener {
        public void onSettingsClick();
    }
}

