/*
 * Decompiled with CFR 0.152.
 */
package com.sandrios.sandriosCamera.internal.ui.camera2;

import android.annotation.TargetApi;
import android.media.CamcorderProfile;
import com.sandrios.sandriosCamera.internal.configuration.ConfigurationProvider;
import com.sandrios.sandriosCamera.internal.controller.CameraController;
import com.sandrios.sandriosCamera.internal.controller.impl.Camera2Controller;
import com.sandrios.sandriosCamera.internal.controller.view.CameraView;
import com.sandrios.sandriosCamera.internal.ui.BaseSandriosActivity;
import com.sandrios.sandriosCamera.internal.ui.model.PhotoQualityOption;
import com.sandrios.sandriosCamera.internal.ui.model.VideoQualityOption;
import com.sandrios.sandriosCamera.internal.utils.CameraHelper;
import java.util.ArrayList;

@TargetApi(value=21)
public class Camera2Activity
extends BaseSandriosActivity<String> {
    @Override
    public CameraController<String> createCameraController(CameraView cameraView, ConfigurationProvider configurationProvider) {
        return new Camera2Controller(cameraView, configurationProvider);
    }

    @Override
    protected CharSequence[] getVideoQualityOptions() {
        ArrayList<VideoQualityOption> videoQualities = new ArrayList<VideoQualityOption>();
        if (this.getMinimumVideoDuration() > 0) {
            videoQualities.add(new VideoQualityOption(10, CameraHelper.getCamcorderProfile(10, (String)this.getCameraController().getCurrentCameraId()), this.getMinimumVideoDuration()));
        }
        CamcorderProfile camcorderProfile = CameraHelper.getCamcorderProfile(13, (String)this.getCameraController().getCurrentCameraId());
        double videoDuration = CameraHelper.calculateApproximateVideoDuration(camcorderProfile, this.getVideoFileSize());
        videoQualities.add(new VideoQualityOption(13, camcorderProfile, videoDuration));
        camcorderProfile = CameraHelper.getCamcorderProfile(12, (String)this.getCameraController().getCurrentCameraId());
        videoDuration = CameraHelper.calculateApproximateVideoDuration(camcorderProfile, this.getVideoFileSize());
        videoQualities.add(new VideoQualityOption(12, camcorderProfile, videoDuration));
        camcorderProfile = CameraHelper.getCamcorderProfile(11, (String)this.getCameraController().getCurrentCameraId());
        videoDuration = CameraHelper.calculateApproximateVideoDuration(camcorderProfile, this.getVideoFileSize());
        videoQualities.add(new VideoQualityOption(11, camcorderProfile, videoDuration));
        CharSequence[] array = new CharSequence[videoQualities.size()];
        videoQualities.toArray(array);
        return array;
    }

    @Override
    protected CharSequence[] getPhotoQualityOptions() {
        ArrayList<PhotoQualityOption> photoQualities = new ArrayList<PhotoQualityOption>();
        photoQualities.add(new PhotoQualityOption(14, this.getCameraController().getCameraManager().getPhotoSizeForQuality(14)));
        photoQualities.add(new PhotoQualityOption(13, this.getCameraController().getCameraManager().getPhotoSizeForQuality(13)));
        photoQualities.add(new PhotoQualityOption(12, this.getCameraController().getCameraManager().getPhotoSizeForQuality(12)));
        photoQualities.add(new PhotoQualityOption(15, this.getCameraController().getCameraManager().getPhotoSizeForQuality(15)));
        CharSequence[] array = new CharSequence[photoQualities.size()];
        photoQualities.toArray(array);
        return array;
    }
}

