/*
 * Decompiled with CFR 0.152.
 */
package com.sandrios.sandriosCamera.internal.ui.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.annotation.NonNull;
import android.view.SurfaceHolder;
import android.view.SurfaceView;

@SuppressLint(value={"ViewConstructor"})
public class AutoFitSurfaceView
extends SurfaceView {
    private static final String TAG = "AutoFitSurfaceView";
    private final SurfaceHolder surfaceHolder = this.getHolder();
    private int ratioWidth;
    private int ratioHeight;

    public AutoFitSurfaceView(@NonNull Context context, SurfaceHolder.Callback callback) {
        super(context);
        this.surfaceHolder.addCallback(callback);
        this.surfaceHolder.setType(3);
    }

    public void setAspectRatio(int width, int height) {
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("Size cannot be negative.");
        }
        this.ratioWidth = width;
        this.ratioHeight = height;
        this.requestLayout();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = AutoFitSurfaceView.resolveSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec);
        int height = AutoFitSurfaceView.resolveSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec);
        if (0 == this.ratioWidth || 0 == this.ratioHeight) {
            this.setMeasuredDimension(width, height);
        } else if ((float)width < (float)height * ((float)this.ratioWidth / (float)this.ratioHeight)) {
            this.setMeasuredDimension(width, (int)((float)width * ((float)this.ratioWidth / (float)this.ratioHeight)));
        } else {
            this.setMeasuredDimension((int)((float)height * ((float)this.ratioWidth / (float)this.ratioHeight)), height);
        }
    }
}

