/*
 * Decompiled with CFR 0.152.
 */
package com.sandrios.sandriosCamera.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.IntRange;
import com.gun0912.tedpermission.PermissionListener;
import com.gun0912.tedpermission.TedPermission;
import com.sandrios.sandriosCamera.internal.configuration.SandriosCameraConfiguration;
import com.sandrios.sandriosCamera.internal.ui.camera.Camera1Activity;
import com.sandrios.sandriosCamera.internal.ui.camera2.Camera2Activity;
import com.sandrios.sandriosCamera.internal.utils.CameraHelper;
import java.util.ArrayList;

public class SandriosCamera {
    private SandriosCameraConfiguration sandriosCameraConfiguration;

    public SandriosCamera(Activity activity, @IntRange(from=0L) int requestCode) {
        SandriosCameraConfiguration.Builder builder = new SandriosCameraConfiguration.Builder(activity, requestCode);
        this.sandriosCameraConfiguration = builder.build();
    }

    public SandriosCamera(SandriosCameraConfiguration cameraConfiguration) {
        this.sandriosCameraConfiguration = cameraConfiguration;
    }

    public void launchCamera() {
        if (this.sandriosCameraConfiguration == null || this.sandriosCameraConfiguration.getActivity() == null) {
            return;
        }
        new TedPermission((Context)this.sandriosCameraConfiguration.getActivity()).setPermissionListener(new PermissionListener(){

            public void onPermissionGranted() {
                Intent cameraIntent = CameraHelper.hasCamera2((Context)SandriosCamera.this.sandriosCameraConfiguration.getActivity()) ? new Intent((Context)SandriosCamera.this.sandriosCameraConfiguration.getActivity(), Camera2Activity.class) : new Intent((Context)SandriosCamera.this.sandriosCameraConfiguration.getActivity(), Camera1Activity.class);
                cameraIntent.putExtra("com.sandrios.sandriosCamera.request_code", SandriosCamera.this.sandriosCameraConfiguration.getRequestCode());
                if (SandriosCamera.this.sandriosCameraConfiguration.getMediaAction() > 0) {
                    cameraIntent.putExtra("com.sandrios.sandriosCamera.media_action", SandriosCamera.this.sandriosCameraConfiguration.getMediaAction());
                }
                if (SandriosCamera.this.sandriosCameraConfiguration.getMediaQuality() > 0) {
                    cameraIntent.putExtra("com.sandrios.sandriosCamera.camera_media_quality", SandriosCamera.this.sandriosCameraConfiguration.getMediaQuality());
                }
                if (SandriosCamera.this.sandriosCameraConfiguration.getVideoDuration() > 0) {
                    cameraIntent.putExtra("com.sandrios.sandriosCamera.video_duration", SandriosCamera.this.sandriosCameraConfiguration.getVideoDuration());
                }
                if (SandriosCamera.this.sandriosCameraConfiguration.getVideoFileSize() > 0L) {
                    cameraIntent.putExtra("com.sandrios.sandriosCamera.camera_video_file_size", SandriosCamera.this.sandriosCameraConfiguration.getVideoFileSize());
                }
                if (SandriosCamera.this.sandriosCameraConfiguration.getMinimumVideoDuration() > 0) {
                    cameraIntent.putExtra("com.sandrios.sandriosCamera.minimum.video_duration", SandriosCamera.this.sandriosCameraConfiguration.getMinimumVideoDuration());
                }
                cameraIntent.putExtra("com.sandrios.sandriosCamera.show_picker", SandriosCamera.this.sandriosCameraConfiguration.shouldShowPicker());
                SandriosCamera.this.sandriosCameraConfiguration.getActivity().startActivityForResult(cameraIntent, SandriosCamera.this.sandriosCameraConfiguration.getRequestCode());
            }

            public void onPermissionDenied(ArrayList<String> deniedPermissions) {
            }
        }).setPermissions(new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.RECORD_AUDIO"}).check();
    }
}

