/*
 * Decompiled with CFR 0.152.
 */
package com.sandrios.sandriosCamera.internal.ui.view;

import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageButton;
import com.sandrios.sandriosCamera.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class FlashSwitchView
extends ImageButton {
    public static final int FLASH_ON = 0;
    public static final int FLASH_OFF = 1;
    public static final int FLASH_AUTO = 2;
    private int currentMode = 2;
    private FlashModeSwitchListener switchListener;
    private Drawable flashOnDrawable;
    private Drawable flashOffDrawable;
    private Drawable flashAutoDrawable;
    private int tintColor = -1;

    public FlashSwitchView(@NonNull Context context) {
        this(context, null);
    }

    public FlashSwitchView(@NonNull Context context, AttributeSet attrs) {
        super(context, attrs);
        this.flashOnDrawable = ContextCompat.getDrawable((Context)context, (int)R.drawable.ic_flash_on_white);
        this.flashOffDrawable = ContextCompat.getDrawable((Context)context, (int)R.drawable.ic_flash_off_white);
        this.flashAutoDrawable = ContextCompat.getDrawable((Context)context, (int)R.drawable.ic_flash_auto_white);
        this.init();
    }

    private void init() {
        this.setBackgroundColor(0);
        this.setOnClickListener(new FlashButtonClickListener());
        this.setIcon();
    }

    private void setIcon() {
        if (1 == this.currentMode) {
            this.setImageDrawable(this.flashOffDrawable);
        } else if (0 == this.currentMode) {
            this.setImageDrawable(this.flashOnDrawable);
        } else {
            this.setImageDrawable(this.flashAutoDrawable);
        }
    }

    private void setIconsTint(@ColorInt int tintColor) {
        this.tintColor = tintColor;
        this.flashOnDrawable.setColorFilter(tintColor, PorterDuff.Mode.MULTIPLY);
        this.flashOffDrawable.setColorFilter(tintColor, PorterDuff.Mode.MULTIPLY);
        this.flashAutoDrawable.setColorFilter(tintColor, PorterDuff.Mode.MULTIPLY);
    }

    public void setFlashMode(int mode) {
        this.currentMode = mode;
        this.setIcon();
    }

    public int getCurrentFlasMode() {
        return this.currentMode;
    }

    public void setFlashSwitchListener(@NonNull FlashModeSwitchListener switchListener) {
        this.switchListener = switchListener;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (Build.VERSION.SDK_INT > 10) {
            if (enabled) {
                this.setAlpha(1.0f);
            } else {
                this.setAlpha(0.5f);
            }
        }
    }

    private class FlashButtonClickListener
    implements View.OnClickListener {
        private FlashButtonClickListener() {
        }

        public void onClick(View v) {
            if (2 == FlashSwitchView.this.currentMode) {
                FlashSwitchView.this.currentMode = 1;
            } else if (1 == FlashSwitchView.this.currentMode) {
                FlashSwitchView.this.currentMode = 0;
            } else if (0 == FlashSwitchView.this.currentMode) {
                FlashSwitchView.this.currentMode = 2;
            }
            FlashSwitchView.this.setIcon();
            if (FlashSwitchView.this.switchListener != null) {
                FlashSwitchView.this.switchListener.onFlashModeChanged(FlashSwitchView.this.currentMode);
            }
        }
    }

    public static interface FlashModeSwitchListener {
        public void onFlashModeChanged(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FlashMode {
    }
}

