/*
 * Decompiled with CFR 0.152.
 */
package com.sandrios.sandriosCamera.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.IntRange;
import android.support.annotation.RequiresPermission;
import com.sandrios.sandriosCamera.internal.configuration.SandriosCameraConfiguration;
import com.sandrios.sandriosCamera.internal.ui.camera.Camera1Activity;
import com.sandrios.sandriosCamera.internal.ui.camera2.Camera2Activity;
import com.sandrios.sandriosCamera.internal.utils.CameraHelper;

public class SandriosCamera {
    private SandriosCameraConfiguration sandriosCameraConfiguration;

    public SandriosCamera(Activity activity, @IntRange(from=0L) int requestCode) {
        SandriosCameraConfiguration.Builder builder = new SandriosCameraConfiguration.Builder(activity, requestCode);
        this.sandriosCameraConfiguration = builder.build();
    }

    public SandriosCamera(SandriosCameraConfiguration cameraConfiguration) {
        this.sandriosCameraConfiguration = cameraConfiguration;
    }

    @RequiresPermission(value="android.permission.CAMERA")
    public void launchCamera() {
        if (this.sandriosCameraConfiguration == null || this.sandriosCameraConfiguration.getActivity() == null) {
            return;
        }
        Intent cameraIntent = CameraHelper.hasCamera2((Context)this.sandriosCameraConfiguration.getActivity()) ? new Intent((Context)this.sandriosCameraConfiguration.getActivity(), Camera2Activity.class) : new Intent((Context)this.sandriosCameraConfiguration.getActivity(), Camera1Activity.class);
        cameraIntent.putExtra("com.sandrios.sandriosCamera.request_code", this.sandriosCameraConfiguration.getRequestCode());
        if (this.sandriosCameraConfiguration.getMediaAction() > 0) {
            cameraIntent.putExtra("com.sandrios.sandriosCamera.media_action", this.sandriosCameraConfiguration.getMediaAction());
        }
        if (this.sandriosCameraConfiguration.getMediaQuality() > 0) {
            cameraIntent.putExtra("com.sandrios.sandriosCamera.camera_media_quality", this.sandriosCameraConfiguration.getMediaQuality());
        }
        if (this.sandriosCameraConfiguration.getVideoDuration() > 0) {
            cameraIntent.putExtra("com.sandrios.sandriosCamera.video_duration", this.sandriosCameraConfiguration.getVideoDuration());
        }
        if (this.sandriosCameraConfiguration.getVideoFileSize() > 0L) {
            cameraIntent.putExtra("com.sandrios.sandriosCamera.camera_video_file_size", this.sandriosCameraConfiguration.getVideoFileSize());
        }
        if (this.sandriosCameraConfiguration.getMinimumVideoDuration() > 0) {
            cameraIntent.putExtra("com.sandrios.sandriosCamera.minimum.video_duration", this.sandriosCameraConfiguration.getMinimumVideoDuration());
        }
        cameraIntent.putExtra("com.sandrios.sandriosCamera.show_picker", this.sandriosCameraConfiguration.shouldShowPicker());
        this.sandriosCameraConfiguration.getActivity().startActivityForResult(cameraIntent, this.sandriosCameraConfiguration.getRequestCode());
    }
}

