/*
 * Decompiled with CFR 0.152.
 */
package com.sandflow.smpte.util;

import java.util.Arrays;
import java.util.regex.Pattern;

public class UMID {
    private static final Pattern URN_PATTERN = Pattern.compile("urn:smpte:umid:[a-fA-F0-9]{8}(?:\\.[a-fA-F0-9]{8}){7}");
    private byte[] value;
    static final char[] HEXMAP = "0123456789abcdef".toCharArray();
    static final char[] URNTEMPLATE = "urn:smpte:umid:060A2B34.01010105.01010D20.13000000.D2C9036C.8F195343.AB7014D2.D718BFDA".toCharArray();

    public static UMID fromURN(String urn) {
        byte[] umid = new byte[32];
        if (URN_PATTERN.matcher(urn).matches()) {
            int i = 0;
            while (i < 8) {
                int j = 0;
                while (j < 4) {
                    umid[4 * i + j] = (byte)Integer.parseInt(urn.substring(15 + i * 9 + 2 * j, 15 + i * 9 + 2 * j + 2), 16);
                    ++j;
                }
                ++i;
            }
            return new UMID(umid);
        }
        return null;
    }

    private UMID() {
        this.value = new byte[32];
    }

    public UMID(byte[] umid) {
        this.value = Arrays.copyOf(umid, 32);
    }

    public byte[] getValue() {
        return this.value;
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UMID other = (UMID)obj;
        return Arrays.equals(this.value, other.value);
    }

    public String toString() {
        char[] out = Arrays.copyOf(URNTEMPLATE, URNTEMPLATE.length);
        int i = 0;
        while (i < 8) {
            int j = 0;
            while (j < 4) {
                int v = this.value[4 * i + j] & 0xFF;
                out[15 + 9 * i + 2 * j] = HEXMAP[v >>> 4];
                out[15 + 9 * i + 2 * j + 1] = HEXMAP[v & 0xF];
                ++j;
            }
            ++i;
        }
        return new String(out);
    }
}

