/*
 * Decompiled with CFR 0.152.
 */
package com.sandflow.smpte.util;

import com.sandflow.smpte.util.AUID;
import com.sandflow.smpte.util.UL;
import com.sandflow.smpte.util.UUID;
import java.util.Arrays;

public class IDAU {
    private byte[] value;

    public static IDAU fromURN(String urn) {
        if (urn == null) {
            return null;
        }
        if (urn.startsWith("urn:smpte:ul:")) {
            return new IDAU(UL.fromURN(urn));
        }
        if (urn.startsWith("urn:uuid:")) {
            return new IDAU(UUID.fromURN(urn));
        }
        return null;
    }

    private IDAU() {
    }

    public IDAU(byte[] idau) {
        this.value = Arrays.copyOf(idau, 16);
    }

    public IDAU(UL ul) {
        this.value = new byte[16];
        System.arraycopy(ul.getValue(), 8, this.value, 0, 8);
        System.arraycopy(ul.getValue(), 0, this.value, 8, 8);
    }

    public IDAU(UUID uuid) {
        this.value = Arrays.copyOf(uuid.getValue(), 16);
    }

    public boolean equals(Object idau) {
        if (!(idau instanceof IDAU)) {
            return false;
        }
        return Arrays.equals(((IDAU)idau).value, this.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    public String toString() {
        if (this.isUL()) {
            return this.asUL().toString();
        }
        return this.asUUID().toString();
    }

    public boolean isUL() {
        return (this.value[9] & 0x80) == 0;
    }

    public boolean isUUID() {
        return !this.isUL();
    }

    public UUID asUUID() {
        if (this.isUL()) {
            return null;
        }
        return new UUID(this.value);
    }

    public AUID asAUID() {
        byte[] auid = new byte[16];
        System.arraycopy(this.value, 8, auid, 0, 8);
        System.arraycopy(this.value, 0, auid, 8, 8);
        return new AUID(auid);
    }

    public UL asUL() {
        return this.isUL() ? this.asAUID().asUL() : null;
    }
}

