/*
 * Decompiled with CFR 0.152.
 */
package com.sandflow.smpte.regxml.dict.importers;

import com.sandflow.smpte.register.ElementsRegister;
import com.sandflow.smpte.register.GroupsRegister;
import com.sandflow.smpte.register.TypesRegister;
import com.sandflow.smpte.regxml.dict.MetaDictionaryCollection;
import com.sandflow.smpte.regxml.dict.definitions.CharacterTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.ClassDefinition;
import com.sandflow.smpte.regxml.dict.definitions.Definition;
import com.sandflow.smpte.regxml.dict.definitions.EnumerationTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.ExtendibleEnumerationTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.FixedArrayTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.FloatTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.IndirectTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.IntegerTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.LensSerialFloatTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.OpaqueTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.PropertyAliasDefinition;
import com.sandflow.smpte.regxml.dict.definitions.PropertyDefinition;
import com.sandflow.smpte.regxml.dict.definitions.RecordTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.RenameTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.SetTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.StreamTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.StringTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.StrongReferenceTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.VariableArrayTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.WeakReferenceTypeDefinition;
import com.sandflow.smpte.regxml.dict.exceptions.DuplicateSymbolException;
import com.sandflow.smpte.util.AUID;
import com.sandflow.smpte.util.UL;
import com.sandflow.util.events.BasicEvent;
import com.sandflow.util.events.Event;
import com.sandflow.util.events.EventHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;

public class RegisterImporter {
    private static final Logger LOGGER = Logger.getLogger(RegisterImporter.class.getName());

    static void handleEvent(EventHandler handler, Event evt) throws Exception {
        if (handler != null ? !handler.handle(evt) || evt.getSeverity() == Event.Severity.FATAL : evt.getSeverity() == Event.Severity.ERROR || evt.getSeverity() == Event.Severity.FATAL) {
            throw new Exception(evt.getMessage());
        }
    }

    public static MetaDictionaryCollection fromRegister(TypesRegister tr, GroupsRegister gr, ElementsRegister er) throws Exception {
        EventHandler handler = new EventHandler(){

            @Override
            public boolean handle(Event evt) {
                switch (evt.getSeverity()) {
                    case ERROR: 
                    case FATAL: {
                        LOGGER.severe(evt.getMessage());
                        break;
                    }
                    case INFO: {
                        LOGGER.info(evt.getMessage());
                        break;
                    }
                    case WARN: {
                        LOGGER.warning(evt.getMessage());
                    }
                }
                return true;
            }
        };
        return RegisterImporter.fromRegister(tr, gr, er, handler);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public static MetaDictionaryCollection fromRegister(TypesRegister tr, GroupsRegister gr, ElementsRegister er, EventHandler evthandler) throws Exception {
        defs = new LinkedHashMap<AUID, ArrayList<Definition>>();
        isReferencedBy = new HashMap<AUID, HashSet<AUID>>();
        for (GroupsRegister.Entry group : gr.getEntries()) {
            if (group.getKind().equals((Object)GroupsRegister.Entry.Kind.NODE) || group.getUL().isClass15() || !group.getKlvSyntax().contains((byte)83)) continue;
            cdef = new ClassDefinition();
            if (group.isConcrete() != null) {
                cdef.setConcrete(group.isConcrete());
            } else {
                cdef.setConcrete(true);
            }
            cdef.setDescription(group.getDefinition());
            cdef.setName(group.getName());
            cdef.setSymbol(group.getSymbol());
            cdef.setNamespace(group.getNamespaceName());
            if (group.getParent() != null) {
                cdef.setParentClass(new AUID(group.getParent()));
            }
            cdef.setIdentification(new AUID(group.getUL()));
            for (GroupsRegister.Entry.Record child : group.getContents()) {
                id = new AUID(child.getItem());
                pdef = null;
                if (defs.containsKey(id)) {
                    padef = new PropertyAliasDefinition();
                    padef.setOriginalProperty((AUID)id);
                    pdef = padef;
                } else {
                    pdef = new PropertyDefinition();
                }
                pdef.setIdentification((AUID)id);
                pdef.setOptional(child.getOptional());
                if (child.getUniqueID() != null) {
                    pdef.setUniqueIdentifier(child.getUniqueID());
                }
                pdef.setLocalIdentification((int)(child.getLocalTag() == null ? 0L : child.getLocalTag()));
                element = er.getEntryByUL(child.getItem());
                if (element == null) {
                    evt = new RegisterEvent(EventKind.UNKNOWN_ELEMENT, String.format("Undefined Element %s for Group %s", new Object[]{child.getItem(), group.getUL()}));
                    RegisterImporter.handleEvent(evthandler, evt);
                    continue;
                }
                pdef.setDescription(element.getDefinition());
                pdef.setName(element.getName());
                pdef.setSymbol(element.getSymbol());
                if (element.getTypeUL() == null) {
                    evt = new RegisterEvent(EventKind.UNKNOWN_TYPE, String.format("Missing Type UL at Element %s for Group %s", new Object[]{child.getItem(), group.getUL()}));
                    RegisterImporter.handleEvent(evthandler, evt);
                    continue;
                }
                pdef.setType(new AUID(element.getTypeUL()));
                pdef.setMemberOf(cdef.getIdentification());
                pdef.setNamespace(element.getNamespaceName());
                RegisterImporter._add(defs, pdef);
                hs /* !! */  = isReferencedBy.get(pdef.getType());
                if (hs /* !! */  == null) {
                    hs /* !! */  = new HashSet<E>();
                    isReferencedBy.put(pdef.getType(), hs /* !! */ );
                }
                hs /* !! */ .add(pdef.getIdentification());
            }
            RegisterImporter._add(defs, cdef);
        }
        for (TypesRegister.Entry type : tr.getEntries()) {
            block47: {
                block59: {
                    block58: {
                        block57: {
                            block56: {
                                block55: {
                                    block54: {
                                        block53: {
                                            block52: {
                                                block51: {
                                                    block50: {
                                                        block49: {
                                                            block48: {
                                                                block46: {
                                                                    if (!type.getKind().equals((Object)TypesRegister.Entry.Kind.LEAF)) continue;
                                                                    tdef = null;
                                                                    references = new HashSet<AUID>();
                                                                    if (!"Rename".equals(type.getTypeKind())) break block46;
                                                                    tdef = new RenameTypeDefinition();
                                                                    tdef.setRenamedType(new AUID(type.getBaseType()));
                                                                    references.add(tdef.getRenamedType());
                                                                    break block47;
                                                                }
                                                                if (!"Integer".equals(type.getTypeKind())) break block48;
                                                                tdef = new IntegerTypeDefinition();
                                                                ((IntegerTypeDefinition)tdef).setSigned(type.getTypeQualifiers().contains((Object)TypesRegister.Entry.TypeQualifiers.isSigned));
                                                                switch (type.getTypeSize().intValue()) {
                                                                    case 1: {
                                                                        ((IntegerTypeDefinition)tdef).setSize(IntegerTypeDefinition.Size.ONE);
                                                                        break block47;
                                                                    }
                                                                    case 2: {
                                                                        ((IntegerTypeDefinition)tdef).setSize(IntegerTypeDefinition.Size.TWO);
                                                                        break block47;
                                                                    }
                                                                    case 4: {
                                                                        ((IntegerTypeDefinition)tdef).setSize(IntegerTypeDefinition.Size.FOUR);
                                                                        break block47;
                                                                    }
                                                                    case 8: {
                                                                        ((IntegerTypeDefinition)tdef).setSize(IntegerTypeDefinition.Size.EIGHT);
                                                                        break block47;
                                                                    }
                                                                    default: {
                                                                        evt = new RegisterEvent(EventKind.BAD_TYPE_SIZE, String.format("Type size %d is not supported for Type UL %s.", new Object[]{type.getTypeSize().intValue(), type.getUL().toString()}));
                                                                        RegisterImporter.handleEvent(evthandler, evt);
                                                                        break;
                                                                    }
                                                                }
                                                                continue;
                                                            }
                                                            if (!"Float".equals(type.getTypeKind())) break block49;
                                                            tdef = new FloatTypeDefinition();
                                                            switch (type.getTypeSize().intValue()) {
                                                                case 2: {
                                                                    ((FloatTypeDefinition)tdef).setSize(FloatTypeDefinition.Size.HALF);
                                                                    break block47;
                                                                }
                                                                case 4: {
                                                                    ((FloatTypeDefinition)tdef).setSize(FloatTypeDefinition.Size.SINGLE);
                                                                    break block47;
                                                                }
                                                                case 8: {
                                                                    ((FloatTypeDefinition)tdef).setSize(FloatTypeDefinition.Size.DOUBLE);
                                                                    break block47;
                                                                }
                                                                default: {
                                                                    evt = new RegisterEvent(EventKind.BAD_TYPE_SIZE, String.format("Type size %d is not supported for Type UL %s.", new Object[]{type.getTypeSize().intValue(), type.getUL().toString()}));
                                                                    RegisterImporter.handleEvent(evthandler, evt);
                                                                    break;
                                                                }
                                                            }
                                                            continue;
                                                        }
                                                        if (!"LensSerialFloat".equals(type.getTypeKind())) break block50;
                                                        tdef = new LensSerialFloatTypeDefinition();
                                                        break block47;
                                                    }
                                                    if (!"Record".equals(type.getTypeKind())) break block51;
                                                    tdef = new RecordTypeDefinition();
                                                    for (TypesRegister.Entry.Facet tchild : type.getFacets()) {
                                                        m = new RecordTypeDefinition.Member();
                                                        m.setName(tchild.getSymbol());
                                                        m.setType(new AUID(tchild.getType()));
                                                        ((RecordTypeDefinition)tdef).addMember(m);
                                                        references.add(m.getType());
                                                    }
                                                    break block47;
                                                }
                                                if (!"FixedArray".equals(type.getTypeKind())) break block52;
                                                tdef = new FixedArrayTypeDefinition();
                                                ((FixedArrayTypeDefinition)tdef).setElementType(new AUID(type.getBaseType()));
                                                ((FixedArrayTypeDefinition)tdef).setElementCount(type.getTypeSize().intValue());
                                                references.add(((FixedArrayTypeDefinition)tdef).getElementType());
                                                break block47;
                                            }
                                            if (!"VariableArray".equals(type.getTypeKind())) break block53;
                                            tdef = new VariableArrayTypeDefinition();
                                            ((VariableArrayTypeDefinition)tdef).setElementType(new AUID(type.getBaseType()));
                                            references.add(((VariableArrayTypeDefinition)tdef).getElementType());
                                            break block47;
                                        }
                                        if (!"Set".equals(type.getTypeKind())) break block54;
                                        tdef = new SetTypeDefinition();
                                        ((SetTypeDefinition)tdef).setElementType(new AUID(type.getBaseType()));
                                        references.add(((SetTypeDefinition)tdef).getElementType());
                                        break block47;
                                    }
                                    if (!"Indirect".equals(type.getTypeKind())) break block55;
                                    tdef = new IndirectTypeDefinition();
                                    break block47;
                                }
                                if (!"Opaque".equals(type.getTypeKind())) break block56;
                                tdef = new OpaqueTypeDefinition();
                                break block47;
                            }
                            if (!"Stream".equals(type.getTypeKind())) break block57;
                            tdef = new StreamTypeDefinition();
                            break block47;
                        }
                        if (!"WeakReference".equals(type.getTypeKind())) break block58;
                        tdef = new WeakReferenceTypeDefinition();
                        if (type.getBaseType() == null) {
                            throw new Exception(String.format("Missing base type for Type %s", new Object[]{type.getUL()}));
                        }
                        ((WeakReferenceTypeDefinition)tdef).setReferencedType(new AUID(type.getBaseType()));
                        references.add(((WeakReferenceTypeDefinition)tdef).getReferencedType());
                        for (TypesRegister.Entry.Facet f : type.getFacets()) {
                            ul = null;
                            if (f.getValue() != null) {
                                ul = UL.fromURN(f.getValue());
                            }
                            if (ul == null) {
                                evt = new RegisterEvent(EventKind.UNKNOWN_TARGET_SET, String.format("Missing Target Set UL at Type %s", new Object[]{type.getUL().toString()}));
                                RegisterImporter.handleEvent(evthandler, evt);
                                continue;
                            }
                            if (!((WeakReferenceTypeDefinition)tdef).getTargetSet().add(new AUID((UL)ul))) {
                                evt = new RegisterEvent(EventKind.DUP_TARGET_SET, String.format("Duplicate Target Set UL at Type %s", new Object[]{type.getUL().toString()}));
                                RegisterImporter.handleEvent(evthandler, evt);
                            }
                            references.add(new AUID((UL)ul));
                        }
                        break block47;
                    }
                    if (!"StrongReference".equals(type.getTypeKind())) break block59;
                    tdef = new StrongReferenceTypeDefinition();
                    ((StrongReferenceTypeDefinition)tdef).setReferenceType(new AUID(type.getBaseType()));
                    references.add(((StrongReferenceTypeDefinition)tdef).getReferencedType());
                    break block47;
                }
                if (!"Enumeration".equals(type.getTypeKind())) ** GOTO lbl210
                if (type.getBaseType().equals(UL.fromURN("urn:smpte:ul:060E2B34.01040101.01030100.00000000"))) {
                    ecelems = new ArrayList<ExtendibleEnumerationTypeDefinition.Element>();
                    tdef = new ExtendibleEnumerationTypeDefinition(ecelems);
                } else if (type.getBaseType().equalsWithMask(UL.fromURN("urn:smpte:ul:060e2b34.01040101.01010000.00000000"), 65472)) {
                    celems = new ArrayList<EnumerationTypeDefinition.Element>();
                    for (Object f : type.getFacets()) {
                        m = new EnumerationTypeDefinition.Element();
                        m.setName(f.getSymbol());
                        m.setValue(Integer.decode(f.getValue()));
                        celems.add(m);
                    }
                    tdef = new EnumerationTypeDefinition(celems);
                    ((EnumerationTypeDefinition)tdef).setElementType(new AUID(type.getBaseType()));
                    references.add(((EnumerationTypeDefinition)tdef).getElementType());
                } else {
                    evt = new RegisterEvent(EventKind.BAD_ENUM_TYPE, String.format("Enumeration base type %s is neither integer nor AUID for Type UL %s.", new Object[]{type.getBaseType(), type.getUL().toString()}));
                    RegisterImporter.handleEvent(evthandler, evt);
                    continue;
lbl210:
                    // 1 sources

                    if ("Character".equals(type.getTypeKind())) {
                        tdef = new CharacterTypeDefinition();
                    } else if ("String".equals(type.getTypeKind())) {
                        tdef = new StringTypeDefinition();
                        ((StringTypeDefinition)tdef).setElementType(new AUID(type.getBaseType()));
                        references.add(((StringTypeDefinition)tdef).getElementType());
                    } else {
                        evt = new RegisterEvent(EventKind.UNKNOWN_TYPE_KIND, String.format("Unknown type kind of %s for Type UL %s.", new Object[]{type.getTypeKind(), type.getUL().toString()}));
                        RegisterImporter.handleEvent(evthandler, evt);
                        continue;
                    }
                }
            }
            if (tdef != null) {
                tdef.setIdentification(new AUID(type.getUL()));
                tdef.setSymbol(type.getSymbol());
                tdef.setName(type.getName());
                tdef.setDescription(type.getDefinition());
                tdef.setNamespace(type.getNamespaceName());
                RegisterImporter._add(defs, tdef);
                f = references.iterator();
                while (f.hasNext()) {
                    aref = (AUID)f.next();
                    hs /* !! */  = isReferencedBy.get(aref);
                    if (hs /* !! */  == null) {
                        hs /* !! */  = new HashSet<E>();
                        isReferencedBy.put(aref, hs /* !! */ );
                    }
                    hs /* !! */ .add(tdef.getIdentification());
                }
                continue;
            }
            evt = new RegisterEvent(EventKind.TYPE_IMPORT_FAILED, String.format("Type UL %s import failed", new Object[]{type.getUL().toString()}));
            RegisterImporter.handleEvent(evthandler, evt);
        }
        for (AUID aref : isReferencedBy.keySet()) {
            if (defs.containsKey(aref)) continue;
            RegisterImporter._prune(defs, isReferencedBy, aref);
        }
        mds = new MetaDictionaryCollection();
        index = 0L;
        for (ArrayList defarray : defs.values()) {
            for (Definition def : defarray) {
                try {
                    mds.addDefinition(def);
                }
                catch (DuplicateSymbolException dse) {
                    newsym = "dup" + def.getSymbol() + index++;
                    evt = new RegisterEvent(EventKind.DUPLICATE_SYMBOL, String.format("Duplicate symbol %s (%s) renamed %s", new Object[]{def.getSymbol(), def.getNamespace().toASCIIString(), newsym}));
                    RegisterImporter.handleEvent(evthandler, evt);
                    def.setSymbol(newsym);
                    mds.addDefinition(def);
                }
            }
        }
        return mds;
    }

    private static void _add(Map<AUID, ArrayList<Definition>> defs, Definition def) {
        ArrayList<Definition> ad = defs.get(def.getIdentification());
        if (ad == null) {
            ad = new ArrayList();
            defs.put(def.getIdentification(), ad);
        }
        ad.add(def);
    }

    private static void _prune(Map<AUID, ArrayList<Definition>> defs, HashMap<AUID, HashSet<AUID>> isReferencedBy, AUID aref) {
        if (isReferencedBy.containsKey(aref)) {
            for (AUID entry : isReferencedBy.get(aref)) {
                RegisterImporter._prune(defs, isReferencedBy, entry);
            }
        }
        defs.remove(aref);
    }

    public static enum EventKind {
        UNKNOWN_ELEMENT(Event.Severity.WARN),
        UNKNOWN_TYPE(Event.Severity.WARN),
        UNKNOWN_TARGET_SET(Event.Severity.WARN),
        DUP_TARGET_SET(Event.Severity.WARN),
        UNKNOWN_TYPE_KIND(Event.Severity.ERROR),
        TYPE_IMPORT_FAILED(Event.Severity.ERROR),
        DUPLICATE_SYMBOL(Event.Severity.ERROR),
        BAD_ENUM_TYPE(Event.Severity.ERROR),
        BAD_TYPE_SIZE(Event.Severity.ERROR);

        public final Event.Severity severity;

        private EventKind(Event.Severity severity) {
            this.severity = severity;
        }
    }

    public static class RegisterEvent
    extends BasicEvent {
        public RegisterEvent(EventKind kind, String message) {
            super(kind.severity, kind, message);
        }
    }
}

