/*
 * Decompiled with CFR 0.152.
 */
package com.sandflow.smpte.regxml;

import com.sandflow.smpte.klv.Group;
import com.sandflow.smpte.klv.KLVInputStream;
import com.sandflow.smpte.klv.Triplet;
import com.sandflow.smpte.klv.exceptions.KLVException;
import com.sandflow.smpte.mxf.MXFInputStream;
import com.sandflow.smpte.mxf.Set;
import com.sandflow.smpte.regxml.dict.DefinitionResolver;
import com.sandflow.smpte.regxml.dict.definitions.CharacterTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.ClassDefinition;
import com.sandflow.smpte.regxml.dict.definitions.Definition;
import com.sandflow.smpte.regxml.dict.definitions.EnumerationTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.ExtendibleEnumerationTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.FixedArrayTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.FloatTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.IndirectTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.IntegerTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.LensSerialFloatTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.OpaqueTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.PropertyAliasDefinition;
import com.sandflow.smpte.regxml.dict.definitions.PropertyDefinition;
import com.sandflow.smpte.regxml.dict.definitions.RecordTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.RenameTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.SetTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.StreamTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.StringTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.StrongReferenceTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.VariableArrayTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.WeakReferenceTypeDefinition;
import com.sandflow.smpte.util.AUID;
import com.sandflow.smpte.util.HalfFloat;
import com.sandflow.smpte.util.IDAU;
import com.sandflow.smpte.util.UL;
import com.sandflow.smpte.util.UMID;
import com.sandflow.smpte.util.UUID;
import com.sandflow.util.events.BasicEvent;
import com.sandflow.util.events.Event;
import com.sandflow.util.events.EventHandler;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FragmentBuilder {
    private static final Logger LOG = Logger.getLogger(FragmentBuilder.class.getName());
    private static final UL INSTANCE_UID_ITEM_UL = UL.fromURN("urn:smpte:ul:060e2b34.01010101.01011502.00000000");
    private static final UL AUID_UL = UL.fromDotValue("06.0E.2B.34.01.04.01.01.01.03.01.00.00.00.00.00");
    private static final UL UUID_UL = UL.fromDotValue("06.0E.2B.34.01.04.01.01.01.03.03.00.00.00.00.00");
    private static final UL DateStruct_UL = UL.fromDotValue("06.0E.2B.34.01.04.01.01.03.01.05.00.00.00.00.00");
    private static final UL PackageID_UL = UL.fromDotValue("06.0E.2B.34.01.04.01.01.01.03.02.00.00.00.00.00");
    private static final UL Rational_UL = UL.fromDotValue("06.0E.2B.34.01.04.01.01.03.01.01.00.00.00.00.00");
    private static final UL TimeStruct_UL = UL.fromDotValue("06.0E.2B.34.01.04.01.01.03.01.06.00.00.00.00.00");
    private static final UL TimeStamp_UL = UL.fromDotValue("06.0E.2B.34.01.04.01.01.03.01.07.00.00.00.00.00");
    private static final UL VersionType_UL = UL.fromDotValue("06.0E.2B.34.01.04.01.01.03.01.03.00.00.00.00.00");
    private static final UL ByteOrder_UL = UL.fromDotValue("06.0E.2B.34.01.01.01.01.03.01.02.01.02.00.00.00");
    private static final UL Character_UL = UL.fromURN("urn:smpte:ul:060e2b34.01040101.01100100.00000000");
    private static final UL Char_UL = UL.fromURN("urn:smpte:ul:060e2b34.01040101.01100300.00000000");
    private static final UL UTF8Character_UL = UL.fromURN("urn:smpte:ul:060e2b34.01040101.01100500.00000000");
    private static final UL ProductReleaseType_UL = UL.fromURN("urn:smpte:ul:060e2b34.01040101.02010101.00000000");
    private static final UL Boolean_UL = UL.fromURN("urn:smpte:ul:060e2b34.01040101.01040100.00000000");
    private static final UL PrimaryPackage_UL = UL.fromURN("urn:smpte:ul:060e2b34.01010104.06010104.01080000");
    private static final UL LinkedGenerationID_UL = UL.fromURN("urn:smpte:ul:060e2b34.01010102.05200701.08000000");
    private static final UL GenerationID_UL = UL.fromURN("urn:smpte:ul:060e2b34.01010102.05200701.01000000");
    private static final UL ApplicationProductID_UL = UL.fromURN("urn:smpte:ul:060e2b34.01010102.05200701.07000000");
    private static final String REGXML_NS = "http://sandflow.com/ns/SMPTEST2001-1/baseline";
    private static final String XMLNS_NS = "http://www.w3.org/2000/xmlns/";
    private static final String BYTEORDER_BE = "BigEndian";
    private static final String BYTEORDER_LE = "LittleEndian";
    private static final String UID_ATTR = "uid";
    private static final String ACTUALTYPE_ATTR = "actualType";
    private static final String ESCAPE_ATTR = "escape";
    private final DefinitionResolver defresolver;
    private final Map<UUID, Set> setresolver;
    private final HashMap<URI, String> nsprefixes = new HashMap();
    private final AUIDNameResolver anameresolver;
    private final EventHandler evthandler;
    static final char[] HEXMAP = "0123456789abcdef".toCharArray();

    public FragmentBuilder(DefinitionResolver defresolver, Map<UUID, Set> setresolver, AUIDNameResolver anameresolver, EventHandler evthandler) {
        if (defresolver == null || setresolver == null) {
            throw new IllegalArgumentException();
        }
        this.defresolver = defresolver;
        this.setresolver = setresolver;
        this.anameresolver = anameresolver;
        this.evthandler = evthandler;
    }

    public FragmentBuilder(DefinitionResolver defresolver, Map<UUID, Set> setresolver, AUIDNameResolver anameresolver) {
        this(defresolver, setresolver, null, new EventHandler(){

            @Override
            public boolean handle(Event evt) {
                switch (evt.getSeverity()) {
                    case ERROR: 
                    case FATAL: {
                        LOG.severe(evt.getMessage());
                        break;
                    }
                    case INFO: {
                        LOG.info(evt.getMessage());
                        break;
                    }
                    case WARN: {
                        LOG.warning(evt.getMessage());
                    }
                }
                return true;
            }
        });
    }

    public FragmentBuilder(DefinitionResolver defresolver, Map<UUID, Set> setresolver) {
        this(defresolver, setresolver, null);
    }

    public DocumentFragment fromTriplet(Group group, Document document) throws KLVException, RuleException {
        DocumentFragment df = document.createDocumentFragment();
        this.applyRule3(df, group);
        for (Map.Entry<URI, String> entry : this.nsprefixes.entrySet()) {
            ((Element)df.getFirstChild()).setAttributeNS(XMLNS_NS, "xmlns:" + entry.getValue(), entry.getKey().toString());
        }
        return df;
    }

    private String getPrefix(URI ns) {
        String prefix = this.nsprefixes.get(ns);
        if (prefix == null) {
            prefix = "r" + this.nsprefixes.size();
            this.nsprefixes.put(ns, prefix);
        }
        return prefix;
    }

    String getPrefix(String ns) {
        try {
            return this.getPrefix(new URI(ns));
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    void addInformativeComment(Element element, String comment) {
        element.appendChild(element.getOwnerDocument().createComment(comment));
    }

    void handleEvent(FragmentEvent evt) throws RuleException {
        if (this.evthandler != null ? !this.evthandler.handle(evt) || evt.getSeverity() == Event.Severity.FATAL : evt.getSeverity() == Event.Severity.ERROR || evt.getSeverity() == Event.Severity.FATAL) {
            throw new RuleException(evt.getMessage());
        }
    }

    void applyRule3(Node node, Group group) throws RuleException {
        Definition definition = this.defresolver.getDefinition(new AUID(group.getKey()));
        if (definition == null) {
            this.handleEvent(new FragmentEvent(EventCodes.UNKNOWN_GROUP, String.format("Unknown Group UL %s", group.getKey().toString())));
            return;
        }
        if (definition.getIdentification().asUL().getVersion() != group.getKey().getVersion()) {
            this.handleEvent(new FragmentEvent(EventCodes.VERSION_BYTE_MISMATCH, String.format("Group UL %s in file does not have the same version as in the register (0x%02x)", group.getKey(), definition.getIdentification().asUL().getVersion())));
        }
        Element objelem = node.getOwnerDocument().createElementNS(definition.getNamespace().toString(), definition.getSymbol());
        node.appendChild(objelem);
        objelem.setPrefix(this.getPrefix(definition.getNamespace()));
        for (Triplet item : group.getItems()) {
            Definition itemdef = this.defresolver.getDefinition(item.getKey());
            if (itemdef == null) {
                this.handleEvent(new FragmentEvent(EventCodes.UNKNOWN_PROPERTY, String.format("Unknown property %s", item.getKey().toString()), String.format("Group %s", definition.getSymbol())));
                this.addInformativeComment(objelem, String.format("Unknown property\nKey: %s\nData: %s", item.getKey().toString(), this.bytesToString(item.getValue())));
                continue;
            }
            if (!(itemdef instanceof PropertyDefinition)) {
                FragmentEvent evt = new FragmentEvent(EventCodes.UNEXPECTED_DEFINITION, String.format("Item %s is not a property", item.getKey().toString()), String.format("Group %s", definition.getSymbol()));
                this.handleEvent(evt);
                this.addInformativeComment(objelem, evt.getReason());
                continue;
            }
            if (itemdef.getIdentification().asUL().getVersion() != item.getKey().asUL().getVersion()) {
                this.handleEvent(new FragmentEvent(EventCodes.VERSION_BYTE_MISMATCH, String.format("Property UL %s in file does not have the same version as in the register (0x%02x)", item.getKey().toString(), itemdef.getIdentification().asUL().getVersion()), String.format("Group %s", definition.getSymbol())));
            }
            Element elem = node.getOwnerDocument().createElementNS(itemdef.getNamespace().toString(), itemdef.getSymbol());
            objelem.appendChild(elem);
            elem.setPrefix(this.getPrefix(itemdef.getNamespace()));
            this.applyRule4(elem, new MXFInputStream(item.getValueAsStream()), itemdef);
            if (item.getKey().equals(INSTANCE_UID_ITEM_UL)) {
                String iidns = objelem.getLastChild().getNamespaceURI();
                String iidname = objelem.getLastChild().getLocalName();
                String iid = objelem.getLastChild().getTextContent();
                Node parent = node;
                while (parent.getNodeType() == 1) {
                    Node n = parent.getFirstChild();
                    while (n != null) {
                        if (n.getNodeType() == 1 && iidname.equals(n.getLocalName()) && iidns.equals(n.getNamespaceURI()) && iid.equals(n.getTextContent())) {
                            FragmentEvent evt = new FragmentEvent(EventCodes.CIRCULAR_STRONG_REFERENCE, String.format("Circular Strong Reference to Set UID %s", iid), String.format("Group %s", definition.getSymbol()));
                            this.handleEvent(evt);
                            this.addInformativeComment((Element)node, evt.getReason());
                            return;
                        }
                        n = n.getNextSibling();
                    }
                    parent = parent.getParentNode();
                }
            }
            if (!((PropertyDefinition)itemdef).isUniqueIdentifier()) continue;
            Attr attr = node.getOwnerDocument().createAttributeNS(REGXML_NS, UID_ATTR);
            attr.setPrefix(this.getPrefix(REGXML_NS));
            attr.setTextContent(objelem.getLastChild().getTextContent());
            objelem.setAttributeNodeNS(attr);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void applyRule4(Element element, MXFInputStream value, Definition propdef) throws RuleException {
        try {
            if (propdef.getIdentification().equals(ByteOrder_UL)) {
                int byteorder = value.readUnsignedShort();
                if (byteorder == 19789) {
                    element.setTextContent(BYTEORDER_BE);
                    return;
                } else {
                    if (byteorder != 18761) throw new RuleException("Unknown ByteOrder value.");
                    element.setTextContent(BYTEORDER_LE);
                    FragmentEvent evt = new FragmentEvent(EventCodes.UNEXPECTED_BYTE_ORDER, "ByteOrder property set to little-endian: either the property is setincorrectly or the file does not conform to MXF. Processing willassume a big-endian byte order going forward.");
                    this.handleEvent(evt);
                    this.addInformativeComment(element, evt.getReason());
                }
                return;
            } else {
                Definition typedef;
                if (propdef instanceof PropertyAliasDefinition) {
                    propdef = this.defresolver.getDefinition(((PropertyAliasDefinition)propdef).getOriginalProperty());
                }
                if ((typedef = this.findBaseDefinition(this.defresolver.getDefinition(((PropertyDefinition)propdef).getType()))) == null) {
                    FragmentEvent evt = new FragmentEvent(EventCodes.UNKNOWN_TYPE, String.format("Type %s not found", ((PropertyDefinition)propdef).getType().toString()), String.format("Property %s at Element %s", propdef.getSymbol(), element.getLocalName()));
                    this.handleEvent(evt);
                    this.addInformativeComment(element, evt.getReason());
                    return;
                }
                if (propdef.getIdentification().equals(PrimaryPackage_UL)) {
                    UUID uuid = value.readUUID();
                    Group g = this.setresolver.get(uuid);
                    if (g != null) {
                        boolean foundUniqueID = false;
                        for (Triplet item : g.getItems()) {
                            Definition itemdef = this.defresolver.getDefinition(item.getKey());
                            if (itemdef == null || !(itemdef instanceof PropertyDefinition) || !((PropertyDefinition)itemdef).isUniqueIdentifier()) continue;
                            this.applyRule4(element, new MXFInputStream(item.getValueAsStream()), itemdef);
                            return;
                        }
                        if (foundUniqueID) return;
                        FragmentEvent evt = new FragmentEvent(EventCodes.MISSING_UNIQUE, String.format("Target Primary Package with Instance UID %s has no IsUnique element.", uuid.toString()), String.format("Property %s at Element %s", propdef.getSymbol(), element.getLocalName()));
                        this.handleEvent(evt);
                        this.addInformativeComment(element, evt.getReason());
                        return;
                    } else {
                        FragmentEvent evt = new FragmentEvent(EventCodes.MISSING_PRIMARY_PACKAGE, String.format("Target Primary Package with Instance UID %s not found", uuid.toString()), String.format("Property %s at Element %s", propdef.getSymbol(), element.getLocalName()));
                        this.handleEvent(evt);
                        this.addInformativeComment(element, evt.getReason());
                    }
                    return;
                } else {
                    if (propdef.getIdentification().equals(LinkedGenerationID_UL) || propdef.getIdentification().equals(GenerationID_UL) || propdef.getIdentification().equals(ApplicationProductID_UL)) {
                        typedef = this.defresolver.getDefinition(new AUID(UUID_UL));
                    }
                    this.applyRule5(element, value, typedef);
                }
            }
            return;
        }
        catch (EOFException eof) {
            FragmentEvent evt = new FragmentEvent(EventCodes.VALUE_LENGTH_MISMATCH, "Value too short", String.format("Property %s at Element %s", propdef.getSymbol(), element.getLocalName()));
            this.handleEvent(evt);
            this.addInformativeComment(element, evt.getReason());
            return;
        }
        catch (IOException ioe) {
            throw new RuleException(ioe);
        }
    }

    void applyRule5(Element element, MXFInputStream value, Definition definition) throws RuleException, IOException {
        if (definition instanceof CharacterTypeDefinition) {
            this.applyRule5_1(element, value, (CharacterTypeDefinition)definition);
        } else if (definition instanceof EnumerationTypeDefinition) {
            this.applyRule5_2(element, value, (EnumerationTypeDefinition)definition);
        } else if (definition instanceof ExtendibleEnumerationTypeDefinition) {
            this.applyRule5_3(element, value, (ExtendibleEnumerationTypeDefinition)definition);
        } else if (definition instanceof FixedArrayTypeDefinition) {
            this.applyRule5_4(element, value, (FixedArrayTypeDefinition)definition);
        } else if (definition instanceof IndirectTypeDefinition) {
            this.applyRule5_5(element, value, (IndirectTypeDefinition)definition);
        } else if (definition instanceof IntegerTypeDefinition) {
            this.applyRule5_6(element, value, (IntegerTypeDefinition)definition);
        } else if (definition instanceof OpaqueTypeDefinition) {
            this.applyRule5_7(element, value, (OpaqueTypeDefinition)definition);
        } else if (definition instanceof RecordTypeDefinition) {
            this.applyRule5_8(element, value, (RecordTypeDefinition)definition);
        } else if (definition instanceof RenameTypeDefinition) {
            this.applyRule5_9(element, value, (RenameTypeDefinition)definition);
        } else if (definition instanceof SetTypeDefinition) {
            this.applyRule5_10(element, value, (SetTypeDefinition)definition);
        } else if (definition instanceof StreamTypeDefinition) {
            this.applyRule5_11(element, value, (StreamTypeDefinition)definition);
        } else if (definition instanceof StringTypeDefinition) {
            this.applyRule5_12(element, value, (StringTypeDefinition)definition);
        } else if (definition instanceof StrongReferenceTypeDefinition) {
            this.applyRule5_13(element, value, (StrongReferenceTypeDefinition)definition);
        } else if (definition instanceof VariableArrayTypeDefinition) {
            this.applyRule5_14(element, value, (VariableArrayTypeDefinition)definition);
        } else if (definition instanceof WeakReferenceTypeDefinition) {
            this.applyRule5_15(element, value, (WeakReferenceTypeDefinition)definition);
        } else if (definition instanceof FloatTypeDefinition) {
            this.applyRule5_alpha(element, value, (FloatTypeDefinition)definition);
        } else if (definition instanceof LensSerialFloatTypeDefinition) {
            this.applyRule5_beta(element, value, (LensSerialFloatTypeDefinition)definition);
        } else {
            throw new RuleException(String.format("Unknown Definition %s in Rule 5.", definition.getClass().toString()));
        }
    }

    private void readCharacters(Element element, MXFInputStream value, CharacterTypeDefinition definition, boolean isSingleChar) throws RuleException, IOException {
        int c;
        StringBuilder sb = new StringBuilder();
        InputStreamReader in = null;
        if (definition.getIdentification().equals(Character_UL)) {
            in = value.getByteOrder() == KLVInputStream.ByteOrder.BIG_ENDIAN ? new InputStreamReader((InputStream)value, "UTF-16BE") : new InputStreamReader((InputStream)value, "UTF-16LE");
        } else if (definition.getIdentification().equals(Char_UL)) {
            in = new InputStreamReader((InputStream)value, "US-ASCII");
        } else if (definition.getIdentification().equals(UTF8Character_UL)) {
            in = new InputStreamReader((InputStream)value, "UTF-8");
        } else {
            FragmentEvent evt = new FragmentEvent(EventCodes.UNSUPPORTED_CHAR_TYPE, String.format("Character type %s is not supported at Element %s", definition.getSymbol(), element.getLocalName()));
            this.handleEvent(evt);
            this.addInformativeComment(element, evt.getReason());
            return;
        }
        char[] chars = new char[32];
        while ((c = in.read(chars)) != -1) {
            sb.append(chars, 0, c);
        }
        StringBuilder esb = new StringBuilder();
        boolean isescaped = false;
        int i = 0;
        while (i < sb.length()) {
            char c2 = sb.charAt(i);
            if (c2 == '\u0000' && !isSingleChar) break;
            if (c2 == '\t' || c2 == '\n' || c2 >= ' ' && c2 <= '#' || c2 >= '%') {
                esb.append(c2);
            } else {
                isescaped = true;
                esb.append("$#x");
                esb.append(Integer.toString(c2, 16));
                esb.append(";");
            }
            ++i;
        }
        if (isescaped) {
            Attr attr = element.getOwnerDocument().createAttributeNS(REGXML_NS, ESCAPE_ATTR);
            attr.setPrefix(this.getPrefix(REGXML_NS));
            attr.setTextContent("true");
            element.setAttributeNodeNS(attr);
        }
        element.setTextContent(esb.toString());
    }

    void applyRule5_1(Element element, MXFInputStream value, CharacterTypeDefinition definition) throws RuleException, IOException {
        this.readCharacters(element, value, definition, true);
    }

    private byte[] fullyReadBytes(MXFInputStream value, int len) throws IOException {
        byte[] bytes = new byte[len];
        int br = 0;
        while (br < len) {
            int count = value.read(bytes, br, len - br);
            if (count < 0) break;
            br += count;
        }
        if (br < len) {
            bytes = Arrays.copyOf(bytes, br);
        }
        return bytes;
    }

    void applyRule5_2(Element element, MXFInputStream value, EnumerationTypeDefinition definition) throws RuleException, IOException {
        try {
            Definition bdef = this.findBaseDefinition(this.defresolver.getDefinition(definition.getElementType()));
            if (!(bdef instanceof IntegerTypeDefinition)) {
                FragmentEvent evt = new FragmentEvent(EventCodes.UNSUPPORTED_ENUM_TYPE, "Enum does not have an Integer base type.", String.format("Enum %s at Element %s", definition.getSymbol(), element.getLocalName()));
                this.handleEvent(evt);
                this.addInformativeComment(element, evt.getReason());
                return;
            }
            IntegerTypeDefinition idef = (IntegerTypeDefinition)bdef;
            int len = 0;
            if (definition.getIdentification().equals(ProductReleaseType_UL)) {
                len = 2;
            } else {
                switch (idef.getSize()) {
                    case ONE: {
                        len = 1;
                        break;
                    }
                    case TWO: {
                        len = 2;
                        break;
                    }
                    case FOUR: {
                        len = 4;
                        break;
                    }
                    case EIGHT: {
                        len = 8;
                    }
                }
            }
            byte[] val = this.fullyReadBytes(value, len);
            String str = null;
            if (val.length == 0) {
                str = "ERROR";
                FragmentEvent evt = new FragmentEvent(EventCodes.VALUE_LENGTH_MISMATCH, "No data", String.format("Enum %s at Element %s", definition.getSymbol(), element.getLocalName()));
                this.handleEvent(evt);
                this.addInformativeComment(element, evt.getReason());
            } else {
                FragmentEvent evt;
                BigInteger bi;
                BigInteger bigInteger = bi = idef.isSigned() ? new BigInteger(val) : new BigInteger(1, val);
                if (definition.getElementType().equals(Boolean_UL)) {
                    for (EnumerationTypeDefinition.Element e : definition.getElements()) {
                        if ((bi.intValue() != 0 || e.getValue() != 0) && (bi.intValue() == 0 || e.getValue() != 1)) continue;
                        str = e.getName();
                    }
                } else {
                    for (EnumerationTypeDefinition.Element e : definition.getElements()) {
                        if (e.getValue() != bi.intValue()) continue;
                        str = e.getName();
                    }
                }
                if (str == null) {
                    str = "UNDEFINED";
                    evt = new FragmentEvent(EventCodes.UNKNOWN_ENUM_VALUE, String.format("Undefined value %d", bi.intValue()), String.format("Enum %s at Element %s", definition.getSymbol(), element.getLocalName()));
                    this.handleEvent(evt);
                    this.addInformativeComment(element, evt.getReason());
                } else if (val.length != len) {
                    evt = new FragmentEvent(EventCodes.VALUE_LENGTH_MISMATCH, String.format("Incorrect length: expected %d and received %d", len, val.length), String.format("Enumeration %s at Element %s", definition.getSymbol(), element.getLocalName()));
                    this.handleEvent(evt);
                    this.addInformativeComment(element, evt.getReason());
                }
            }
            element.setTextContent(str);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    void appendCommentWithAUIDName(AUIDNameResolver anr, AUID auid, Element elem) {
        String ename;
        if (this.anameresolver != null && (ename = this.anameresolver.getLocalName(auid)) != null) {
            elem.appendChild(elem.getOwnerDocument().createComment(ename));
        }
    }

    void applyRule5_3(Element element, MXFInputStream value, ExtendibleEnumerationTypeDefinition definition) throws RuleException, IOException {
        try {
            UL ul = value.readUL();
            element.setTextContent(ul.toString());
            this.appendCommentWithAUIDName(this.anameresolver, new AUID(ul), element);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    void applyRule5_4(Element element, MXFInputStream value, FixedArrayTypeDefinition definition) throws RuleException, IOException {
        if (definition.getIdentification().equals(UUID_UL)) {
            UUID uuid = value.readUUID();
            element.setTextContent(uuid.toString());
        } else {
            Definition typedef = this.findBaseDefinition(this.defresolver.getDefinition(definition.getElementType()));
            this.applyCoreRule5_4(element, value, typedef, definition.getElementCount());
        }
    }

    void applyCoreRule5_4(Element element, MXFInputStream value, Definition typedef, int elementcount) throws RuleException, IOException {
        int i = 0;
        while (i < elementcount) {
            if (typedef instanceof StrongReferenceTypeDefinition) {
                this.applyRule5_13(element, value, (StrongReferenceTypeDefinition)typedef);
            } else {
                Element elem = element.getOwnerDocument().createElementNS(typedef.getNamespace().toString(), typedef.getSymbol());
                elem.setPrefix(this.getPrefix(typedef.getNamespace()));
                this.applyRule5(elem, value, typedef);
                element.appendChild(elem);
            }
            ++i;
        }
    }

    void applyRule5_5(Element element, MXFInputStream value, IndirectTypeDefinition definition) throws RuleException, IOException {
        KLVInputStream.ByteOrder bo;
        switch (value.readUnsignedByte()) {
            case 76: {
                bo = KLVInputStream.ByteOrder.LITTLE_ENDIAN;
                break;
            }
            case 66: {
                bo = KLVInputStream.ByteOrder.BIG_ENDIAN;
                break;
            }
            default: {
                throw new RuleException("Unknown Indirect Byte Order value.");
            }
        }
        MXFInputStream orderedval = new MXFInputStream(value, bo);
        IDAU idau = orderedval.readIDAU();
        if (idau == null) {
            FragmentEvent evt = new FragmentEvent(EventCodes.INVALID_IDAU, "Invalid IDAU", String.format("Indirect Type %s at Element %s", definition.getSymbol(), element.getLocalName()));
            this.handleEvent(evt);
            this.addInformativeComment(element, evt.getReason());
            return;
        }
        AUID auid = idau.asAUID();
        Definition def = this.defresolver.getDefinition(auid);
        if (def == null) {
            FragmentEvent evt = new FragmentEvent(EventCodes.UNKNOWN_TYPE, String.format("No definition found for indirect type %s.", auid.toString()), String.format("Indirect Type %s at Element %s", definition.getSymbol(), element.getLocalName()));
            this.handleEvent(evt);
            this.addInformativeComment(element, evt.getReason());
            return;
        }
        Attr attr = element.getOwnerDocument().createAttributeNS(REGXML_NS, ACTUALTYPE_ATTR);
        attr.setPrefix(this.getPrefix(REGXML_NS));
        attr.setTextContent(def.getSymbol());
        element.setAttributeNodeNS(attr);
        this.applyRule5(element, orderedval, def);
    }

    void applyRule5_6(Element element, MXFInputStream value, IntegerTypeDefinition definition) throws RuleException, IOException {
        block12: {
            try {
                int len = 0;
                switch (definition.getSize()) {
                    case ONE: {
                        len = 1;
                        break;
                    }
                    case TWO: {
                        len = 2;
                        break;
                    }
                    case FOUR: {
                        len = 4;
                        break;
                    }
                    case EIGHT: {
                        len = 8;
                    }
                }
                byte[] val = this.fullyReadBytes(value, len);
                if (val.length == 0) {
                    element.setTextContent("NaN");
                    FragmentEvent evt = new FragmentEvent(EventCodes.VALUE_LENGTH_MISMATCH, "No data", String.format("Integer %s at Element %s", definition.getSymbol(), element.getLocalName()));
                    this.handleEvent(evt);
                    this.addInformativeComment(element, evt.getReason());
                    break block12;
                }
                try {
                    BigInteger bi = definition.isSigned() ? new BigInteger(val) : new BigInteger(1, val);
                    element.setTextContent(bi.toString());
                    if (val.length != len) {
                        FragmentEvent evt = new FragmentEvent(EventCodes.VALUE_LENGTH_MISMATCH, String.format("Incorrect field length: expected %d and parsed %d.", len, val.length), String.format("Integer %s at Element %s", definition.getSymbol(), element.getLocalName()));
                        this.handleEvent(evt);
                        this.addInformativeComment(element, evt.getReason());
                    }
                }
                catch (NumberFormatException e) {
                    FragmentEvent evt = new FragmentEvent(EventCodes.INVALID_INTEGER_VALUE, "Invalid integer value", String.format("Integer %s at Element %s", definition.getSymbol(), element.getLocalName()));
                    this.handleEvent(evt);
                    this.addInformativeComment(element, evt.getReason());
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    void applyRule5_7(Element element, MXFInputStream value, OpaqueTypeDefinition definition) throws RuleException {
        throw new RuleException("Opaque types are not supported.");
    }

    String generateISO8601Time(int hour, int minutes, int seconds, int millis) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%02d:%02d:%02d", hour, minutes, seconds));
        if (millis != 0) {
            sb.append(String.format(".%03d", millis));
        }
        sb.append("Z");
        return sb.toString();
    }

    String generateISO8601Date(int year, int month, int day) {
        return String.format("%04d-%02d-%02d", year, month, day);
    }

    void applyRule5_8(Element element, MXFInputStream value, RecordTypeDefinition definition) throws RuleException, IOException {
        if (definition.getIdentification().equals(AUID_UL)) {
            AUID auid = value.readAUID();
            element.setTextContent(auid.toString());
            this.appendCommentWithAUIDName(this.anameresolver, auid, element);
        } else if (definition.getIdentification().equals(DateStruct_UL)) {
            int year = value.readUnsignedShort();
            int month = value.readUnsignedByte();
            int day = value.readUnsignedByte();
            element.setTextContent(this.generateISO8601Date(year, month, day));
        } else if (definition.getIdentification().equals(PackageID_UL)) {
            UMID umid = value.readUMID();
            element.setTextContent(umid.toString());
        } else if (definition.getIdentification().equals(Rational_UL)) {
            int numerator = value.readInt();
            int denominator = value.readInt();
            element.setTextContent(String.format("%d/%d", numerator, denominator));
        } else if (definition.getIdentification().equals(TimeStruct_UL)) {
            int hour = value.readUnsignedByte();
            int minute = value.readUnsignedByte();
            int second = value.readUnsignedByte();
            int fraction = value.readUnsignedByte();
            element.setTextContent(this.generateISO8601Time(hour, minute, second, 4 * fraction));
        } else if (definition.getIdentification().equals(TimeStamp_UL)) {
            int year = value.readUnsignedShort();
            int month = value.readUnsignedByte();
            int day = value.readUnsignedByte();
            int hour = value.readUnsignedByte();
            int minute = value.readUnsignedByte();
            int second = value.readUnsignedByte();
            int fraction = value.readUnsignedByte();
            element.setTextContent(String.valueOf(this.generateISO8601Date(year, month, day)) + "T" + this.generateISO8601Time(hour, minute, second, 4 * fraction));
        } else if (definition.getIdentification().equals(VersionType_UL)) {
            int major = value.readUnsignedByte();
            int minor = value.readUnsignedByte();
            element.setTextContent(String.format("%d.%d", major, minor));
        } else {
            for (RecordTypeDefinition.Member member : definition.getMembers()) {
                Definition itemdef = this.findBaseDefinition(this.defresolver.getDefinition(member.getType()));
                Element elem = element.getOwnerDocument().createElementNS(definition.getNamespace().toString(), member.getName());
                elem.setPrefix(this.getPrefix(definition.getNamespace()));
                this.applyRule5(elem, value, itemdef);
                element.appendChild(elem);
            }
        }
    }

    void applyRule5_9(Element element, MXFInputStream value, RenameTypeDefinition definition) throws RuleException, IOException {
        Definition rdef = this.defresolver.getDefinition(definition.getRenamedType());
        this.applyRule5(element, value, rdef);
    }

    void applyRule5_10(Element element, MXFInputStream value, SetTypeDefinition definition) throws RuleException, IOException {
        Definition typedef = this.findBaseDefinition(this.defresolver.getDefinition(definition.getElementType()));
        try {
            DataInputStream dis = new DataInputStream(value);
            long itemcount = (long)dis.readInt() & 0xFFFFFFFL;
            long itemlength = (long)dis.readInt() & 0xFFFFFFFL;
            this.applyCoreRule5_4(element, value, typedef, (int)itemcount);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    void applyRule5_11(Element element, MXFInputStream value, StreamTypeDefinition definition) throws RuleException {
        throw new RuleException("Rule 5.11 is not supported yet.");
    }

    void applyRule5_12(Element element, MXFInputStream value, StringTypeDefinition definition) throws RuleException, IOException {
        Definition chrdef = this.findBaseDefinition(this.defresolver.getDefinition(definition.getElementType()));
        if (!(chrdef instanceof CharacterTypeDefinition)) {
            FragmentEvent evt = new FragmentEvent(EventCodes.UNSUPPORTED_STRING_TYPE, String.format("Unsupported String with Element %s", chrdef.getSymbol()), String.format("String %s at Element %s", definition.getSymbol(), element.getLocalName()));
            this.handleEvent(evt);
            this.addInformativeComment(element, evt.getReason());
            return;
        }
        this.readCharacters(element, value, (CharacterTypeDefinition)chrdef, false);
    }

    void applyRule5_13(Element element, MXFInputStream value, StrongReferenceTypeDefinition definition) throws RuleException, IOException {
        Definition typedef = this.findBaseDefinition(this.defresolver.getDefinition(definition.getReferencedType()));
        if (!(typedef instanceof ClassDefinition)) {
            FragmentEvent evt = new FragmentEvent(EventCodes.INVALID_STRONG_REFERENCE_TYPE, String.format("Target %s of Strong Reference Type is not a class", typedef.getSymbol()), String.format("Type %s at Element %s", definition.getSymbol(), element.getLocalName()));
            this.handleEvent(evt);
            this.addInformativeComment(element, evt.getReason());
            return;
        }
        UUID uuid = value.readUUID();
        Group g = this.setresolver.get(uuid);
        if (g != null) {
            this.applyRule3(element, g);
        } else {
            FragmentEvent evt = new FragmentEvent(EventCodes.STRONG_REFERENCE_NOT_FOUND, String.format("Strong Reference target %s is not found", uuid.toString()), String.format("Type %s at Element %s", definition.getSymbol(), element.getLocalName()));
            this.handleEvent(evt);
            this.addInformativeComment(element, evt.getReason());
        }
    }

    void applyRule5_alpha(Element element, MXFInputStream value, FloatTypeDefinition definition) throws RuleException, IOException {
        try {
            DataInputStream dis = new DataInputStream(value);
            double val = 0.0;
            switch (definition.getSize()) {
                case HALF: {
                    val = HalfFloat.toDouble(dis.readUnsignedShort());
                    break;
                }
                case SINGLE: {
                    val = dis.readFloat();
                    break;
                }
                case DOUBLE: {
                    val = dis.readDouble();
                }
            }
            element.setTextContent(Double.toString(val));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    void applyRule5_beta(Element element, MXFInputStream value, LensSerialFloatTypeDefinition definition) throws RuleException {
        throw new RuleException("Lens serial floats not supported.");
    }

    Definition findBaseDefinition(Definition definition) {
        while (definition instanceof RenameTypeDefinition) {
            definition = this.defresolver.getDefinition(((RenameTypeDefinition)definition).getRenamedType());
        }
        return definition;
    }

    private Collection<PropertyDefinition> getAllMembersOf(ClassDefinition definition) {
        ClassDefinition cdef = definition;
        ArrayList<PropertyDefinition> props = new ArrayList<PropertyDefinition>();
        while (cdef != null) {
            for (AUID auid : this.defresolver.getMembersOf(cdef)) {
                props.add((PropertyDefinition)this.defresolver.getDefinition(auid));
            }
            cdef = cdef.getParentClass() != null ? (ClassDefinition)this.defresolver.getDefinition(cdef.getParentClass()) : null;
        }
        return props;
    }

    private String bytesToString(byte[] buffer) {
        char[] out = new char[2 * buffer.length];
        int j = 0;
        while (j < buffer.length) {
            int v = buffer[j] & 0xFF;
            out[j * 2] = HEXMAP[v >>> 4];
            out[j * 2 + 1] = HEXMAP[v & 0xF];
            ++j;
        }
        return new String(out);
    }

    void applyRule5_14(Element element, MXFInputStream value, VariableArrayTypeDefinition definition) throws RuleException, IOException {
        Definition typedef = this.findBaseDefinition(this.defresolver.getDefinition(definition.getElementType()));
        try {
            DataInputStream dis = new DataInputStream(value);
            if (definition.getSymbol().equals("DataValue")) {
                byte[] buffer = new byte[32];
                StringBuilder sb = new StringBuilder();
                int sz = 0;
                while ((sz = dis.read(buffer)) > -1) {
                    int j = 0;
                    while (j < sz) {
                        int v = buffer[j] & 0xFF;
                        sb.append(HEXMAP[v >>> 4]);
                        sb.append(HEXMAP[v & 0xF]);
                        ++j;
                    }
                }
                element.setTextContent(sb.toString());
            } else {
                Definition base = this.findBaseDefinition(typedef);
                if (base instanceof CharacterTypeDefinition || base.getName().contains("StringArray")) {
                    throw new RuleException("StringArray not supported.");
                }
                long itemcount = (long)dis.readInt() & 0xFFFFFFFL;
                long itemlength = (long)dis.readInt() & 0xFFFFFFFL;
                this.applyCoreRule5_4(element, value, typedef, (int)itemcount);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (EOFException eof) {
            FragmentEvent evt = new FragmentEvent(EventCodes.VALUE_LENGTH_MISMATCH, "Value too short", String.format("Array %s at Element %s", definition.getSymbol(), element.getLocalName()));
            this.handleEvent(evt);
            this.addInformativeComment(element, evt.getReason());
        }
    }

    void applyRule5_15(Element element, MXFInputStream value, WeakReferenceTypeDefinition typedefinition) throws RuleException {
        ClassDefinition classdef = (ClassDefinition)this.defresolver.getDefinition(typedefinition.getReferencedType());
        PropertyDefinition uniquepropdef = null;
        for (PropertyDefinition propdef : this.getAllMembersOf(classdef)) {
            if (!propdef.isUniqueIdentifier()) continue;
            uniquepropdef = propdef;
            break;
        }
        if (uniquepropdef == null) {
            FragmentEvent evt = new FragmentEvent(EventCodes.MISSING_UNIQUE, String.format("Weak reference target %s has no IsUnique element.", classdef.getSymbol()), String.format("Type %s at Element %s", typedefinition.getSymbol(), element.getLocalName()));
            this.handleEvent(evt);
            this.addInformativeComment(element, evt.getReason());
            return;
        }
        this.applyRule4(element, value, uniquepropdef);
    }

    public static interface AUIDNameResolver {
        public String getLocalName(AUID var1);
    }

    public static enum EventCodes {
        UNKNOWN_GROUP(Event.Severity.INFO),
        UNKNOWN_PROPERTY(Event.Severity.INFO),
        VERSION_BYTE_MISMATCH(Event.Severity.WARN),
        UNEXPECTED_DEFINITION(Event.Severity.ERROR),
        CIRCULAR_STRONG_REFERENCE(Event.Severity.ERROR),
        UNEXPECTED_BYTE_ORDER(Event.Severity.ERROR),
        UNKNOWN_TYPE(Event.Severity.ERROR),
        MISSING_UNIQUE(Event.Severity.ERROR),
        MISSING_PRIMARY_PACKAGE(Event.Severity.ERROR),
        VALUE_LENGTH_MISMATCH(Event.Severity.ERROR),
        UNSUPPORTED_CHAR_TYPE(Event.Severity.ERROR),
        UNSUPPORTED_ENUM_TYPE(Event.Severity.ERROR),
        UNKNOWN_ENUM_VALUE(Event.Severity.ERROR),
        INVALID_IDAU(Event.Severity.ERROR),
        INVALID_INTEGER_VALUE(Event.Severity.ERROR),
        UNSUPPORTED_STRING_TYPE(Event.Severity.ERROR),
        INVALID_STRONG_REFERENCE_TYPE(Event.Severity.ERROR),
        STRONG_REFERENCE_NOT_FOUND(Event.Severity.ERROR);

        public final Event.Severity severity;

        private EventCodes(Event.Severity severity) {
            this.severity = severity;
        }
    }

    public static class FragmentEvent
    extends BasicEvent {
        final String reason;
        final String where;

        public FragmentEvent(EventCodes kind, String reason) {
            this(kind, reason, null);
        }

        public FragmentEvent(EventCodes kind, String reason, String where) {
            super(kind.severity, kind, String.valueOf(reason) + (where != null ? " at " + where : ""));
            this.reason = reason;
            this.where = where;
        }

        public String getReason() {
            return this.reason;
        }

        public String getWhere() {
            return this.where;
        }
    }

    public static class RuleException
    extends Exception {
        public RuleException(Throwable t) {
            super(t);
        }

        public RuleException(String msg) {
            super(msg);
        }

        public RuleException(String msg, Throwable t) {
            super(msg, t);
        }
    }
}

