/*
 * Decompiled with CFR 0.152.
 */
package com.sandflow.smpte.register;

import com.sandflow.smpte.register.QualifiedSymbol;
import com.sandflow.smpte.register.catsup.ElementsRegisterModel;
import com.sandflow.smpte.register.exceptions.DuplicateEntryException;
import com.sandflow.smpte.util.UL;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;

@XmlTransient
public abstract class ElementsRegister {
    private final HashMap<QualifiedSymbol, Entry> entriesBySymbol = new HashMap();
    private final HashMap<UL, Entry> entriesByUL = new HashMap();

    protected ElementsRegister() {
    }

    public Entry getEntryByUL(UL ul) {
        return this.entriesByUL.get(ul);
    }

    public Entry getEntryBySymbol(QualifiedSymbol qs) {
        return this.entriesBySymbol.get(qs);
    }

    public abstract Collection<? extends Entry> getEntries();

    public void toXML(Writer writer) throws JAXBException, IOException {
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{this.getClass()});
        Marshaller m = ctx.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        m.marshal((Object)this, writer);
        writer.close();
    }

    public static ElementsRegister fromXML(Reader reader) throws JAXBException, IOException, DuplicateEntryException {
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{ElementsRegisterModel.class});
        Unmarshaller m = ctx.createUnmarshaller();
        ElementsRegister reg = (ElementsRegister)m.unmarshal(reader);
        for (Entry entry : reg.getEntries()) {
            QualifiedSymbol sym = new QualifiedSymbol(entry.getSymbol(), entry.getNamespaceName());
            if (reg.getEntryByUL(entry.getUL()) != null) {
                throw new DuplicateEntryException(String.format("UL = %s is already present (symbol = %s).", entry.getUL(), entry.getSymbol()));
            }
            if (reg.entriesBySymbol.get(sym) != null) {
                throw new DuplicateEntryException(String.format("Symbol = %s  is already present (UL = %s).", entry.getSymbol(), entry.getUL()));
            }
            reg.entriesByUL.put(entry.getUL(), entry);
            reg.entriesBySymbol.put(sym, entry);
        }
        return reg;
    }

    public static interface Entry {
        public String getApplications();

        public String getContextScope();

        public String getDefiningDocument();

        public String getDefinition();

        public Kind getKind();

        public String getName();

        public URI getNamespaceName();

        public String getNotes();

        public String getSymbol();

        public UL getTypeUL();

        public UL getUL();

        public String getUnitOfMeasure();

        public String getValueLength();

        public String getValueRange();

        public boolean isDeprecated();

        @XmlType(name="")
        public static enum Kind {
            NODE,
            LEAF;

        }
    }
}

