/*
 * Decompiled with CFR 0.152.
 */
package com.sandflow.smpte.mxf;

import com.sandflow.smpte.klv.KLVInputStream;
import com.sandflow.smpte.klv.exceptions.KLVException;
import com.sandflow.smpte.util.IDAU;
import com.sandflow.smpte.util.UMID;
import com.sandflow.smpte.util.UUID;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;

public class MXFInputStream
extends KLVInputStream {
    public MXFInputStream(InputStream is) {
        super(is);
    }

    public MXFInputStream(InputStream is, KLVInputStream.ByteOrder byteorder) {
        super(is, byteorder);
    }

    public UUID readUUID() throws IOException, EOFException {
        byte[] uuid = new byte[16];
        this.readFully(uuid);
        if (this.getByteOrder() == KLVInputStream.ByteOrder.LITTLE_ENDIAN) {
            MXFInputStream.uuidLEtoBE(uuid);
        }
        return new UUID(uuid);
    }

    public IDAU readIDAU() throws IOException, EOFException {
        byte[] idau = new byte[16];
        this.readFully(idau);
        if (this.getByteOrder() == KLVInputStream.ByteOrder.LITTLE_ENDIAN) {
            MXFInputStream.uuidLEtoBE(idau);
        }
        return new IDAU(idau);
    }

    public UMID readUMID() throws IOException, EOFException {
        byte[] umid = new byte[32];
        this.readFully(umid);
        return new UMID(umid);
    }

    public <T> Collection<T> readArray(Function<byte[], T> converter) throws KLVException, IOException {
        return this.readBatch(converter);
    }

    public <T> Collection<T> readBatch(Function<byte[], T> converter) throws KLVException, IOException {
        ArrayList<T> batch = new ArrayList<T>();
        long itemcount = this.readUnsignedInt();
        long itemlength = this.readUnsignedInt();
        if (itemlength > Integer.MAX_VALUE) {
            throw new KLVException(KLVException.MAX_LENGTH_EXCEEED);
        }
        int i = 0;
        while ((long)i < itemcount) {
            byte[] value = new byte[(int)itemlength];
            this.read(value);
            batch.add(converter.apply(value));
            ++i;
        }
        return batch;
    }
}

