/*
 * Decompiled with CFR 0.152.
 */
package com.sandflow.smpte.regxml.dict;

import com.sandflow.smpte.regxml.dict.DefinitionResolver;
import com.sandflow.smpte.regxml.dict.MetaDictionary;
import com.sandflow.smpte.regxml.dict.definitions.ClassDefinition;
import com.sandflow.smpte.regxml.dict.definitions.Definition;
import com.sandflow.smpte.regxml.dict.exceptions.IllegalDefinitionException;
import com.sandflow.smpte.regxml.dict.exceptions.IllegalDictionaryException;
import com.sandflow.smpte.util.AUID;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class MetaDictionaryCollection
implements DefinitionResolver {
    private final HashMap<URI, MetaDictionary> dicts = new HashMap();

    @Override
    public Definition getDefinition(AUID auid) {
        MetaDictionary md;
        Definition def = null;
        Iterator<MetaDictionary> iterator = this.dicts.values().iterator();
        while (iterator.hasNext() && (def = (md = iterator.next()).getDefinition(auid)) == null) {
        }
        return def;
    }

    public Definition getDefinition(URI namespace, String symbol) {
        Definition def = null;
        MetaDictionary md = this.dicts.get(namespace);
        if (md != null) {
            def = md.getDefinition(symbol);
        }
        return def;
    }

    public void addDictionary(MetaDictionary metadictionary) throws IllegalDictionaryException {
        MetaDictionary oldmd = this.dicts.get(metadictionary.getSchemeURI());
        if (oldmd != null) {
            throw new IllegalDictionaryException("Metadictionary already present in group.");
        }
        this.dicts.put(metadictionary.getSchemeURI(), metadictionary);
    }

    public void addDefinition(Definition def) throws IllegalDefinitionException {
        MetaDictionary md = this.dicts.get(def.getNamespace());
        if (md == null) {
            md = new MetaDictionary(def.getNamespace());
            this.dicts.put(md.getSchemeURI(), md);
        }
        md.add(def);
    }

    public Collection<MetaDictionary> getDictionaries() {
        return this.dicts.values();
    }

    @Override
    public Collection<AUID> getSubclassesOf(ClassDefinition parent) {
        ArrayList<AUID> subclasses = new ArrayList<AUID>();
        for (MetaDictionary md : this.dicts.values()) {
            Collection<AUID> defs = md.getSubclassesOf(parent);
            if (defs == null) continue;
            subclasses.addAll(defs);
        }
        return subclasses;
    }

    @Override
    public Collection<AUID> getMembersOf(ClassDefinition parent) {
        ArrayList<AUID> members = new ArrayList<AUID>();
        for (MetaDictionary md : this.dicts.values()) {
            Collection<AUID> defs = md.getMembersOf(parent);
            if (defs == null) continue;
            members.addAll(defs);
        }
        return members;
    }
}

