/*
 * Decompiled with CFR 0.152.
 */
package com.sandflow.smpte.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.regex.Pattern;

public class UUID {
    private byte[] value;
    private static final Pattern URN_PATTERN = Pattern.compile("urn:uuid:[a-fA-F0-9]{8}-(?:[a-fA-F0-9]{4}-){3}[a-fA-F0-9]{12}");
    static final char[] HEXMAP = "0123456789abcdef".toCharArray();
    static final char[] URNTEMPLATE = "urn:uuid:3e0993c0-66e0-11e4-9803-0800200c9a66".toCharArray();

    private UUID() {
    }

    public UUID(byte[] uuid) {
        this.value = Arrays.copyOf(uuid, 16);
    }

    public byte[] getValue() {
        return this.value;
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + Arrays.hashCode(this.value);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UUID other = (UUID)obj;
        return Arrays.equals(this.value, other.value);
    }

    public static UUID fromRandom() {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[16];
        random.nextBytes(bytes);
        bytes[6] = (byte)(bytes[6] & 0xF | 0x4F);
        bytes[8] = (byte)(bytes[8] & 0x3F | 0x7F);
        return new UUID(bytes);
    }

    public static UUID fromURIName(URI uri) {
        MessageDigest digest;
        UUID nsid = UUID.fromURN("urn:uuid:6ba7b811-9dad-11d1-80b4-00c04fd430c8");
        try {
            digest = MessageDigest.getInstance("SHA-1");
            digest.update(nsid.getValue());
            digest.update(uri.toString().getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
        byte[] result = digest.digest();
        result[6] = (byte)(result[6] & 0xF | 0x5F);
        result[8] = (byte)(result[8] & 0x3F | 0x7F);
        return new UUID(result);
    }

    public static UUID fromURN(String val) {
        byte[] uuid = new byte[16];
        if (URN_PATTERN.matcher(val).matches()) {
            int j;
            int inoff = 0;
            int outoff = 9;
            for (j = 0; j < 4; ++j) {
                uuid[inoff++] = (byte)Integer.parseInt(val.substring(outoff, outoff + 2), 16);
                outoff += 2;
            }
            for (int i = 0; i < 3; ++i) {
                ++outoff;
                for (int j2 = 0; j2 < 2; ++j2) {
                    uuid[inoff++] = (byte)Integer.parseInt(val.substring(outoff, outoff + 2), 16);
                    outoff += 2;
                }
            }
            ++outoff;
            for (j = 0; j < 6; ++j) {
                uuid[inoff++] = (byte)Integer.parseInt(val.substring(outoff, outoff + 2), 16);
                outoff += 2;
            }
            return new UUID(uuid);
        }
        return null;
    }

    public String toString() {
        int v;
        int j;
        char[] out = Arrays.copyOf(URNTEMPLATE, URNTEMPLATE.length);
        int inoff = 0;
        int outoff = 9;
        for (j = 0; j < 4; ++j) {
            v = this.value[inoff++] & 0xFF;
            out[outoff++] = HEXMAP[v >>> 4];
            out[outoff++] = HEXMAP[v & 0xF];
        }
        for (int i = 0; i < 3; ++i) {
            ++outoff;
            for (int j2 = 0; j2 < 2; ++j2) {
                int v2 = this.value[inoff++] & 0xFF;
                out[outoff++] = HEXMAP[v2 >>> 4];
                out[outoff++] = HEXMAP[v2 & 0xF];
            }
        }
        ++outoff;
        for (j = 0; j < 6; ++j) {
            v = this.value[inoff++] & 0xFF;
            out[outoff++] = HEXMAP[v >>> 4];
            out[outoff++] = HEXMAP[v & 0xF];
        }
        return new String(out);
    }
}

