/*
 * Decompiled with CFR 0.152.
 */
package com.sandflow.smpte.util;

import com.sandflow.smpte.util.UL;
import com.sandflow.smpte.util.UUID;
import java.util.Arrays;

public class AUID {
    private byte[] value;

    public static AUID fromURN(String urn) {
        if (urn == null) {
            return null;
        }
        if (urn.startsWith("urn:smpte:ul:")) {
            return new AUID(UL.fromURN(urn));
        }
        if (urn.startsWith("urn:uuid:")) {
            return new AUID(UUID.fromURN(urn));
        }
        return null;
    }

    private AUID() {
    }

    public AUID(byte[] auid) {
        this.value = Arrays.copyOf(auid, 16);
    }

    public AUID(UL ul) {
        this.value = ul.getValue();
    }

    public AUID(UUID uuid) {
        this.value = new byte[16];
        System.arraycopy(uuid.getValue(), 8, this.value, 0, 8);
        System.arraycopy(uuid.getValue(), 0, this.value, 8, 8);
    }

    public boolean equals(Object auid) {
        if (!(auid instanceof AUID)) {
            return false;
        }
        return Arrays.equals(((AUID)auid).value, this.value);
    }

    public boolean equals(UL ul) {
        return Arrays.equals(ul.getValue(), this.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    public String toString() {
        if (this.isUL()) {
            return this.asUL().toString();
        }
        return this.asUUID().toString();
    }

    public boolean isUL() {
        return (this.value[0] & 0x80) == 0;
    }

    public boolean isUUID() {
        return !this.isUL();
    }

    public UUID asUUID() {
        if (this.isUL()) {
            return null;
        }
        byte[] uuid = new byte[16];
        System.arraycopy(this.value, 8, uuid, 0, 8);
        System.arraycopy(this.value, 0, uuid, 8, 8);
        return new UUID(uuid);
    }

    public UL asUL() {
        return this.isUL() ? new UL(this.value) : null;
    }
}

