/*
 * Decompiled with CFR 0.152.
 */
package com.sandflow.smpte.klv;

import com.sandflow.smpte.klv.MemoryTriplet;
import com.sandflow.smpte.klv.Triplet;
import com.sandflow.smpte.klv.exceptions.KLVException;
import com.sandflow.smpte.util.AUID;
import com.sandflow.smpte.util.UL;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class KLVInputStream
extends InputStream
implements DataInput {
    private DataInputStream dis;
    private ByteOrder byteorder;

    public KLVInputStream(InputStream is) {
        this(is, ByteOrder.BIG_ENDIAN);
    }

    public KLVInputStream(InputStream is, ByteOrder byteorder) {
        if (is == null) {
            throw new NullPointerException();
        }
        this.dis = new DataInputStream(is);
        this.byteorder = byteorder;
    }

    public ByteOrder getByteOrder() {
        return this.byteorder;
    }

    public UL readUL() throws IOException, EOFException {
        byte[] ul = new byte[16];
        this.readFully(ul);
        return new UL(ul);
    }

    public AUID readAUID() throws IOException, EOFException {
        byte[] auid = new byte[16];
        if (this.read(auid) < auid.length) {
            throw new EOFException();
        }
        return new AUID(auid);
    }

    public long readBERLength() throws EOFException, IOException, KLVException {
        long val = 0L;
        int b = this.read();
        if (b <= 0) {
            throw new EOFException();
        }
        if ((b & 0x80) == 0) {
            return b;
        }
        int bersz = b & 0xF;
        if (bersz > 8) {
            throw new KLVException(KLVException.MAX_LENGTH_EXCEEED);
        }
        byte[] octets = new byte[bersz];
        if (this.read(octets) < bersz) {
            throw new EOFException();
        }
        for (int i = 0; i < bersz; ++i) {
            int tmp = octets[i] & 0xFF;
            if ((val = (val << 8) + (long)tmp) <= Integer.MAX_VALUE) continue;
            throw new KLVException(KLVException.MAX_LENGTH_EXCEEED);
        }
        return val;
    }

    public Triplet readTriplet() throws IOException, EOFException, KLVException {
        AUID auid = this.readAUID();
        long len = this.readBERLength();
        if (len > Integer.MAX_VALUE) {
            throw new KLVException(KLVException.MAX_LENGTH_EXCEEED);
        }
        byte[] value = new byte[(int)len];
        if (len != (long)this.read(value)) {
            throw new EOFException("EOF reached while reading Value.");
        }
        return new MemoryTriplet(auid, value);
    }

    @Override
    public final int read(byte[] bytes) throws IOException {
        return this.dis.read(bytes);
    }

    @Override
    public final int read(byte[] bytes, int i, int i1) throws IOException {
        return this.dis.read(bytes, i, i1);
    }

    @Override
    public final void readFully(byte[] bytes) throws IOException {
        this.dis.readFully(bytes);
    }

    @Override
    public final void readFully(byte[] bytes, int i, int i1) throws IOException {
        this.dis.readFully(bytes, i, i1);
    }

    @Override
    public final int skipBytes(int i) throws IOException {
        return this.dis.skipBytes(i);
    }

    @Override
    public final boolean readBoolean() throws IOException {
        return this.dis.readBoolean();
    }

    @Override
    public final byte readByte() throws IOException {
        return this.dis.readByte();
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        return this.dis.readUnsignedByte();
    }

    @Override
    public final short readShort() throws IOException {
        if (this.byteorder == ByteOrder.BIG_ENDIAN) {
            return this.dis.readShort();
        }
        int lo = this.readUnsignedByte();
        int hi = this.readUnsignedByte();
        return (short)(lo + (hi << 8));
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        if (this.byteorder == ByteOrder.BIG_ENDIAN) {
            return this.dis.readUnsignedShort();
        }
        int lo = this.readUnsignedByte();
        int hi = this.readUnsignedByte();
        return lo + hi << 8;
    }

    @Override
    public final char readChar() throws IOException {
        return this.dis.readChar();
    }

    @Override
    public final int readInt() throws IOException {
        if (this.byteorder == ByteOrder.BIG_ENDIAN) {
            return this.dis.readInt();
        }
        int b0 = this.readUnsignedByte();
        int b1 = this.readUnsignedByte();
        int b2 = this.readUnsignedByte();
        int b3 = this.readUnsignedByte();
        return b0 + (b1 << 8) + (b2 << 16) + (b3 << 24);
    }

    public long readUnsignedInt() throws IOException, EOFException {
        if (this.byteorder == ByteOrder.BIG_ENDIAN) {
            return (long)this.dis.readInt() & 0xFFFFL;
        }
        int b0 = this.readUnsignedByte();
        int b1 = this.readUnsignedByte();
        int b2 = this.readUnsignedByte();
        int b3 = this.readUnsignedByte();
        return (long)b0 + (long)(b1 << 8) + (long)(b2 << 16) + (long)(b3 << 24) & 0xFFFFL;
    }

    @Override
    public final long readLong() throws IOException {
        if (this.byteorder == ByteOrder.BIG_ENDIAN) {
            return this.dis.readLong();
        }
        int b0 = this.readUnsignedByte();
        int b1 = this.readUnsignedByte();
        int b2 = this.readUnsignedByte();
        int b3 = this.readUnsignedByte();
        int b4 = this.readUnsignedByte();
        int b5 = this.readUnsignedByte();
        int b6 = this.readUnsignedByte();
        int b7 = this.readUnsignedByte();
        return b0 + (b1 << 8) + (b2 << 16) + (b3 << 24) + (b4 << 32) + (b5 << 40) + (b6 << 48) + (b7 << 56);
    }

    @Override
    public final float readFloat() throws IOException {
        return this.dis.readFloat();
    }

    @Override
    public final double readDouble() throws IOException {
        return this.dis.readDouble();
    }

    @Override
    public final String readLine() throws IOException {
        return this.dis.readLine();
    }

    @Override
    public final String readUTF() throws IOException {
        return this.dis.readUTF();
    }

    public static final String readUTF(DataInput di) throws IOException {
        return DataInputStream.readUTF(di);
    }

    @Override
    public int read() throws IOException {
        return this.dis.read();
    }

    @Override
    public long skip(long l) throws IOException {
        return this.dis.skip(l);
    }

    @Override
    public int available() throws IOException {
        return this.dis.available();
    }

    @Override
    public void close() throws IOException {
        this.dis.close();
    }

    @Override
    public synchronized void mark(int i) {
        this.dis.mark(i);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.dis.reset();
    }

    @Override
    public boolean markSupported() {
        return this.dis.markSupported();
    }

    protected static final void swap(byte[] array, int i, int j) {
        byte tmp = array[i];
        array[i] = array[j];
        array[j] = tmp;
    }

    protected static final void uuidLEtoBE(byte[] uuid) {
        KLVInputStream.swap(uuid, 0, 3);
        KLVInputStream.swap(uuid, 1, 2);
        KLVInputStream.swap(uuid, 4, 5);
        KLVInputStream.swap(uuid, 6, 7);
    }

    public static enum ByteOrder {
        LITTLE_ENDIAN,
        BIG_ENDIAN;

    }
}

