/*
 * Decompiled with CFR 0.152.
 */
package com.sandflow.smpte.tools;

import com.sandflow.smpte.klv.exceptions.KLVException;
import com.sandflow.smpte.regxml.FragmentBuilder;
import com.sandflow.smpte.regxml.MXFFragmentBuilder;
import com.sandflow.smpte.regxml.dict.MetaDictionary;
import com.sandflow.smpte.regxml.dict.MetaDictionaryCollection;
import com.sandflow.smpte.regxml.dict.exceptions.IllegalDefinitionException;
import com.sandflow.smpte.regxml.dict.exceptions.IllegalDictionaryException;
import com.sandflow.smpte.tools.BuildVersionSingleton;
import com.sandflow.smpte.util.UL;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Date;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public class RegXMLDump {
    private static final Logger LOG = Logger.getLogger(RegXMLDump.class.getName());
    private static final UL ESSENCE_DESCRIPTOR_KEY = new UL(new byte[]{6, 14, 43, 52, 2, 1, 1, 1, 13, 1, 1, 1, 1, 1, 36, 0});
    private static final UL PREFACE_KEY = UL.fromURN("urn:smpte:ul:060e2b34.027f0101.0d010101.01012f00");
    private static final String USAGE = "Dump header metadata of an MXF file as a RegXML structure.\n  Usage:\n     RegXMLDump ( -all | -ed ) -d regxmldictionary1 regxmldictionary2 regxmldictionary3 ... -i mxffile\n     RegXMLDump -?\n  Where:\n     -all: dumps all header metadata\n     -ed: dumps only the first essence descriptor found\n";

    public static void main(String[] args) throws IOException, EOFException, KLVException, ParserConfigurationException, JAXBException, FragmentBuilder.RuleException, TransformerException, IllegalDefinitionException, IllegalDictionaryException {
        if (args.length < 5 || "-?".equals(args[0]) || !"-d".equals(args[1]) || !"-i".equals(args[args.length - 2])) {
            System.out.println(USAGE);
            return;
        }
        MetaDictionaryCollection mds = new MetaDictionaryCollection();
        for (int i = 2; i < args.length - 2; ++i) {
            FileReader fr = new FileReader(args[i]);
            mds.addDictionary(MetaDictionary.fromXML(fr));
        }
        FileInputStream f = new FileInputStream(args[args.length - 1]);
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        doc.setXmlStandalone(true);
        Date now = new Date();
        doc.appendChild(doc.createComment("Created: " + now.toString()));
        doc.appendChild(doc.createComment("From: " + args[args.length - 1]));
        doc.appendChild(doc.createComment("By: regxmllib build " + BuildVersionSingleton.getBuildVersion()));
        doc.appendChild(doc.createComment("See: https://github.com/sandflow/regxmllib"));
        try {
            UL root = "-ed".equals(args[0]) ? ESSENCE_DESCRIPTOR_KEY : PREFACE_KEY;
            DocumentFragment df = MXFFragmentBuilder.fromInputStream(f, mds, root, doc);
            doc.appendChild(df);
        }
        catch (KLVException | FragmentBuilder.RuleException | MXFFragmentBuilder.MXFException | ParserConfigurationException e) {
            LOG.severe(e.getMessage());
        }
        Transformer tr = TransformerFactory.newInstance().newTransformer();
        tr.setOutputProperty("indent", "yes");
        tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        tr.transform(new DOMSource(doc), new StreamResult(System.out));
    }
}

