/*
 * Decompiled with CFR 0.152.
 */
package com.sandflow.smpte.regxml.dict.importers;

import com.sandflow.smpte.register.ElementEntry;
import com.sandflow.smpte.register.ElementsRegister;
import com.sandflow.smpte.register.GroupEntry;
import com.sandflow.smpte.register.GroupsRegister;
import com.sandflow.smpte.register.TypeEntry;
import com.sandflow.smpte.register.TypesRegister;
import com.sandflow.smpte.regxml.dict.MetaDictionaryCollection;
import com.sandflow.smpte.regxml.dict.definitions.CharacterTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.ClassDefinition;
import com.sandflow.smpte.regxml.dict.definitions.Definition;
import com.sandflow.smpte.regxml.dict.definitions.EnumerationTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.ExtendibleEnumerationTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.FixedArrayTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.FloatTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.IndirectTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.IntegerTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.LensSerialFloatTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.OpaqueTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.PropertyAliasDefinition;
import com.sandflow.smpte.regxml.dict.definitions.PropertyDefinition;
import com.sandflow.smpte.regxml.dict.definitions.RecordTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.RenameTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.SetTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.StreamTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.StringTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.StrongReferenceTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.VariableArrayTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.WeakReferenceTypeDefinition;
import com.sandflow.smpte.regxml.dict.exceptions.DuplicateSymbolException;
import com.sandflow.smpte.util.AUID;
import com.sandflow.smpte.util.UL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Logger;

public class RegisterImporter {
    private static final Logger LOGGER = Logger.getLogger(RegisterImporter.class.getName());

    public static MetaDictionaryCollection fromRegister(TypesRegister tr, GroupsRegister gr, ElementsRegister er) throws Exception {
        ArrayList<Definition> defs = new ArrayList<Definition>();
        HashSet<AUID> defIDs = new HashSet<AUID>();
        for (GroupEntry group : gr.getEntries()) {
            if (group.getKind().equals((Object)GroupEntry.Kind.NODE) || group.getUL().isClass14() || group.getUL().isClass15() || !group.getKlvSyntax().contains((byte)83)) continue;
            ClassDefinition cdef = new ClassDefinition();
            if (group.isConcrete() != null) {
                cdef.setConcrete(group.isConcrete());
            } else {
                cdef.setConcrete(true);
            }
            cdef.setDescription(group.getDefinition());
            cdef.setName(group.getName());
            cdef.setSymbol(group.getSymbol());
            cdef.setNamespace(group.getNamespaceName());
            if (group.getParent() != null) {
                cdef.setParentClass(new AUID(group.getParent()));
            }
            cdef.setIdentification(new AUID(group.getUL()));
            for (GroupEntry.Record child : group.getContents()) {
                AUID id = new AUID(child.getItem());
                PropertyDefinition pdef = null;
                if (defIDs.contains(id)) {
                    PropertyAliasDefinition padef = new PropertyAliasDefinition();
                    padef.setOriginalProperty(id);
                    pdef = padef;
                } else {
                    pdef = new PropertyDefinition();
                }
                pdef.setIdentification(id);
                pdef.setOptional(child.getOptional());
                if (child.getUniqueID() != null) {
                    pdef.setUniqueIdentifier(child.getUniqueID());
                }
                pdef.setLocalIdentification((int)(child.getLocalTag() == null ? 0L : child.getLocalTag()));
                ElementEntry element = er.getEntryByUL(child.getItem());
                if (element == null) {
                    LOGGER.warning(String.format("Undefined Element %s for Group %s", child.getItem(), group.getUL()));
                    continue;
                }
                pdef.setDescription(element.getDefinition());
                pdef.setName(element.getName());
                pdef.setSymbol(element.getSymbol());
                if (element.getTypeUL() == null) {
                    LOGGER.warning(String.format("Missing Type UL at Element %s for Group %s", child.getItem(), group.getUL()));
                    continue;
                }
                pdef.setType(new AUID(element.getTypeUL()));
                pdef.setMemberOf(cdef.getIdentification());
                pdef.setNamespace(element.getNamespaceName());
                defs.add(pdef);
                defIDs.add(pdef.getIdentification());
            }
            defs.add(cdef);
            defIDs.add(cdef.getIdentification());
        }
        for (TypeEntry type : tr.getEntries()) {
            Definition tdef;
            block61: {
                block63: {
                    block62: {
                        block60: {
                            if (!type.getKind().equals((Object)TypeEntry.Kind.LEAF)) continue;
                            tdef = null;
                            if (!"Rename".equals(type.getTypeKind())) break block60;
                            tdef = new RenameTypeDefinition();
                            ((RenameTypeDefinition)tdef).setRenamedType(new AUID(type.getBaseType()));
                            break block61;
                        }
                        if (!"Integer".equals(type.getTypeKind())) break block62;
                        tdef = new IntegerTypeDefinition();
                        ((IntegerTypeDefinition)tdef).setSigned(type.getTypeQualifiers().contains((Object)TypeEntry.TypeQualifiers.isSigned));
                        switch (type.getTypeSize().intValue()) {
                            case 1: {
                                ((IntegerTypeDefinition)tdef).setSize(IntegerTypeDefinition.Size.ONE);
                                break block61;
                            }
                            case 2: {
                                ((IntegerTypeDefinition)tdef).setSize(IntegerTypeDefinition.Size.TWO);
                                break block61;
                            }
                            case 4: {
                                ((IntegerTypeDefinition)tdef).setSize(IntegerTypeDefinition.Size.FOUR);
                                break block61;
                            }
                            case 8: {
                                ((IntegerTypeDefinition)tdef).setSize(IntegerTypeDefinition.Size.EIGHT);
                                break block61;
                            }
                            default: {
                                throw new Exception("Illegal Type Size.");
                            }
                        }
                    }
                    if (!"Float".equals(type.getTypeKind())) break block63;
                    tdef = new FloatTypeDefinition();
                    switch (type.getTypeSize().intValue()) {
                        case 2: {
                            ((FloatTypeDefinition)tdef).setSize(FloatTypeDefinition.Size.HALF);
                            break block61;
                        }
                        case 4: {
                            ((FloatTypeDefinition)tdef).setSize(FloatTypeDefinition.Size.SINGLE);
                            break block61;
                        }
                        case 8: {
                            ((FloatTypeDefinition)tdef).setSize(FloatTypeDefinition.Size.DOUBLE);
                            break block61;
                        }
                        default: {
                            throw new Exception("Illegal Type Size.");
                        }
                    }
                }
                if ("LensSerialFloat".equals(type.getTypeKind())) {
                    tdef = new LensSerialFloatTypeDefinition();
                } else if ("Record".equals(type.getTypeKind())) {
                    tdef = new RecordTypeDefinition();
                    for (TypeEntry.Facet tchild : type.getFacets()) {
                        RecordTypeDefinition.Member m = new RecordTypeDefinition.Member();
                        m.setName(tchild.getSymbol());
                        m.setType(new AUID(tchild.getType()));
                        ((RecordTypeDefinition)tdef).addMember(m);
                    }
                } else if ("FixedArray".equals(type.getTypeKind())) {
                    tdef = new FixedArrayTypeDefinition();
                    ((FixedArrayTypeDefinition)tdef).setElementType(new AUID(type.getBaseType()));
                    ((FixedArrayTypeDefinition)tdef).setElementCount(type.getTypeSize().intValue());
                } else if ("VariableArray".equals(type.getTypeKind())) {
                    tdef = new VariableArrayTypeDefinition();
                    ((VariableArrayTypeDefinition)tdef).setElementType(new AUID(type.getBaseType()));
                } else if ("Set".equals(type.getTypeKind())) {
                    tdef = new SetTypeDefinition();
                    ((SetTypeDefinition)tdef).setElementType(new AUID(type.getBaseType()));
                } else if ("Indirect".equals(type.getTypeKind())) {
                    tdef = new IndirectTypeDefinition();
                } else if ("Opaque".equals(type.getTypeKind())) {
                    tdef = new OpaqueTypeDefinition();
                } else if ("Stream".equals(type.getTypeKind())) {
                    tdef = new StreamTypeDefinition();
                } else if ("WeakReference".equals(type.getTypeKind())) {
                    tdef = new WeakReferenceTypeDefinition();
                    if (type.getBaseType() == null) {
                        throw new Exception(String.format("Missing base type for Type %s", type.getUL()));
                    }
                    ((WeakReferenceTypeDefinition)tdef).setReferencedType(new AUID(type.getBaseType()));
                    for (TypeEntry.Facet f : type.getFacets()) {
                        UL ul = null;
                        if (f.getValue() != null) {
                            ul = UL.fromURN(f.getValue());
                        }
                        if (ul == null) {
                            LOGGER.warning(String.format("Missing Target Set UL at Type %s", type.getUL().toString()));
                            continue;
                        }
                        if (((WeakReferenceTypeDefinition)tdef).getTargetSet().add(new AUID(ul))) continue;
                        LOGGER.warning(String.format("Duplicate Target Set UL at Type %s", type.getUL().toString()));
                    }
                } else if ("StrongReference".equals(type.getTypeKind())) {
                    tdef = new StrongReferenceTypeDefinition();
                    ((StrongReferenceTypeDefinition)tdef).setReferenceType(new AUID(type.getBaseType()));
                } else if ("Enumeration".equals(type.getTypeKind())) {
                    if (type.getBaseType().equals(UL.fromURN("urn:smpte:ul:060E2B34.01040101.01030100.00000000"))) {
                        ArrayList<ExtendibleEnumerationTypeDefinition.Element> ecelems = new ArrayList<ExtendibleEnumerationTypeDefinition.Element>();
                        tdef = new ExtendibleEnumerationTypeDefinition(ecelems);
                    } else {
                        ArrayList<EnumerationTypeDefinition.Element> celems = new ArrayList<EnumerationTypeDefinition.Element>();
                        for (TypeEntry.Facet f : type.getFacets()) {
                            EnumerationTypeDefinition.Element m = new EnumerationTypeDefinition.Element();
                            m.setName(f.getSymbol());
                            m.setValue(Integer.decode(f.getValue()));
                            celems.add(m);
                        }
                        tdef = new EnumerationTypeDefinition(celems);
                        ((EnumerationTypeDefinition)tdef).setElementType(new AUID(type.getBaseType()));
                    }
                } else if ("Character".equals(type.getTypeKind())) {
                    tdef = new CharacterTypeDefinition();
                } else if ("String".equals(type.getTypeKind())) {
                    tdef = new StringTypeDefinition();
                    ((StringTypeDefinition)tdef).setElementType(new AUID(type.getBaseType()));
                } else {
                    LOGGER.warning(String.format("Unknown type kind of %s for Type UL %s.", type.getTypeKind(), type.getUL().toString()));
                    continue;
                }
            }
            if (tdef != null) {
                tdef.setIdentification(new AUID(type.getUL()));
                tdef.setSymbol(type.getSymbol());
                tdef.setName(type.getName());
                tdef.setDescription(type.getDefinition());
                tdef.setNamespace(type.getNamespaceName());
                defs.add(tdef);
                defIDs.add(tdef.getIdentification());
                continue;
            }
            LOGGER.warning(String.format("Byte Type UL %s.", type.getUL().toString()));
        }
        MetaDictionaryCollection mds = new MetaDictionaryCollection();
        long index = 0L;
        for (Definition def : defs) {
            try {
                mds.addDefinition(def);
            }
            catch (DuplicateSymbolException dse) {
                String newsym = "dup" + def.getSymbol() + index++;
                LOGGER.warning(String.format("Duplicate symbol %s (%s) renamed %s", def.getSymbol(), def.getNamespace().toASCIIString(), newsym));
                def.setSymbol(newsym);
                mds.addDefinition(def);
            }
        }
        return mds;
    }
}

