/*
 * Decompiled with CFR 0.152.
 */
package com.sandflow.smpte.register;

import com.sandflow.smpte.register.LabelEntry;
import com.sandflow.smpte.register.QualifiedSymbol;
import com.sandflow.smpte.register.exceptions.DuplicateEntryException;
import com.sandflow.smpte.util.UL;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="LabelsRegister", namespace="http://www.smpte-ra.org/schemas/400/2012")
@XmlType(name="")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlSeeAlso(value={LabelEntry.class})
public class LabelsRegister {
    public static final String XML_NAMESPACE = "http://www.smpte-ra.org/schemas/400/2012";
    private final HashMap<QualifiedSymbol, LabelEntry> entriesBySymbol = new HashMap();
    private final HashMap<UL, LabelEntry> entriesByUL = new HashMap();
    @XmlElement(name="Entry", namespace="http://www.smpte-ra.org/schemas/400/2012")
    @XmlElementWrapper(name="Entries", namespace="http://www.smpte-ra.org/schemas/400/2012")
    private final ArrayList<LabelEntry> entries = new ArrayList();

    public LabelEntry getEntryByUL(UL ul) {
        return this.entriesByUL.get(ul);
    }

    public void addEntry(LabelEntry entry) throws DuplicateEntryException {
        QualifiedSymbol sym = new QualifiedSymbol(entry.getSymbol(), entry.getNamespaceName());
        if (this.entriesByUL.containsKey(entry.getUL())) {
            throw new DuplicateEntryException(String.format("UL = %s is already present (symbol = %s).", entry.getUL(), entry.getSymbol()));
        }
        if (this.entriesBySymbol.containsKey(sym)) {
            throw new DuplicateEntryException(String.format("Symbol = %s  is already present (UL = %s).", entry.getSymbol(), entry.getUL()));
        }
        this.entries.add(entry);
        this.entriesByUL.put(entry.getUL(), entry);
        this.entriesBySymbol.put(sym, entry);
    }

    public Collection<LabelEntry> getEntries() {
        return this.entries;
    }

    public void toXML(Writer writer) throws JAXBException, IOException {
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{LabelsRegister.class});
        Marshaller m = ctx.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        m.marshal((Object)this, writer);
        writer.close();
    }

    public static LabelsRegister fromXML(Reader reader) throws JAXBException, IOException {
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{LabelsRegister.class});
        Unmarshaller m = ctx.createUnmarshaller();
        LabelsRegister reg = (LabelsRegister)m.unmarshal(reader);
        for (LabelEntry te : reg.entries) {
            QualifiedSymbol sym = new QualifiedSymbol(te.getSymbol(), te.getNamespaceName());
            reg.entriesByUL.put(te.getUL(), te);
            reg.entriesBySymbol.put(sym, te);
        }
        return reg;
    }
}

