/*
 * Decompiled with CFR 0.152.
 */
package com.sandflow.smpte.register;

import com.sandflow.smpte.register.GroupEntry;
import com.sandflow.smpte.register.QualifiedSymbol;
import com.sandflow.smpte.register.exceptions.DuplicateEntryException;
import com.sandflow.smpte.util.UL;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="GroupsRegister", namespace="http://www.smpte-ra.org/schemas/395/2014")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="")
@XmlSeeAlso(value={GroupEntry.class})
public class GroupsRegister {
    public static final String XML_NAMESPACE = "http://www.smpte-ra.org/schemas/395/2014";
    private final HashMap<QualifiedSymbol, GroupEntry> entriesBySymbol = new HashMap();
    private final HashMap<UL, GroupEntry> entriesByUL = new HashMap();
    @XmlElement(name="Entry", namespace="http://www.smpte-ra.org/schemas/395/2014")
    @XmlElementWrapper(name="Entries", namespace="http://www.smpte-ra.org/schemas/395/2014")
    private final ArrayList<GroupEntry> entries = new ArrayList();

    public GroupEntry getEntryByUL(UL ul) {
        return this.entriesByUL.get(ul);
    }

    public void addEntry(GroupEntry entry) throws DuplicateEntryException {
        QualifiedSymbol sym = new QualifiedSymbol(entry.getSymbol(), entry.getNamespaceName());
        if (this.entriesByUL.containsKey(entry.getUL())) {
            throw new DuplicateEntryException(String.format("UL = %s is already present (symbol = %s).", entry.getUL(), entry.getSymbol()));
        }
        if (this.entriesBySymbol.containsKey(sym)) {
            throw new DuplicateEntryException(String.format("Symbol = %s  is already present (UL = %s).", entry.getSymbol(), entry.getUL()));
        }
        this.entries.add(entry);
        this.entriesByUL.put(entry.getUL(), entry);
        this.entriesBySymbol.put(sym, entry);
    }

    public Collection<GroupEntry> getEntries() {
        return this.entries;
    }

    public void toXML(Writer writer) throws JAXBException, IOException {
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{GroupsRegister.class});
        Marshaller m = ctx.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        m.marshal((Object)this, writer);
        writer.close();
    }

    public static GroupsRegister fromXML(Reader reader) throws JAXBException, IOException {
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{GroupsRegister.class});
        Unmarshaller m = ctx.createUnmarshaller();
        GroupsRegister reg = (GroupsRegister)m.unmarshal(reader);
        for (GroupEntry te : reg.entries) {
            QualifiedSymbol sym = new QualifiedSymbol(te.getSymbol(), te.getNamespaceName());
            reg.entriesByUL.put(te.getUL(), te);
            reg.entriesBySymbol.put(sym, te);
        }
        return reg;
    }
}

