/*
 * Decompiled with CFR 0.152.
 */
package com.sandflow.smpte.klv;

import com.sandflow.smpte.klv.Group;
import com.sandflow.smpte.klv.KLVInputStream;
import com.sandflow.smpte.klv.LocalTagRegister;
import com.sandflow.smpte.klv.MemoryTriplet;
import com.sandflow.smpte.klv.Triplet;
import com.sandflow.smpte.klv.exceptions.KLVException;
import com.sandflow.smpte.klv.exceptions.TripletLengthException;
import com.sandflow.smpte.util.CountingInputStream;
import com.sandflow.smpte.util.UL;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class LocalSet
implements Group {
    private final ArrayList<Triplet> items = new ArrayList();
    private final UL key;

    public static LocalSet fromTriplet(Triplet localset, LocalTagRegister reg) throws KLVException {
        try {
            if (!localset.getKey().isLocalSet()) {
                return null;
            }
            CountingInputStream cis = new CountingInputStream(localset.getValueAsStream());
            KLVInputStream kis = new KLVInputStream(cis);
            LocalSet set = new LocalSet(localset.getKey());
            while (cis.getCount() < localset.getLength()) {
                long localtag = 0L;
                switch (localset.getKey().getRegistryDesignator() >> 3 & 3) {
                    case 0: {
                        localtag = kis.readUnsignedByte();
                        break;
                    }
                    case 1: {
                        localtag = kis.readBERLength();
                        break;
                    }
                    case 2: {
                        localtag = kis.readUnsignedShort();
                        break;
                    }
                    case 3: {
                        localtag = kis.readUnsignedInt();
                    }
                }
                long locallen = 0L;
                switch (localset.getKey().getRegistryDesignator() >> 5 & 3) {
                    case 0: {
                        locallen = kis.readBERLength();
                        break;
                    }
                    case 1: {
                        locallen = kis.readUnsignedByte();
                        break;
                    }
                    case 2: {
                        locallen = kis.readUnsignedShort();
                        break;
                    }
                    case 3: {
                        locallen = kis.readUnsignedInt();
                    }
                }
                if (locallen > Integer.MAX_VALUE) {
                    throw new TripletLengthException();
                }
                byte[] localval = new byte[(int)locallen];
                kis.readFully(localval);
                if (reg.get(localtag) == null) {
                    throw new KLVException("Local tag not found: " + localtag + " in Local Set " + localset.getKey());
                }
                set.addItem(new MemoryTriplet(reg.get(localtag), localval));
            }
            return set;
        }
        catch (IOException e) {
            throw new KLVException("Error parsing Local Set: " + localset.getKey(), e);
        }
    }

    private LocalSet(UL key) {
        this.key = key;
    }

    @Override
    public UL getKey() {
        return this.key;
    }

    @Override
    public Collection<Triplet> getItems() {
        return this.items;
    }

    private void addItem(Triplet triplet) {
        this.items.add(triplet);
    }
}

