/*
 * Decompiled with CFR 0.152.
 */
package com.sanctionco.thunder.models;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.sanctionco.thunder.models.Email;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;

public class User {
    private final Email email;
    private final String password;
    @JsonPropertyOrder(alphabetic=true)
    private final Map<String, Object> properties;

    @JsonCreator
    public User(@JsonProperty(value="email") Email email, @JsonProperty(value="password") String password, @JsonProperty(value="properties") Map<String, Object> properties) {
        this.email = email;
        this.password = password;
        this.properties = Optional.ofNullable(properties).orElse(new HashMap());
    }

    public Email getEmail() {
        return this.email;
    }

    public String getPassword() {
        return this.password;
    }

    @JsonAnyGetter
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @JsonAnySetter
    void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public User withTime(long creationTime, long lastUpdateTime) {
        User copy = new User(this.email, this.password, new HashMap<String, Object>(this.properties));
        copy.setProperty("creationTime", creationTime);
        copy.setProperty("lastUpdateTime", lastUpdateTime);
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        Object object = obj;
        if (!(object instanceof User)) {
            return false;
        }
        User other = (User)object;
        return Objects.equals(this.email, other.email) && Objects.equals(this.password, other.password) && Objects.equals(this.properties, other.properties);
    }

    public int hashCode() {
        return Objects.hash(this.email, this.password, this.properties);
    }

    public String toString() {
        return new StringJoiner(", ", "User [", "]").add(String.format("email=%s", this.email)).add(String.format("password=%s", this.password)).add(String.format("properties=%s", this.properties)).toString();
    }
}

