/*
 * Decompiled with CFR 0.152.
 */
package com.samsandberg.stravaauthenticator;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.Toast;
import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.extensions.android.http.AndroidHttp;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson.JacksonFactory;
import com.samsandberg.stravaauthenticator.R;
import com.wuman.android.auth.AuthorizationFlow;
import com.wuman.android.auth.AuthorizationUIController;
import com.wuman.android.auth.DialogFragmentController;
import com.wuman.android.auth.OAuthManager;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Logger;

public class StravaAuthenticateActivity
extends FragmentActivity {
    private static final Logger LOGGER = Logger.getLogger("StravaAuthenticator");
    public static final JsonFactory JSON_FACTORY = new JacksonFactory();
    public static final HttpTransport HTTP_TRANSPORT = AndroidHttp.newCompatibleTransport();

    protected String getStravaClientId() {
        return null;
    }

    protected String getStravaClientSecret() {
        return null;
    }

    protected Collection<String> getStravaScopes() {
        return Arrays.asList("public");
    }

    protected boolean getStravaUseCache() {
        return true;
    }

    protected boolean getStravaCheckToken() {
        return true;
    }

    protected Intent getStravaActivityIntent() {
        return null;
    }

    protected boolean getStravaFinishOnComplete() {
        return true;
    }

    protected void onCreate(Bundle savedInstanceState) {
        this.requestWindowFeature(5);
        super.onCreate(savedInstanceState);
        FragmentManager fm = this.getSupportFragmentManager();
        if (fm.findFragmentById(0x1020002) == null) {
            OAuthFragment fragment = new OAuthFragment();
            fm.beginTransaction().add(0x1020002, (Fragment)fragment).commit();
        }
        this.handleCachedToken();
    }

    public static String getStravaAccessToken(Context context) {
        SharedPreferences preferences = context.getSharedPreferences("strava_authenticator", 0);
        return preferences.getString("strava_authenticator_access_token", null);
    }

    protected boolean handleCachedToken() {
        if (!this.getStravaUseCache()) {
            return false;
        }
        String token = StravaAuthenticateActivity.getStravaAccessToken((Context)this);
        if (token == null) {
            return false;
        }
        this.startMainActivity(token);
        return true;
    }

    protected void setStravaAccessToken(String token) {
        SharedPreferences preferences = this.getSharedPreferences("strava_authenticator", 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString("strava_authenticator_access_token", token);
        editor.commit();
    }

    protected void startMainActivity(String token) {
        Intent intent = this.getStravaActivityIntent();
        if (intent == null) {
            Toast.makeText((Context)this, (CharSequence)"getStravaActivityIntent() returned null! TODO: Something!", (int)0).show();
            return;
        }
        this.startActivity(intent);
        if (this.getStravaFinishOnComplete()) {
            this.finish();
        }
    }

    public static class OAuthFragment
    extends Fragment {
        private OAuthManager oauth;
        private Button button;

        public void onCreate(Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
        }

        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            return inflater.inflate(R.layout.activity_auth, container, false);
        }

        public void onViewCreated(View view, Bundle savedInstanceState) {
            this.button = (Button)view.findViewById(16908313);
            this.button.setText(R.string.button_login);
            this.button.setTag((Object)R.string.button_login);
            this.button.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    StravaAuthenticateActivity activity = (StravaAuthenticateActivity)OAuthFragment.this.getActivity();
                    new AuthTask(activity.getStravaCheckToken()).execute(new Void[0]);
                }
            });
        }

        public void onActivityCreated(Bundle savedInstanceState) {
            super.onActivityCreated(savedInstanceState);
            this.setupOauth();
        }

        private void setupOauth() {
            boolean fullScreen = true;
            StravaAuthenticateActivity activity = (StravaAuthenticateActivity)this.getActivity();
            String clientId = activity.getStravaClientId();
            if (clientId == null) {
                Toast.makeText((Context)activity, (CharSequence)"clientId is null! TODO: Something!", (int)0).show();
                return;
            }
            String clientSecret = activity.getStravaClientSecret();
            if (clientSecret == null) {
                Toast.makeText((Context)activity, (CharSequence)"clientSecret is null! TODO: Something!", (int)0).show();
                return;
            }
            AuthorizationFlow flow = new AuthorizationFlow.Builder(BearerToken.queryParameterAccessMethod(), HTTP_TRANSPORT, JSON_FACTORY, new GenericUrl("https://www.strava.com/oauth/token"), (HttpExecuteInterceptor)new ClientParametersAuthentication(clientId, clientSecret), clientId, "https://www.strava.com/oauth/authorize").setScopes(activity.getStravaScopes()).setRequestInitializer(new HttpRequestInitializer(){

                public void initialize(HttpRequest request) throws IOException {
                }
            }).build();
            DialogFragmentController controller = new DialogFragmentController(this.getFragmentManager(), fullScreen){

                public String getRedirectUri() throws IOException {
                    return "http://localhost/Callback";
                }

                public boolean isJavascriptEnabledForWebView() {
                    return true;
                }

                public boolean disableWebViewCache() {
                    return false;
                }

                public boolean removePreviousCookie() {
                    return false;
                }
            };
            this.oauth = new OAuthManager(flow, (AuthorizationUIController)controller);
        }

        private class AuthTask
        extends AsyncTask<Void, Void, AuthResult> {
            private boolean stravaCheckToken;

            public AuthTask(boolean stravaCheckToken) {
                this.stravaCheckToken = stravaCheckToken;
            }

            protected void onPreExecute() {
                OAuthFragment.this.getActivity().setProgressBarIndeterminateVisibility(true);
                OAuthFragment.this.button.setEnabled(false);
            }

            protected boolean checkToken(String token) {
                return true;
            }

            protected AuthResult doInBackground(Void ... params) {
                Credential credential;
                try {
                    credential = (Credential)OAuthFragment.this.oauth.authorizeExplicitly("token_strava", null, null).getResult();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    LOGGER.severe("Auth failed!");
                    return new AuthResult("Auth failed! TODO: Something! " + e.getMessage());
                }
                String token = credential.getAccessToken();
                LOGGER.info("token: " + token);
                if (TextUtils.isEmpty((CharSequence)token)) {
                    return new AuthResult("Auth failed, token is empty! TODO: Something!");
                }
                if (this.stravaCheckToken && !this.checkToken(token)) {
                    return new AuthResult("Token check failed! TODO: Something!");
                }
                return new AuthResult(credential);
            }

            protected void onPostExecute(AuthResult result) {
                OAuthFragment.this.getActivity().setProgressBarIndeterminateVisibility(false);
                OAuthFragment.this.button.setEnabled(true);
                StravaAuthenticateActivity activity = (StravaAuthenticateActivity)OAuthFragment.this.getActivity();
                if (result.success) {
                    String token = result.credential.getAccessToken();
                    activity.setStravaAccessToken(token);
                    activity.startMainActivity(token);
                } else {
                    Toast.makeText((Context)activity, (CharSequence)("Error during auth: " + result.errorMessage), (int)0).show();
                }
            }
        }

        private class AuthResult {
            public Credential credential;
            public String errorMessage;
            public boolean success;

            public AuthResult(Credential credential) {
                this.credential = credential;
                this.success = true;
            }

            public AuthResult(String errorMessage) {
                this.errorMessage = errorMessage;
                this.success = false;
            }
        }
    }
}

