/*
 * Created on 2013.09.17.
 * 
 * Copyright 2013 progos.hu All rights reserved. PROGOS
 * PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 */

package com.samebug.notifier.servlet;

import com.samebug.notifier.ConfigurationFactory;
import com.samebug.notifier.core.IConfiguration;
import com.samebug.notifier.core.SamebugAsyncNotifier;
import com.samebug.notifier.core.exceptions.NotifierException;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

public class SamebugFilter implements Filter {
    private SamebugAsyncNotifier notifier;

    public void init(final FilterConfig config) throws ServletException {
        // TODO: handle filter config parameters in the same manner as system
        // properties
        final String applicationKey = config.getInitParameter("samebug.key");
        IConfiguration sbConfig = null;
        if (applicationKey != null) {
            sbConfig = ConfigurationFactory.fromAppKey(applicationKey);
        } else {
            sbConfig = ConfigurationFactory.fromDefault();
        }
        notifier = new SamebugAsyncNotifier(sbConfig);
    }

    private void notify(final ServletRequest request, final Throwable e) throws NotifierException {
        if (request instanceof HttpServletRequest) {
            final HttpServletRequest hr = (HttpServletRequest) request;
            final StringBuffer url = hr.getRequestURL();
            final String qs = hr.getQueryString();

            final StringBuilder sb = new StringBuilder();
            sb.append("Unhandled exception at ").append(url).append(" : ");
            if (qs != null) {
                sb.append("?").append(qs);
            }
            notifier.notify(sb.toString(), e);
        } else {
            notifier.notify("Unhandled exception", e);
        }
    }

    public void destroy() {
        // SKIP
    }

    public void doFilter(final ServletRequest request, final ServletResponse response, final FilterChain chain) throws IOException, ServletException {
        try {
            chain.doFilter(request, response);
        } catch (final IOException e) {
            notify(request, e);
            throw e;
        } catch (final ServletException e) {
            notify(request, e);
            throw e;
        } catch (final RuntimeException e) {
            notify(request, e);
            throw e;
        } catch (final Error e) {
            notify(request, e);
            throw e;
        }
    }
}
