/*
 * Decompiled with CFR 0.152.
 */
package com.samebug.notifier.jboss;

import com.samebug.notifier.ConfigurationFactory;
import com.samebug.notifier.IReporter;
import com.samebug.notifier.StreamReporter;
import com.samebug.notifier.core.IConfiguration;
import com.samebug.notifier.core.IResponse;
import com.samebug.notifier.core.SamebugNotifier;
import com.samebug.notifier.core.exceptions.NotifierException;
import com.samebug.notifier.core.exceptions.RecorderError;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class SamebugHandler
extends Handler {
    private SamebugNotifier notifier = null;
    private Properties properties = new Properties();
    private IReporter reporter = null;

    public void publish(LogRecord record) {
        if (this.notifier == null) {
            this.configure();
        }
        if (record.getThrown() != null) {
            try {
                IResponse resp = this.notifier.notify(record.getMessage(), record.getThrown(), new Date());
                this.reporter.handleResponse(resp);
            }
            catch (RecorderError e) {
                this.reporter.handleRecorderError(e);
            }
            catch (NotifierException e) {
                this.reporter.handleNotifierException(e);
            }
        }
    }

    public void flush() {
    }

    public void close() throws SecurityException {
    }

    public void setAppKey(String appKey) {
        this.properties.put("samebug.key", appKey);
    }

    public void setVersion(String version) {
        this.properties.put("samebug.version", version);
    }

    public void setServerURL(String recorderURL) {
        this.properties.put("samebug.server", recorderURL);
    }

    public void setDebug(String debug) {
        this.properties.put("samebug.debug", debug);
    }

    public void setUIURL(String uiURL) {
        this.properties.put("samebug.ui", uiURL);
    }

    public void setHelpMode(String helpMode) {
        this.properties.put("samebug.help", helpMode);
    }

    private void configure() {
        IConfiguration config = ConfigurationFactory.fromProperties(this.properties);
        this.notifier = new SamebugNotifier(config);
        this.reporter = new StreamReporter(config);
    }
}

