/*
 * Decompiled with CFR 0.152.
 */
package com.samebug.notifier;

import com.samebug.notifier.IReporter;
import com.samebug.notifier.core.IConfiguration;
import com.samebug.notifier.core.IResponse;
import com.samebug.notifier.core.Solution;
import com.samebug.notifier.core.exceptions.NotifierException;
import com.samebug.notifier.core.exceptions.RecorderError;
import java.io.PrintStream;
import java.util.UUID;

public class StreamReporter
implements IReporter {
    private final IConfiguration config;
    private final PrintStream info;
    private final PrintStream error;

    public StreamReporter(IConfiguration config) {
        this(config, System.err, System.err);
    }

    public StreamReporter(IConfiguration config, PrintStream info, PrintStream error) {
        this.config = config;
        this.info = info;
        this.error = error;
    }

    public IResponse handleResponse(IResponse response) {
        switch (this.config.getHelpMode()) {
            case 1: {
                this.info.println("You can inspect your crash at " + response.getBugURL());
                break;
            }
            case 2: {
                UUID solId = response.getSolutionId();
                if (solId == null) {
                    this.info.println("Samebug logged your crash. Check it at " + response.getBugURL());
                    break;
                }
                Solution sol = response.getSolution();
                if (sol == null) {
                    this.info.println("Ask for help related to your crash at " + response.getSolutionURL());
                    break;
                }
                this.info.println("@" + sol.getAuthor() + " says:\n" + sol.getComment() + "\nSee more at " + response.getSolutionURL());
            }
        }
        return response;
    }

    public RecorderError handleRecorderError(RecorderError re) {
        this.error.format("Failed to record an error to Samebug. Server responsed %d:\n%s\n", re.getCode(), re.getMessage());
        if (this.config.getDebug()) {
            re.printStackTrace(this.error);
        }
        return re;
    }

    public NotifierException handleNotifierException(NotifierException e) {
        this.error.println("Error in samebug notifier (code " + e.getErrorCode() + "): " + e.getMessage());
        if (this.config.getDebug()) {
            e.printStackTrace(this.error);
        }
        return e;
    }
}

