/*
 * Decompiled with CFR 0.152.
 */
package com.samebug.notifier;

import com.samebug.notifier.Configuration;
import com.samebug.notifier.core.IConfiguration;
import com.samebug.notifier.core.exceptions.BadAppKey;
import com.samebug.notifier.core.exceptions.BadConfigFile;
import com.samebug.notifier.core.exceptions.BadDeveloperKey;
import com.samebug.notifier.core.exceptions.BadHelpMode;
import com.samebug.notifier.core.exceptions.BadServerAddress;
import com.samebug.notifier.core.exceptions.MultipleConfigFileException;
import com.samebug.notifier.core.exceptions.NoConfigFileException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;

public class ConfigurationFactory {
    private static final String SAMEBUG_USER_CONFIG = "/.samebug/config";
    public static final String K_APP_KEY = "samebug.key";
    public static final String K_VERSION = "samebug.version";
    public static final String K_RECORDER_URL = "samebug.server";
    public static final String K_DEBUG = "samebug.debug";
    public static final String K_UI_URL = "samebug.ui";
    public static final String K_DEVELOPER_KEY = "samebug.developer.key";
    public static final String K_HELP_MODE = "samebug.help";
    public static final String DEF_APP_KEY = null;
    public static final String DEF_VERSION = null;
    public static final String DEF_RECORDER_URL = "http://recorder.samebug.io";
    public static final String DEF_DEBUG = "false";
    public static final String DEF_UI_URL = "http://beta.samebug.io";
    public static final String DEF_DEVELOPER_KEY = null;
    public static final String DEF_HELP_MODE = "0";
    public static final String DEFAULT_PROPERTY_RESOURCE = "samebug.properties";

    public static UUID parseAppKey(String appKey) throws BadAppKey {
        if (appKey == null) {
            throw new BadAppKey("Application key is missing!");
        }
        try {
            return UUID.fromString(appKey);
        }
        catch (IllegalArgumentException e) {
            throw new BadAppKey(appKey + " is not parsable as application key", (Throwable)e);
        }
    }

    public static String parseVersion(String version) {
        return version;
    }

    public static URL parseRecorderURL(String serverAddress) throws BadServerAddress {
        if (serverAddress == null) {
            throw new BadServerAddress("Recorder address must not be null.");
        }
        try {
            return new URI(serverAddress).toURL();
        }
        catch (URISyntaxException e) {
            throw new BadServerAddress(serverAddress + " is not a valid URI", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BadServerAddress(serverAddress + " is not an absolute URI", (Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new BadServerAddress(serverAddress + " is not a valid URL", (Throwable)e);
        }
    }

    public static URL parseUIURL(String serverAddress) throws BadServerAddress {
        if (serverAddress == null) {
            throw new BadServerAddress("UI address must not be null.");
        }
        try {
            return new URI(serverAddress).toURL();
        }
        catch (URISyntaxException e) {
            throw new BadServerAddress(serverAddress + " is not a valid URI", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BadServerAddress(serverAddress + " is not an absolute URI", (Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new BadServerAddress(serverAddress + " is not a valid URL", (Throwable)e);
        }
    }

    public static boolean parseDebug(String debug) {
        return !debug.equals(DEF_DEBUG);
    }

    public static UUID parseDeveloperKey(String userKey) throws BadDeveloperKey {
        if (userKey == null) {
            return null;
        }
        try {
            return UUID.fromString(userKey);
        }
        catch (IllegalArgumentException e) {
            throw new BadDeveloperKey(userKey + " is not parsable as user key", (Throwable)e);
        }
    }

    public static int parseHelpMode(String helpMode) throws BadHelpMode {
        if (helpMode == null) {
            return 0;
        }
        try {
            return Integer.parseInt(helpMode);
        }
        catch (NumberFormatException e) {
            throw new BadHelpMode(helpMode + " is not parsable as help mode", (Throwable)e);
        }
    }

    public static IConfiguration fromDefault() throws NoConfigFileException, MultipleConfigFileException, BadConfigFile, BadHelpMode, BadServerAddress, BadDeveloperKey {
        String resource = System.getProperty("samebug.config.resource");
        String file = System.getProperty("samebug.config.file");
        if (resource == null && file == null) {
            return ConfigurationFactory.fromPropertyResource(DEFAULT_PROPERTY_RESOURCE);
        }
        if (resource != null && file == null) {
            return ConfigurationFactory.fromPropertyResource(resource);
        }
        if (resource == null && file != null) {
            return ConfigurationFactory.fromPropertyFile(file);
        }
        throw new MultipleConfigFileException("You specified more than one property file for samebug:\nsamebug.config.file=" + file + "\nsamebug.config.resource=" + resource);
    }

    public static IConfiguration fromPropertyResource(String resourceName) throws NoConfigFileException, MultipleConfigFileException, BadConfigFile, BadServerAddress, BadHelpMode {
        try {
            Enumeration<URL> urls = ConfigurationFactory.class.getClassLoader().getResources(resourceName);
            if (!urls.hasMoreElements()) {
                throw new NoConfigFileException("No configuration resource found with name " + resourceName);
            }
            URL onlyConfig = urls.nextElement();
            if (urls.hasMoreElements()) {
                throw new MultipleConfigFileException("Multiple configuration resource found in the classpath with name " + resourceName);
            }
            InputStream propStream = onlyConfig.openStream();
            Properties props = new Properties();
            try {
                props.load(propStream);
                return ConfigurationFactory.fromProperties(props);
            }
            catch (IOException e) {
                throw new BadConfigFile("Configuration resource " + resourceName + " is not a valid property file", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new BadConfigFile("Configuration resource " + resourceName + " has malformed unicode escape sequences", (Throwable)e);
            }
        }
        catch (IOException e) {
            throw new NoConfigFileException("The configuration resource " + resourceName + " could not be opened", (Throwable)e);
        }
    }

    public static IConfiguration fromPropertyFile(String fileName) throws NoConfigFileException, MultipleConfigFileException, BadConfigFile, BadServerAddress, BadHelpMode {
        FileInputStream propFile;
        Properties props = new Properties();
        try {
            propFile = new FileInputStream(fileName);
        }
        catch (FileNotFoundException e) {
            throw new NoConfigFileException("No configuration file found: " + fileName, (Throwable)e);
        }
        try {
            props.load(propFile);
            return ConfigurationFactory.fromProperties(props);
        }
        catch (IOException e) {
            throw new BadConfigFile("Configuration file " + fileName + " is not a valid property file", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BadConfigFile("Configuration file " + fileName + " has malformed unicode escape sequences", (Throwable)e);
        }
    }

    public static IConfiguration fromAppKey(String appKey) throws BadAppKey {
        Properties props = new Properties();
        props.put(K_APP_KEY, appKey);
        return ConfigurationFactory.fromProperties(props);
    }

    public static IConfiguration fromProperties(Properties props) {
        props.putAll((Map<?, ?>)System.getProperties());
        String appKey = props.getProperty(K_APP_KEY, DEF_APP_KEY);
        String version = props.getProperty(K_VERSION, DEF_VERSION);
        String recorderAddress = props.getProperty(K_RECORDER_URL, DEF_RECORDER_URL);
        String debug = props.getProperty(K_DEBUG, DEF_DEBUG);
        String developerKey = DEF_DEVELOPER_KEY;
        String uiAddress = props.getProperty(K_UI_URL, DEF_UI_URL);
        String helpMode = props.getProperty(K_HELP_MODE, DEF_HELP_MODE);
        try {
            File userHome = new File(System.getProperty("user.home"));
            Properties userProps = new Properties();
            FileInputStream userPropFile = new FileInputStream(userHome + SAMEBUG_USER_CONFIG);
            userProps.load(userPropFile);
            developerKey = userProps.getProperty(K_DEVELOPER_KEY, DEF_DEVELOPER_KEY);
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return new Configuration(ConfigurationFactory.parseAppKey(appKey), ConfigurationFactory.parseVersion(version), ConfigurationFactory.parseRecorderURL(recorderAddress), ConfigurationFactory.parseDebug(debug), ConfigurationFactory.parseDeveloperKey(developerKey), ConfigurationFactory.parseUIURL(uiAddress), ConfigurationFactory.parseHelpMode(helpMode));
    }
}

