/*
 * Decompiled with CFR 0.152.
 */
package com.samebug.notifier.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import com.samebug.notifier.ConfigurationFactory;
import com.samebug.notifier.IReporter;
import com.samebug.notifier.StreamReporter;
import com.samebug.notifier.core.IConfiguration;
import com.samebug.notifier.core.IResponse;
import com.samebug.notifier.core.SamebugNotifier;
import com.samebug.notifier.core.exceptions.NotifierException;
import com.samebug.notifier.core.exceptions.RecorderError;
import com.samebug.notifier.core.proxy.ThrowableProxy;
import com.samebug.notifier.logback.LogbackThrowableProxy;
import java.util.Date;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SamebugAppender
extends AppenderBase<ILoggingEvent>
implements Runnable {
    private int queueSize = 0;
    private BlockingQueue<ILoggingEvent> queue;
    private Future<?> task;
    private final SamebugNotifier notifier;
    private final IReporter reporter;

    public SamebugAppender() {
        this(ConfigurationFactory.fromDefault());
    }

    public SamebugAppender(IConfiguration config) {
        this.reporter = new StreamReporter(config);
        this.notifier = new SamebugNotifier(config);
    }

    public void start() {
        if (this.isStarted()) {
            return;
        }
        int errorCount = 0;
        if (this.queueSize < 0) {
            ++errorCount;
            this.addError("Queue size must be non-negative");
        }
        if (errorCount == 0) {
            this.queue = this.newBlockingQueue(this.queueSize);
            this.task = this.getContext().getExecutorService().submit(this);
            super.start();
        }
    }

    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        this.task.cancel(true);
        super.stop();
    }

    protected void append(ILoggingEvent event) {
        if (event == null || event.getThrowableProxy() == null || !this.isStarted()) {
            return;
        }
        try {
            this.queue.put(event);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public final void run() {
        block5: while (true) {
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    ILoggingEvent event = this.queue.take();
                    try {
                        IResponse response = this.notifier.notify(event.getMessage(), (ThrowableProxy)new LogbackThrowableProxy(event.getThrowableProxy()), new Date());
                        this.reporter.handleResponse(response);
                        continue block5;
                    }
                    catch (RecorderError e) {
                        this.reporter.handleRecorderError(e);
                    }
                    catch (NotifierException e) {
                        this.reporter.handleNotifierException(e);
                    }
                }
                break;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
                break;
            }
        }
    }

    BlockingQueue<ILoggingEvent> newBlockingQueue(int size) {
        return (BlockingQueue)((Object)(size <= 0 ? new SynchronousQueue() : new ArrayBlockingQueue(size)));
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public int getQueueSize() {
        return this.queueSize;
    }
}

