/*
 * Decompiled with CFR 0.152.
 */
package com.samebug.notifier;

import com.samebug.notifier.IReporter;
import com.samebug.notifier.StreamReporter;
import com.samebug.notifier.core.IConfiguration;
import com.samebug.notifier.core.INotifier;
import com.samebug.notifier.core.SamebugNotifier;
import com.samebug.notifier.core.exceptions.NotifierException;
import com.samebug.notifier.core.exceptions.RecorderError;

public class SamebugUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private final IReporter reporter;
    private final INotifier notifier;
    private final Thread.UncaughtExceptionHandler defaultHandler;

    public SamebugUncaughtExceptionHandler(IConfiguration config, Thread.UncaughtExceptionHandler handler) {
        assert (config != null);
        assert (handler != null);
        this.reporter = new StreamReporter(config);
        this.notifier = new SamebugNotifier(config);
        this.defaultHandler = handler;
    }

    public void uncaughtException(Thread t, Throwable e) {
        try {
            this.reporter.handleResponse(this.notifier.notify("Uncaught exception", e));
        }
        catch (RecorderError re) {
            this.reporter.handleRecorderError(re);
        }
        catch (NotifierException ne) {
            this.reporter.handleNotifierException(ne);
        }
        this.defaultHandler.uncaughtException(t, e);
    }
}

