/*
 * Created on 2013.09.02.
 * 
 * Copyright 2013 progos.hu All rights reserved. PROGOS
 * PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * Author: arpadtamasi
 * $URL$
 * $Rev$
 * $Author$
 * $Date$
 * $Id$
 *
 */

package com.samebug.notifier.log4j;

import java.util.Date;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;

import com.samebug.notifier.ConfigurationFactory;
import com.samebug.notifier.IReporter;
import com.samebug.notifier.StreamReporter;
import com.samebug.notifier.core.IConfiguration;
import com.samebug.notifier.core.IResponse;
import com.samebug.notifier.core.SamebugNotifier;
import com.samebug.notifier.core.exceptions.NotifierException;
import com.samebug.notifier.core.exceptions.RecorderError;

public class SamebugAppender extends AppenderSkeleton {
    private final IReporter reporter;
    private final SamebugNotifier notifier;

    public SamebugAppender() {
        this(ConfigurationFactory.fromDefault());
    }

    public SamebugAppender(final IConfiguration config) {
        super();
        reporter = new StreamReporter(config);
        notifier = new SamebugNotifier(config);
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }

    @Override
    protected void append(final LoggingEvent event) {
        if (event.getThrowableInformation() != null) {
            try {
                IResponse response = notifier.notify(event.getMessage() == null ? null : String.valueOf(event.getMessage()), event.getThrowableInformation().getThrowable(), new Date());
                reporter.handleResponse(response);
            } catch (final RecorderError e) {
                reporter.handleRecorderError(e);
            } catch (final NotifierException e) {
                reporter.handleNotifierException(e);
            }
        }
    }
}
