/*
 * Decompiled with CFR 0.152.
 */
package com.samebug.notifier.jul;

import com.samebug.notifier.SamebugNotifier;
import com.samebug.notifier.exceptions.NotifierException;
import java.util.Date;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class SamebugHandler
extends Handler {
    private final SamebugNotifier notifier = new SamebugNotifier();

    public void publish(LogRecord record) {
        if (record.getThrown() != null && record.getLevel() == Level.SEVERE) {
            try {
                this.notifier.notify(record.getMessage(), record.getThrown(), new Date());
            }
            catch (NotifierException e) {
                System.err.println("Error in samebug notifier (code " + e.getErrorCode() + "): " + e.getMessage());
                if (this.notifier.getConfiguration().getDebug()) {
                    e.printStackTrace(System.err);
                }
            }
            catch (RuntimeException e) {
                if (this.notifier.getConfiguration().getDebug()) {
                    e.printStackTrace(System.err);
                }
                throw e;
            }
        }
    }

    public void flush() {
    }

    public void close() throws SecurityException {
    }
}

