/*
 * Decompiled with CFR 0.152.
 */
package com.samebug.notifier.jboss;

import com.samebug.notifier.Configuration;
import com.samebug.notifier.SamebugNotifier;
import com.samebug.notifier.exceptions.NotifierException;
import java.util.Date;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class SamebugHandler
extends Handler {
    private SamebugNotifier notifier = null;
    private String appKey = null;
    private String version = null;
    private String serverURL = "http://recorder.samebug.io";
    private String debug = "false";

    public void publish(LogRecord record) {
        if (this.notifier == null) {
            this.configure();
        }
        if (record.getThrown() != null) {
            try {
                this.notifier.notify(record.getMessage(), record.getThrown(), new Date());
            }
            catch (NotifierException e) {
                System.err.println("Error in samebug notifier (code " + e.getErrorCode() + "): " + e.getMessage());
                if (this.notifier.getConfiguration().getDebug()) {
                    e.printStackTrace(System.err);
                }
            }
            catch (RuntimeException e) {
                if (this.notifier.getConfiguration().getDebug()) {
                    e.printStackTrace(System.err);
                }
                throw e;
            }
        }
    }

    public void flush() {
    }

    public void close() throws SecurityException {
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setServerURL(String serverURL) {
        this.serverURL = serverURL;
    }

    public void setDebug(String debug) {
        this.debug = debug;
    }

    private void configure() {
        Configuration conf = new Configuration(this.appKey);
        conf.setVersion(this.version);
        conf.setServer(this.serverURL);
        conf.setDebug(this.debug);
        this.notifier = new SamebugNotifier(conf);
    }
}

