/*
 * Decompiled with CFR 0.152.
 */
package com.samebug.notifier;

import com.samebug.notifier.Configuration;
import com.samebug.notifier.Connection;
import com.samebug.notifier.Encoder;
import com.samebug.notifier.INotifier;
import com.samebug.notifier.exceptions.BadAppKey;
import com.samebug.notifier.exceptions.BadServerAddress;
import com.samebug.notifier.exceptions.JsonEncodingException;
import com.samebug.notifier.exceptions.MultipleConfigFileException;
import com.samebug.notifier.exceptions.NoConfigFileException;
import com.samebug.notifier.exceptions.NotifierException;
import com.samebug.notifier.exceptions.WriteError;
import com.samebug.notifier.proxy.DefaultThrowableProxy;
import com.samebug.notifier.proxy.ThrowableProxy;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.util.Date;
import java.util.UUID;

public class SamebugNotifier
implements INotifier {
    private final Configuration config;
    private final Connection connection;

    public SamebugNotifier() throws NoConfigFileException, MultipleConfigFileException, BadAppKey, BadServerAddress {
        this.config = Configuration.fromProperties();
        if (this.config.getDebug()) {
            System.err.println("Notifier initiated with this config:\n" + this.config);
        }
        this.connection = new Connection(this.config);
    }

    public SamebugNotifier(String appKey) throws BadAppKey {
        this.config = new Configuration(appKey);
        if (this.config.getDebug()) {
            System.err.println("Notifier initiated with this config:\n" + this.config);
        }
        this.connection = new Connection(this.config);
    }

    public SamebugNotifier(Configuration config) {
        this.config = config;
        if (config.getDebug()) {
            System.err.println("Notifier initiated with this config:\n" + config);
        }
        this.connection = new Connection(config);
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public UUID notify(String message, Throwable throwable) throws NotifierException {
        return this.notify(message, throwable, new Date());
    }

    public UUID notify(String message, ThrowableProxy throwable) throws NotifierException {
        return this.notify(message, throwable, new Date());
    }

    public UUID notify(String message, Throwable throwable, Date timestamp) throws NotifierException {
        return this.notify(message, new DefaultThrowableProxy(throwable), timestamp);
    }

    public UUID notify(String message, ThrowableProxy throwable, Date timestamp) throws NotifierException {
        if (this.config.getDebug()) {
            System.err.println("Attempt to send notification");
        }
        HttpURLConnection http = this.connection.createConnection();
        this.sendReport(message, throwable, timestamp, http);
        return this.connection.processResponse(http);
    }

    private void sendReport(String message, ThrowableProxy throwable, Date timestamp, HttpURLConnection connnection) throws WriteError, JsonEncodingException {
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter(connnection.getOutputStream());
            Encoder encoder = new Encoder(this.config, writer);
            encoder.encode(message, throwable, timestamp);
            writer.flush();
        }
        catch (IOException e) {
            throw new WriteError("Unable send error notification to " + this.config.getServerURL(), e);
        }
        finally {
            block11: {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        if (!this.config.getDebug()) break block11;
                        System.err.println("Failed to close output stream:\n");
                        e.printStackTrace(System.err);
                    }
                }
            }
        }
    }
}

