/*
 * Created on 2013.09.03.
 * 
 * Copyright 2013 progos.hu All rights reserved. PROGOS
 * PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * Author: arpadtamasi
 * $URL$
 * $Rev$
 * $Author$
 * $Date$
 * $Id$
 *
 */

package com.samebug.notifier;

import java.util.Date;
import java.util.UUID;

import com.samebug.notifier.exceptions.NotifierException;
import com.samebug.notifier.proxy.ThrowableProxy;

/**
 * Interface of Samebug Notifier
 * 
 * @author poroszd
 * 
 */
public interface INotifier {

	/**
	 * Notify Samebug about an exception
	 * 
	 * @param message custom message describing the event
	 * @param throwable the caught exception
	 * @return A UUID of the bug where this report was categorized
	 * @throws NotifierException
	 */
	public UUID notify(final String message, final Throwable throwable) throws NotifierException;

	/**
	 * Notify Samebug about an exception
	 * 
	 * @param message custom message describing the event
	 * @param throwable the caught exception
	 * @param timestamp the time of occurrence
	 * @return A UUID of the bug where this report was categorized
	 * @throws NotifierException
	 */
	public UUID notify(final String message, final Throwable throwable, final Date timestamp) throws NotifierException;

	/**
	 * Notify Samebug about an exception
	 * 
	 * @param message custom message describing the event
	 * @param throwableProxy proxy for the caught exception
	 * @return A UUID of the bug where this report was categorized
	 * @throws NotifierException
	 */
	public UUID notify(final String message, final ThrowableProxy throwableProxy) throws NotifierException;

	/**
	 * Notify Samebug about an exception
	 * 
	 * @param message custom message describing the event
	 * @param throwableProxy proxy for the caught exception
	 * @param timestamp the time of occurrence
	 * @return A UUID of the bug where this report was categorized
	 * @throws NotifierException
	 */
	public UUID notify(final String message, final ThrowableProxy throwableProxy, final Date timestamp) throws NotifierException;

}