/*
 * Created on 2010.03.09.
 * 
 * Copyright 2010 progos.hu All rights reserved. SAMEBUG
 * PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * Author: rp
 */

package com.samebug.notifier.exceptions;

public abstract class NotifierException extends RuntimeException {

    /**
     * 
     */
    private static final long serialVersionUID = 8224679402611463408L;

    public static final int BAD_SERVER_ADDRESS = 1;

    public static final int CONNECTION_ERROR = 5;

    public static final int CONNECTION_TIMEOUT = 4;

    public static final int JSON_ENCODING_ERROR = 13;

    public static final int MARSHALING_ERROR = 12;

    public static final int NO_RESPONSE = 7;

    public static final int NO_URI = 8;

    public static final int READ_ERROR = 10;

    public static final int READ_TIMEOUT = 9;

    public static final int UNKNOWN_ERROR = 11;

    public static final int UNKNOWN_PROTOCOL = 3;

    public static final int UNSUPPORTED_UTF8 = 2;

    public static final int URL_ENCODING_ERROR = 14;

    public static final int WRITE_ERROR = 6;

    public static final int NO_CONFIG_FILE = 15;

    public static final int MULTIPLE_CONFIG_FILE = 16;

    public static final int NO_APP_KEY = 17;

    public static final int BAD_APP_KEY = 18;

    public static final int BAD_CONFIG_FILE = 19;
    
    public static final int BAD_REQUEST = 20;

    public static final int ACCOUNT_EXPIRED = 21;

    public static final int REQUEST_TOO_LARGE = 22;

    public static final int ACCOUNT_LIMIT_EXCEEDED = 23;

    public NotifierException() {
        super();
    }

    public NotifierException(final String message) {
        super(message);
    }

    public NotifierException(final String message, final Throwable cause) {
        super(message, cause);
    }

    public NotifierException(final Throwable cause) {
        super(cause);
    }

    public abstract int getErrorCode();

}
