/*
 * Created on 2013.09.03.
 * 
 * Copyright 2013 progos.hu All rights reserved. PROGOS
 * PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * Author: arpadtamasi
 * $URL$
 * $Rev$
 * $Author$
 * $Date$
 * $Id$
 *
 */

package com.samebug.notifier.logback;

import ch.qos.logback.classic.spi.StackTraceElementProxy;

import com.samebug.notifier.proxy.StackTraceProxy;

final class LogbackStackTraceProxy implements StackTraceProxy {

    private final StackTraceElementProxy[] trace;

    public LogbackStackTraceProxy(final StackTraceElementProxy[] trace) {
        this.trace = trace;
    }

    public String[] getFrames() {
        final String[] frames = new String[this.trace.length];
        for (int i = 0; i < this.trace.length; ++i) {
            frames[i] = this.trace[i].getStackTraceElement().toString();
        }
        return frames;
    }

}
