/*
 * Created on 2013.09.18.
 * 
 * Copyright 2013 progos.hu All rights reserved. PROGOS
 * PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * Author: arpadtamasi
 * $URL$
 * $Rev$
 * $Author$
 * $Date$
 * $Id$
 *
 */

package com.samebug.notifier;

import java.lang.Thread.UncaughtExceptionHandler;

import com.samebug.notifier.exceptions.BadAppKey;
import com.samebug.notifier.exceptions.BadServerAddress;
import com.samebug.notifier.exceptions.MultipleConfigFileException;
import com.samebug.notifier.exceptions.NoConfigFileException;
import com.samebug.notifier.exceptions.NotifierException;
import com.samebug.notifier.exceptions.RecorderError;

/**
 * An uncaught exception handler, which sends the exceptions to Samebug.
 * <p>
 * This class uses {@link SamebugNotifier} under the hood, see there the configuration details.
 * @author poroszd
 *
 */
public class SamebugUncaughtExceptionHandler implements UncaughtExceptionHandler {

    private final SamebugNotifier notifier;

    /**
     * Construct using an underlying notifier with default configuration.
     */
    public SamebugUncaughtExceptionHandler() throws NoConfigFileException, MultipleConfigFileException, BadAppKey, BadServerAddress {
        notifier = new SamebugNotifier();
    }

    /**
     * Construct using an underlying notifier with the specified application key.
     */
    public SamebugUncaughtExceptionHandler(final String applicationKey) {
        this.notifier = new SamebugNotifier(applicationKey);
    }

    /**
     * Construct using an underlying notifier with the specified config.
     */
    public SamebugUncaughtExceptionHandler(final Configuration config) {
        this.notifier = new SamebugNotifier(config);
    }
    
    public void uncaughtException(final Thread t, final Throwable e) {
        try {
            this.notifier.notify("Uncaught exception", e);
        } catch (final RecorderError re) {
            System.err.println("Failed to record an error to Samebug. Server responsed:\n" + re.getCode() + ": " + re.getMessage());
        } catch (final NotifierException ne) {
            System.err.println("Failed to record an error to Samebug (code " + ne.getErrorCode() + "): " + ne.getMessage() + "\nCause:");
            ne.printStackTrace();
        }
    }
}
