/*
 * Decompiled with CFR 0.152.
 */
package com.samebug.notifier;

import com.samebug.notifier.AbstractNotifier;
import com.samebug.notifier.encoder.ContentEncoder;
import com.samebug.notifier.exceptions.ConnectionError;
import com.samebug.notifier.exceptions.ConnectionTimeout;
import com.samebug.notifier.exceptions.JsonEncodingException;
import com.samebug.notifier.exceptions.NoAppKeyDefinedException;
import com.samebug.notifier.exceptions.NoResponse;
import com.samebug.notifier.exceptions.NoURI;
import com.samebug.notifier.exceptions.NotifierException;
import com.samebug.notifier.exceptions.ReadError;
import com.samebug.notifier.exceptions.RecorderError;
import com.samebug.notifier.exceptions.UnknownProtocol;
import com.samebug.notifier.exceptions.UnsupportedUTF8;
import com.samebug.notifier.exceptions.UrlEncodingError;
import com.samebug.notifier.exceptions.WriteError;
import com.samebug.notifier.proxy.DefaultThrowableProxy;
import com.samebug.notifier.proxy.ThrowableProxy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.util.Date;
import java.util.UUID;

class SamebugNotifier
extends AbstractNotifier {
    private static final int SC_INTERNAL_SERVER_ERROR = 500;
    private static final int SC_UNAUTHORIZED = 401;

    public SamebugNotifier() {
    }

    public SamebugNotifier(String applicationKey) {
        super(applicationKey);
    }

    public UUID notify(String message, Throwable throwable) throws NotifierException {
        return this.notify(message, throwable, new Date());
    }

    public UUID notify(String message, ThrowableProxy throwable) throws NotifierException {
        return this.notify(message, throwable, new Date());
    }

    public UUID notify(String message, Throwable throwable, Date timestamp) throws NotifierException {
        return this.notify(message, new DefaultThrowableProxy(throwable), timestamp);
    }

    public UUID notify(String message, ThrowableProxy throwable, Date timestamp) throws NotifierException {
        HttpURLConnection connection = this.connect();
        this.sendReport(message, throwable, timestamp, connection);
        return this.processResponse(connection);
    }

    protected HttpURLConnection connect() throws UnknownProtocol, ConnectionTimeout, ConnectionError, UnsupportedUTF8, UrlEncodingError, NoAppKeyDefinedException {
        if (this.key == null) {
            throw new NoAppKeyDefinedException("Application key is not set in Samebug Notifier");
        }
        HttpURLConnection connection = this.createConnection();
        try {
            connection.setConnectTimeout(this.connectionTimeout);
            connection.setReadTimeout(this.readTimeout);
            connection.setRequestProperty("Content-Type", "application/json;charset=utf-8");
            connection.setRequestProperty("charset", "utf-8");
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Accept", "text/plain");
            connection.setRequestProperty("X-Samebug-Key", this.key);
            connection.setRequestProperty("X-Samebug-Platform", "Java");
            connection.setRequestProperty("X-Samebug-Version", "1.0.1");
            connection.setDoOutput(true);
            connection.connect();
        }
        catch (SocketTimeoutException e) {
            throw new ConnectionTimeout("Cannot connect to " + this.server, e);
        }
        catch (IOException e) {
            throw new ConnectionError("IO error while connecting to " + this.server, e);
        }
        return connection;
    }

    private void serialize(String message, ThrowableProxy throwable, Date timestamp, Writer writer) throws JsonEncodingException {
        ContentEncoder e = new ContentEncoder(writer);
        e.startObject();
        e.writeField("version", this.version);
        e.writeField("timestamp", timestamp);
        e.writeField("message", message);
        e.writeField("exception", throwable);
        e.endObject();
    }

    protected UUID processResponse(HttpURLConnection conn) throws RecorderError, NoResponse, NoURI, ReadError {
        try {
            int rc = conn.getResponseCode();
            String rm = conn.getResponseMessage();
            switch (rc) {
                default: 
            }
            if (rc < 200 || rc >= 300) {
                throw new RecorderError(rc, rm);
            }
        }
        catch (IOException e) {
            throw new NoResponse("Unable to process response from " + this.server, e);
        }
        BufferedReader rd = null;
        try {
            rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String line = rd.readLine();
            if (line != null) {
                UUID uUID = UUID.fromString(line);
                return uUID;
            }
            try {
                throw new NoURI("No report URI.");
            }
            catch (SocketTimeoutException e) {
                throw new ReadError("Unable to process response from " + this.server, e);
            }
            catch (IOException e) {
                throw new ReadError("Unable to process response from " + this.server, e);
            }
        }
        finally {
            if (rd != null) {
                try {
                    rd.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void sendReport(String message, ThrowableProxy throwable, Date timestamp, HttpURLConnection connnection) throws WriteError, JsonEncodingException {
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter(connnection.getOutputStream());
            this.serialize(message, throwable, timestamp, writer);
            writer.flush();
        }
        catch (IOException e) {
            throw new WriteError("Unable send error notification to " + this.server, e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

