/*
 * Created on 2013.09.18.
 * 
 * Copyright 2013 progos.hu All rights reserved. PROGOS
 * PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * Author: arpadtamasi
 * $URL$
 * $Rev$
 * $Author$
 * $Date$
 * $Id$
 *
 */

package com.samebug.notifier;

import java.lang.Thread.UncaughtExceptionHandler;

import com.samebug.notifier.exceptions.NotifierException;

public class SamebugUncaughtExceptionHandler implements UncaughtExceptionHandler {

	private final SamebugNotifier notifier;

	public SamebugUncaughtExceptionHandler() {
		notifier = new SamebugNotifier();
	}

	public SamebugUncaughtExceptionHandler(final String applicationKey) {
		this.notifier = new SamebugNotifier(applicationKey);
	}

	public void uncaughtException(final Thread t, final Throwable e) {
		try {
			this.notifier.notify("Uncaught exception", e);
		} catch (final NotifierException ne) {
			// TODO handle silently
		}
	}
}
