/*
 * Created on 2013.09.03.
 * 
 * Copyright 2013 progos.hu All rights reserved. PROGOS
 * PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * Author: arpadtamasi
 * $URL$
 * $Rev$
 * $Author$
 * $Date$
 * $Id$
 *
 */

package com.samebug.notifier.proxy;

public class DefaultStackTraceProxy implements StackTraceProxy {

    private final StackTraceElement[] trace;

    public DefaultStackTraceProxy(final StackTraceElement[] stackTrace) {
        this.trace = stackTrace;
    }

    public String[] getFrames() {
        final String[] frames = new String[this.trace.length];
        for (int i = 0; i < this.trace.length; ++i) {
            frames[i] = this.trace[i].toString();
        }
        return frames;
    }

    public int getCommonFrames(final DefaultStackTraceProxy other) {
        if (other == null) {
            return 0;
        }

        int m = this.trace.length - 1;
        int n = other.trace.length - 1;
        while (m >= 0 && n >= 0 && this.trace[m].equals(other.trace[n])) {
            m--;
            n--;
        }
        return this.trace.length - 1 - m;
    }

    public int getCommonFrames(final StackTraceProxy other) {
        if (other == null) {
            return 0;
        }

        if (other instanceof DefaultStackTraceProxy) {
            return getCommonFrames((DefaultStackTraceProxy) other);
        } else {
            final String[] thisFrames = getFrames();
            final String[] otherFrames = other.getFrames();

            int m = thisFrames.length - 1;
            int n = otherFrames.length - 1;
            while (m >= 0 && n >= 0 && thisFrames[m].equals(otherFrames[n])) {
                m--;
                n--;
            }
            return thisFrames.length - 1 - m;
        }
    }
}
