/*
 * Decompiled with CFR 0.152.
 */
package com.sambatech.player.plugins;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.Toast;
import com.google.ads.interactivemedia.v3.api.AdDisplayContainer;
import com.google.ads.interactivemedia.v3.api.AdErrorEvent;
import com.google.ads.interactivemedia.v3.api.AdEvent;
import com.google.ads.interactivemedia.v3.api.AdsLoader;
import com.google.ads.interactivemedia.v3.api.AdsManager;
import com.google.ads.interactivemedia.v3.api.AdsManagerLoadedEvent;
import com.google.ads.interactivemedia.v3.api.AdsRequest;
import com.google.ads.interactivemedia.v3.api.ImaSdkFactory;
import com.google.ads.interactivemedia.v3.api.ImaSdkSettings;
import com.google.ads.interactivemedia.v3.api.player.ContentProgressProvider;
import com.google.ads.interactivemedia.v3.api.player.VideoAdPlayer;
import com.google.ads.interactivemedia.v3.api.player.VideoProgressUpdate;
import com.google.android.libraries.mediaframework.exoplayerextensions.ExoplayerWrapper;
import com.google.android.libraries.mediaframework.exoplayerextensions.Video;
import com.google.android.libraries.mediaframework.layeredvideo.PlaybackControlLayer;
import com.google.android.libraries.mediaframework.layeredvideo.SimpleVideoPlayer;
import com.google.android.libraries.mediaframework.layeredvideo.Util;
import com.sambatech.player.R;
import com.sambatech.player.SambaPlayer;
import com.sambatech.player.event.SambaEvent;
import com.sambatech.player.event.SambaEventBus;
import com.sambatech.player.event.SambaPlayerListener;
import com.sambatech.player.model.SambaMedia;
import com.sambatech.player.model.SambaMediaConfig;
import com.sambatech.player.plugins.Plugin;
import com.sambatech.player.plugins.PluginManager;
import java.util.ArrayList;
import java.util.List;

public class ImaWrapper
implements Plugin {
    private static String PLAYER_TYPE = "google/gmf-android";
    private static String PLAYER_VERSION = "0.2.0";
    private Activity activity;
    private Uri adTagUrl;
    private SimpleVideoPlayer adPlayer;
    private FrameLayout adPlayerContainer;
    private FrameLayout adUiContainer;
    private AdsLoader adsLoader;
    private AdsManager adsManager;
    private AdListener adListener;
    private List<VideoAdPlayer.VideoAdPlayerCallback> callbacks;
    private FrameLayout container;
    private SambaPlayer contentPlayer;
    private PlaybackControlLayer.FullscreenCallback fullscreenCallback;
    private VideoProgressUpdate oldVpu;
    private ViewGroup.LayoutParams originalContainerLayoutParams;
    private ContentProgressProvider contentProgressProvider;
    private boolean adsShown;
    private final ExoplayerWrapper.PlaybackListener adPlaybackListener = new ExoplayerWrapper.PlaybackListener(){

        public void onError(Exception e) {
            Log.i((String)"ima", (String)("ad player error: " + e.getMessage()));
        }

        public void onStateChanged(boolean playWhenReady, int playbackState) {
            if (playbackState == 5) {
                for (VideoAdPlayer.VideoAdPlayerCallback callback : ImaWrapper.this.callbacks) {
                    callback.onEnded();
                }
            }
        }

        public void onVideoSizeChanged(int width, int height, int unappliedRotationDegrees, float pixelWidthHeightRatio) {
        }
    };
    private final VideoAdPlayer videoAdPlayer = new VideoAdPlayer(){

        public void playAd() {
            ImaWrapper.this.hideContentPlayer();
            ImaWrapper.this.adPlayer.play();
            for (VideoAdPlayer.VideoAdPlayerCallback callback : ImaWrapper.this.callbacks) {
                callback.onPlay();
            }
        }

        public void loadAd(String mediaUri) {
            ImaWrapper.this.adTagUrl = Uri.parse((String)mediaUri);
            ImaWrapper.this.createAdPlayer();
        }

        public void stopAd() {
            ImaWrapper.this.destroyAdPlayer();
            ImaWrapper.this.showContentPlayer();
        }

        public void pauseAd() {
            if (ImaWrapper.this.adPlayer != null) {
                ImaWrapper.this.adPlayer.pause();
            }
        }

        public void resumeAd() {
            if (ImaWrapper.this.adPlayer != null) {
                ImaWrapper.this.adPlayer.play();
            }
        }

        public void addCallback(VideoAdPlayer.VideoAdPlayerCallback videoAdPlayerCallback) {
            ImaWrapper.this.callbacks.add(videoAdPlayerCallback);
        }

        public void removeCallback(VideoAdPlayer.VideoAdPlayerCallback videoAdPlayerCallback) {
            ImaWrapper.this.callbacks.remove(videoAdPlayerCallback);
        }

        public VideoProgressUpdate getAdProgress() {
            VideoProgressUpdate vpu;
            VideoProgressUpdate videoProgressUpdate = vpu = ImaWrapper.this.adPlayer != null && ImaWrapper.this.adPlayer.getDuration() > 0 ? new VideoProgressUpdate((long)ImaWrapper.this.adPlayer.getCurrentPosition(), (long)ImaWrapper.this.adPlayer.getDuration()) : VideoProgressUpdate.VIDEO_TIME_NOT_READY;
            if (ImaWrapper.this.oldVpu == null) {
                ImaWrapper.this.oldVpu = vpu;
            } else if (!vpu.equals((Object)VideoProgressUpdate.VIDEO_TIME_NOT_READY) && vpu.getCurrentTime() == ImaWrapper.this.oldVpu.getCurrentTime() && ImaWrapper.this.adPlayer != null && ImaWrapper.this.adPlayer.shouldBePlaying()) {
                ImaWrapper.this.adPlayer.pause();
                ImaWrapper.this.adPlayer.play();
            }
            ImaWrapper.this.oldVpu = vpu;
            return vpu;
        }
    };
    private SambaPlayerListener playerListener = new SambaPlayerListener(){

        @Override
        public void onLoad(SambaEvent event) {
            if (!ImaWrapper.this.adsShown && ImaWrapper.this.adTagUrl != null) {
                ImaWrapper.this.requestAd();
                ImaWrapper.this.adsShown = true;
            }
        }

        @Override
        public void onFullscreen(SambaEvent e) {
            if (ImaWrapper.this.adPlayer == null) {
                ImaWrapper.this.container.setLayoutParams(Util.getLayoutParamsBasedOnParent((View)ImaWrapper.this.container, (int)-1, (int)-1));
            }
        }

        @Override
        public void onFullscreenExit(SambaEvent e) {
            if (ImaWrapper.this.adPlayer == null) {
                ImaWrapper.this.container.setLayoutParams(ImaWrapper.this.originalContainerLayoutParams);
            }
        }

        @Override
        public void onFinish(SambaEvent event) {
            if (ImaWrapper.this.adsLoader != null) {
                ImaWrapper.this.adsLoader.contentComplete();
            }
        }
    };

    @Override
    public void onLoad(@NonNull SambaPlayer player) {
        Log.i((String)"ima", (String)"load");
        SambaMedia media = player.getMedia();
        if (media.adUrl == null || media.adUrl.isEmpty()) {
            PluginManager.getInstance().notifyPluginLoaded(this);
            return;
        }
        this.adTagUrl = Uri.parse((String)media.adUrl);
        this.contentPlayer = player;
        this.container = player;
        this.activity = (Activity)this.container.getContext();
        ImaSdkSettings sdkSettings = ImaSdkFactory.getInstance().createImaSdkSettings();
        sdkSettings.setPlayerType(PLAYER_TYPE);
        sdkSettings.setPlayerVersion(PLAYER_VERSION);
        this.adsLoader = ImaSdkFactory.getInstance().createAdsLoader((Context)this.activity, sdkSettings);
        this.adListener = new AdListener();
        this.adsLoader.addAdErrorListener((AdErrorEvent.AdErrorListener)this.adListener);
        this.adsLoader.addAdsLoadedListener((AdsLoader.AdsLoadedListener)this.adListener);
        this.callbacks = new ArrayList<VideoAdPlayer.VideoAdPlayerCallback>();
        this.adUiContainer = new FrameLayout((Context)this.activity);
        this.container.addView((View)this.adUiContainer);
        this.adUiContainer.setLayoutParams(Util.getLayoutParamsBasedOnParent((View)this.adUiContainer, (int)-1, (int)-1));
        this.originalContainerLayoutParams = this.container.getLayoutParams();
        this.contentProgressProvider = new ContentProgressProvider(){

            public VideoProgressUpdate getContentProgress() {
                return ImaWrapper.this.contentPlayer != null && ImaWrapper.this.contentPlayer.getDuration() > 0.0f ? new VideoProgressUpdate((long)(ImaWrapper.this.contentPlayer.getCurrentTime() * 1000.0f), (long)ImaWrapper.this.contentPlayer.getDuration()) : VideoProgressUpdate.VIDEO_TIME_NOT_READY;
            }
        };
        SambaEventBus.subscribe(this.playerListener);
        PluginManager.getInstance().notifyPluginLoaded(this);
    }

    @Override
    public void onInternalPlayerCreated(@NonNull SimpleVideoPlayer internalPlayer) {
    }

    @Override
    public void onDestroy() {
        Log.i((String)"ima:", (String)String.valueOf(this.adsLoader == null));
        if (this.adsLoader == null) {
            return;
        }
        this.contentPlayer = null;
        SambaEventBus.unsubscribe(this.playerListener);
        this.destroyAdPlayer();
        this.release();
    }

    public void pause() {
        if (this.adPlayer != null) {
            this.adPlayer.pause();
        }
    }

    public void play() {
        if (this.adTagUrl != null) {
            this.requestAd();
        }
    }

    public void release() {
        if (this.adPlayer != null) {
            this.adPlayer.release();
            this.adPlayer = null;
        }
        if (this.adsManager != null) {
            this.adsManager.destroy();
            this.adsManager = null;
        }
        if (this.adsLoader != null) {
            this.adsLoader.removeAdsLoadedListener((AdsLoader.AdsLoadedListener)this.adListener);
            this.adsLoader.removeAdErrorListener((AdErrorEvent.AdErrorListener)this.adListener);
            this.adsLoader = null;
        }
    }

    private void createAdPlayer() {
        this.destroyAdPlayer();
        this.adPlayerContainer = new FrameLayout((Context)this.activity);
        this.container.addView((View)this.adPlayerContainer);
        this.adPlayerContainer.setLayoutParams(Util.getLayoutParamsBasedOnParent((View)this.adPlayerContainer, (int)-1, (int)-1));
        this.container.removeView((View)this.adUiContainer);
        this.container.addView((View)this.adUiContainer);
        Video adVideo = new Video(this.adTagUrl.toString(), Video.VideoType.MP4);
        this.adPlayer = new SimpleVideoPlayer(this.activity, this.adPlayerContainer, adVideo, "", true, false, 0, this.fullscreenCallback);
        this.adPlayer.addPlaybackListener(this.adPlaybackListener);
        this.adPlayer.moveSurfaceToForeground();
        this.adPlayer.disableSeeking();
        SambaMediaConfig m = (SambaMediaConfig)this.contentPlayer.getMedia();
        this.adPlayer.setThemeColor(m != null ? m.themeColor : -256);
        this.adPlayer.hideTopChrome();
        this.adPlayer.setFullscreen(this.contentPlayer.isFullscreen());
    }

    private void destroyAdPlayer() {
        if (this.adPlayerContainer != null) {
            this.container.removeView((View)this.adPlayerContainer);
        }
        if (this.adUiContainer != null) {
            this.container.removeView((View)this.adUiContainer);
        }
        if (this.adPlayer != null) {
            this.adPlayer.release();
        }
        this.adPlayerContainer = null;
        this.adPlayer = null;
    }

    private void hideContentPlayer() {
        this.contentPlayer.pause();
        this.contentPlayer.hide();
    }

    private void showContentPlayer() {
        if (this.contentPlayer == null) {
            return;
        }
        this.contentPlayer.show();
        if (!this.contentPlayer.hasFinished()) {
            this.contentPlayer.play();
        }
    }

    private void pauseContent() {
        this.hideContentPlayer();
        for (VideoAdPlayer.VideoAdPlayerCallback callback : this.callbacks) {
            callback.onPause();
        }
    }

    private void resumeContent() {
        if (this.contentPlayer == null) {
            return;
        }
        if (this.contentPlayer.hasFinished()) {
            return;
        }
        this.destroyAdPlayer();
        this.showContentPlayer();
        for (VideoAdPlayer.VideoAdPlayerCallback callback : this.callbacks) {
            callback.onResume();
        }
    }

    private AdsRequest buildAdsRequest(String tagUrl) {
        AdDisplayContainer adDisplayContainer = ImaSdkFactory.getInstance().createAdDisplayContainer();
        adDisplayContainer.setPlayer(this.videoAdPlayer);
        adDisplayContainer.setAdContainer((ViewGroup)this.adUiContainer);
        AdsRequest request = ImaSdkFactory.getInstance().createAdsRequest();
        request.setAdTagUrl(tagUrl);
        request.setContentProgressProvider(this.contentProgressProvider);
        request.setAdDisplayContainer(adDisplayContainer);
        return request;
    }

    private void requestAd() {
        this.adsLoader.requestAds(this.buildAdsRequest(this.adTagUrl.toString()));
    }

    private class AdListener
    implements AdErrorEvent.AdErrorListener,
    AdsLoader.AdsLoadedListener,
    AdEvent.AdEventListener {
        private ImageView img;
        private FrameLayout.LayoutParams layoutParams;

        public AdListener() {
            this.img = new ImageView((Context)ImaWrapper.this.activity);
            this.img.setImageResource(R.drawable.play);
        }

        public void onAdError(AdErrorEvent adErrorEvent) {
            Log.d((String)this.getClass().getSimpleName(), (String)adErrorEvent.getError().getMessage());
            Toast.makeText((Context)ImaWrapper.this.activity, (CharSequence)adErrorEvent.getError().getMessage(), (int)0).show();
            ImaWrapper.this.resumeContent();
        }

        public void onAdEvent(AdEvent event) {
            Log.i((String)"ima", (String)(event.getType() + ""));
            switch (event.getType()) {
                case LOADED: {
                    ImaWrapper.this.adsManager.start();
                    break;
                }
                case CONTENT_PAUSE_REQUESTED: {
                    ImaWrapper.this.pauseContent();
                    break;
                }
                case CONTENT_RESUME_REQUESTED: {
                    ImaWrapper.this.resumeContent();
                    break;
                }
                case CLICKED: {
                    this.layoutParams = new FrameLayout.LayoutParams(ImaWrapper.this.adUiContainer.getLayoutParams());
                    this.layoutParams.width = 150;
                    this.layoutParams.height = 150;
                    this.layoutParams.gravity = 17;
                    ImaWrapper.this.adUiContainer.addView((View)this.img, (ViewGroup.LayoutParams)this.layoutParams);
                    break;
                }
                case TAPPED: {
                    if (ImaWrapper.this.adPlayer == null) break;
                    ImaWrapper.this.adUiContainer.removeView((View)this.img);
                    ImaWrapper.this.adPlayer.play();
                    break;
                }
                case ALL_ADS_COMPLETED: {
                    ImaWrapper.this.onDestroy();
                    break;
                }
                case STARTED: {
                    if (ImaWrapper.this.adPlayer == null) break;
                    ImaWrapper.this.adPlayer.hideLoading();
                }
            }
        }

        public void onAdsManagerLoaded(AdsManagerLoadedEvent adsManagerLoadedEvent) {
            ImaWrapper.this.adsManager = adsManagerLoadedEvent.getAdsManager();
            ImaWrapper.this.adsManager.addAdErrorListener((AdErrorEvent.AdErrorListener)this);
            ImaWrapper.this.adsManager.addAdEventListener((AdEvent.AdEventListener)this);
            ImaWrapper.this.adsManager.init();
        }
    }
}

