/*
 * Decompiled with CFR 0.152.
 */
package com.sambatech.player.model;

import java.util.HashMap;

public enum SambaPlayerError {
    invalidUrl,
    emptyUrl,
    rootedDevice,
    unknown;

    private static HashMap<String, String> errorMessages;
    private Exception error;
    private String msg;

    public static void setMessage(SambaPlayerError error, String msg) {
        if (msg == null) {
            return;
        }
        errorMessages.put(error.name(), msg);
    }

    public SambaPlayerError setMessage(String msg) {
        if (msg == null) {
            return this;
        }
        this.msg = msg;
        return this;
    }

    public void setError(Exception e) {
        this.error = e;
    }

    public Exception getError() {
        return this.error;
    }

    public String toString() {
        return this.msg == null ? errorMessages.get(this.name()) : this.msg;
    }

    static {
        errorMessages = new HashMap();
        errorMessages.put(invalidUrl.name(), "Invalid URL format");
        errorMessages.put(emptyUrl.name(), "Missing URL for the specified media");
        errorMessages.put(rootedDevice.name(), "Specified media cannot play on a rooted device");
        errorMessages.put(unknown.name(), "Unknown error");
    }
}

