/*
 * Decompiled with CFR 0.152.
 */
package com.sambatech.player;

import android.app.Activity;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.util.Log;
import com.google.android.libraries.mediaframework.exoplayerextensions.DrmRequest;
import com.sambatech.player.R;
import com.sambatech.player.event.SambaApiCallback;
import com.sambatech.player.model.SambaMedia;
import com.sambatech.player.model.SambaMediaConfig;
import com.sambatech.player.model.SambaMediaRequest;
import com.sambatech.player.utils.Helpers;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.jose4j.base64url.internal.apache.commons.codec.binary.Base64;
import org.json.JSONArray;
import org.json.JSONObject;

public class SambaApi {
    private Activity activity;
    private String accessToken;
    private static final Map<String, Integer> outputMap = new HashMap<String, Integer>(){
        {
            this.put("_raw", -1);
            this.put("abr", 0);
            this.put("abr_hls", 0);
            this.put("240p", 1);
            this.put("360p", 2);
            this.put("480p", 3);
            this.put("720p", 4);
            this.put("1080p", 5);
        }
    };

    public SambaApi(Activity activity, String accessToken) {
        this.activity = activity;
        this.accessToken = accessToken;
    }

    public void requestMedia(SambaMediaRequest request, SambaApiCallback callback) {
        new RequestMediaTask(callback).execute(new SambaMediaRequest[]{request});
    }

    public void requestMedia(final SambaMediaRequest[] requests, final SambaApiCallback callback) {
        SambaApiCallback callbackReq = new SambaApiCallback(){
            private int counter = 0;
            private List<SambaMedia> mediaList = new ArrayList<SambaMedia>();

            @Override
            public void onMediaResponse(SambaMedia media) {
                callback.onMediaResponse(media);
                this.mediaList.add(media);
                this.checkLast();
            }

            @Override
            public void onMediaResponseError(String msg, SambaMediaRequest request) {
                callback.onMediaResponseError(msg, request);
                this.checkLast();
            }

            private void checkLast() {
                if (++this.counter == requests.length) {
                    callback.onMediaListResponse(this.mediaList.toArray(new SambaMedia[this.mediaList.size()]));
                }
            }
        };
        for (SambaMediaRequest req : requests) {
            this.requestMedia(req, callbackReq);
        }
    }

    private class RequestMediaTask
    extends AsyncTask<SambaMediaRequest, Void, SambaMedia> {
        private SambaApiCallback listener;
        private SambaMediaRequest request;
        private String errorMsg;

        public RequestMediaTask(SambaApiCallback listener) {
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected SambaMedia doInBackground(SambaMediaRequest ... params) {
            String endpoint;
            this.request = params[0];
            int delimiter = this.request.mediaId != null ? Integer.parseInt(this.request.mediaId.split("(?=\\d[a-zA-Z]*$)")[1].substring(0, 1)) : 0;
            switch (this.request.environment) {
                case LOCAL: {
                    endpoint = SambaApi.this.activity.getString(R.string.player_endpoint_local);
                    break;
                }
                case DEV: {
                    endpoint = SambaApi.this.activity.getString(R.string.player_endpoint_test);
                    break;
                }
                case STAGING: {
                    endpoint = SambaApi.this.activity.getString(R.string.player_endpoint_staging);
                    break;
                }
                default: {
                    endpoint = SambaApi.this.activity.getString(R.string.player_endpoint_prod);
                }
            }
            String url = endpoint + this.request.projectHash + (this.request.mediaId != null ? "/" + this.request.mediaId : "?" + (this.request.streamUrls.length > 0 ? "alternateLive=" + this.request.streamUrls[0] : "streamName=" + this.request.streamName));
            InputStream inputStream = null;
            Scanner scanner = null;
            Scanner scannerDelimited = null;
            this.errorMsg = "Failed to load media data";
            try {
                inputStream = new URL(url).openStream();
                scanner = new Scanner(inputStream);
                scannerDelimited = scanner.useDelimiter("\\A");
                if (scannerDelimited.hasNext()) {
                    String token = scannerDelimited.next();
                    token = token.substring(delimiter, token.length() - delimiter).replaceAll("\\-", "+").replaceAll("_", "/");
                    switch (token.length() % 4) {
                        case 0: {
                            break;
                        }
                        case 2: {
                            token = token + "==";
                            break;
                        }
                        case 3: {
                            token = token + "=";
                            break;
                        }
                    }
                    byte[] tokenBytes = Base64.decodeBase64((String)token);
                    String jsonString = new String(tokenBytes);
                    JSONObject json = new JSONObject(jsonString);
                    SambaMedia sambaMedia = this.parseMedia(json);
                    return sambaMedia;
                }
            }
            catch (Exception e) {
                this.errorMsg = "Error opening server request";
                Log.w((String)((Object)((Object)this)).getClass().getSimpleName(), (String)this.errorMsg, (Throwable)e);
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (scanner != null) {
                        scanner.close();
                    }
                    if (scannerDelimited != null) {
                        scannerDelimited.close();
                    }
                }
                catch (IOException e) {
                    this.errorMsg = "Error closing server request";
                    Log.w((String)((Object)((Object)this)).getClass().getSimpleName(), (String)this.errorMsg, (Throwable)e);
                }
            }
            return null;
        }

        protected void onPostExecute(SambaMedia media) {
            if (media == null) {
                this.listener.onMediaResponseError(this.errorMsg, this.request);
                return;
            }
            this.listener.onMediaResponse(media);
        }

        private SambaMedia parseMedia(JSONObject json) {
            try {
                JSONObject ad;
                JSONArray captions;
                String qualifier = json.getString("qualifier").toLowerCase();
                if (!(qualifier.equals("video") || qualifier.equals("live") || qualifier.equals("audio"))) {
                    return null;
                }
                SambaMediaConfig media = new SambaMediaConfig();
                JSONObject playerConfig = json.getJSONObject("playerConfig");
                JSONObject apiConfig = json.getJSONObject("apiConfig");
                JSONObject playerSecurity = json.optJSONObject("playerSecurity");
                JSONObject projectConfig = json.getJSONObject("project");
                JSONArray ads = json.optJSONArray("advertisings");
                media.projectHash = projectConfig.getString("playerHash");
                media.projectId = projectConfig.getInt("id");
                media.title = json.getString("title");
                media.isAudioOnly = qualifier.equals("audio");
                if (json.has("id")) {
                    media.id = json.getString("id");
                }
                if (json.has("categoryId")) {
                    media.categoryId = json.getInt("categoryId");
                }
                if (json.has("deliveryRules")) {
                    String defaultOutput = json.getJSONObject("project").getString("defaultOutput");
                    JSONArray rules = json.getJSONArray("deliveryRules");
                    int totalRules = rules.length();
                    ArrayList<String> filledRules = new ArrayList<String>();
                    block10: for (int i = 0; i < totalRules; ++i) {
                        String type;
                        JSONObject rule = rules.getJSONObject(i);
                        switch (type = rule.getString("urlType").toLowerCase()) {
                            case "dash": 
                            case "hls": 
                            case "progressive": {
                                if (!filledRules.contains(type) && (!type.equals("progressive") || !filledRules.contains("hls")) && (!type.equals("progressive") && !type.equals("hls") || !filledRules.contains("dash"))) break;
                                continue block10;
                            }
                            default: {
                                continue block10;
                            }
                        }
                        media.type = type;
                        ArrayList<SambaMedia.Output> mediaOutputs = new ArrayList<SambaMedia.Output>();
                        JSONArray outputs = rule.getJSONArray("outputs");
                        boolean isStreaming = type.equals("hls") || type.equals("dash");
                        String defaultOutputCurrent = isStreaming ? "abr" : defaultOutput;
                        int j = outputs.length();
                        while (j-- > 0) {
                            JSONObject output = outputs.getJSONObject(j);
                            String label = output.getString("outputName");
                            SambaMedia.Output cOutput = new SambaMedia.Output();
                            cOutput.url = output.getString("url");
                            cOutput.label = output.getString("outputName").startsWith("abr") ? "Auto" : output.getString("outputName");
                            cOutput.position = (Integer)outputMap.get(output.getString("outputName").toLowerCase());
                            media.duration = (float)output.getJSONObject("fileInfo").getLong("duration") / 1000.0f;
                            if (media.isAudioOnly) {
                                if (isStreaming && cOutput.url.contains(".mp3")) continue;
                                mediaOutputs.add(cOutput);
                                continue;
                            }
                            if (label.equalsIgnoreCase("_raw") || output.isNull("url")) continue;
                            if (label.startsWith(defaultOutputCurrent)) {
                                media.url = output.getString("url");
                                cOutput.isDefault = true;
                            }
                            mediaOutputs.add(cOutput);
                        }
                        if (mediaOutputs.size() <= 0) continue;
                        if (media.url == null) {
                            media.url = ((SambaMedia.Output)mediaOutputs.get((int)0)).url;
                        }
                        media.outputs = mediaOutputs;
                        filledRules.add(media.type);
                    }
                    if (media.outputs != null) {
                        this.sortOutputs(media.outputs);
                    }
                } else if (json.has("liveOutput")) {
                    media.url = json.getJSONObject("liveOutput").getString("baseUrl");
                    media.isLive = true;
                    if (media.url.contains(".m3u8")) {
                        media.type = "hls";
                    } else if (media.url.contains(".mpd")) {
                        media.type = "dash";
                    }
                }
                JSONArray thumbs = json.optJSONArray("thumbnails");
                if (thumbs.length() > 0 && !thumbs.getJSONObject(0).isNull("url")) {
                    media.thumb = Drawable.createFromStream((InputStream)new URL(thumbs.getJSONObject(0).getString("url")).openStream(), (String)"Thumbnail");
                }
                if ((captions = json.optJSONArray("captions")) != null && captions.length() > 0) {
                    ArrayList<SambaMedia.Caption> captionArray = new ArrayList<SambaMedia.Caption>();
                    HashMap<String, String> langLookup = new HashMap<String, String>();
                    langLookup.put("pt-br", "Portugu\u00eas");
                    langLookup.put("en-us", "Ingl\u00eas");
                    langLookup.put("es-es", "Espanhol");
                    langLookup.put("it-it", "Italiano");
                    langLookup.put("fr-fr", "Franc\u00eas");
                    langLookup.put("disable", "Desativar");
                    int j = captions.length();
                    while (j-- > 0) {
                        JSONObject caption = captions.getJSONObject(j);
                        String lang = caption.getJSONObject("fileInfo").getString("captionLanguage").toLowerCase().replace('_', '-');
                        captionArray.add(new SambaMedia.Caption(caption.getString("url"), (String)langLookup.get(lang), lang, caption.getJSONObject("fileInfo").getBoolean("closedCaption"), false));
                    }
                    captionArray.add(new SambaMedia.Caption(null, (String)langLookup.get("disable"), null, false, true));
                    media.captions = captionArray;
                }
                if (playerConfig.has("theme") && !playerConfig.getString("theme").toLowerCase().equals("default")) {
                    media.themeColor = (int)Long.parseLong("FF" + playerConfig.getString("theme").replaceAll("^#*", ""), 16);
                }
                if (apiConfig.has("sttm")) {
                    JSONObject sttm = apiConfig.getJSONObject("sttm");
                    media.sttmUrl = sttm.optString("url", "http://sttm.sambatech.com.br/collector/__sttm.gif");
                    media.sttmKey = sttm.optString("key", "ae810ebc7f0654c4fadc50935adcf5ec");
                }
                if (!media.isAudioOnly && ads != null && ads.length() > 0 && (ad = ads.optJSONObject(0)).getString("adServer").equalsIgnoreCase("dfp")) {
                    media.adUrl = ad.getString("tagVast");
                }
                if (playerSecurity != null) {
                    JSONObject drm = playerSecurity.optJSONObject("drmSecurity");
                    if (drm != null) {
                        media.drmRequest = new DrmRequest(drm.optString("widevineSignatureURL"));
                        media.drmRequest.addLicenseParam("SubContentType", drm.optString("subContentType", "Default"));
                        media.drmRequest.addLicenseParam("CrmId", drm.optString("crmId"));
                        media.drmRequest.addLicenseParam("AccountId", drm.optString("accountId"));
                        media.drmRequest.addLicenseParam("ContentId", drm.optString("contentId"));
                        media.drmRequest.addHeaderParam("Content-Type", "application/octet-stream");
                    }
                    media.blockIfRooted = playerSecurity.optBoolean("rootedDevices", false);
                }
                return media;
            }
            catch (Exception e) {
                Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"Failed to search media", (Throwable)e);
                return null;
            }
        }

        private void sortOutputs(ArrayList<SambaMedia.Output> outputs) {
            Collections.sort(outputs, new Helpers.CustomSorter());
        }
    }
}

