/*
 * Decompiled with CFR 0.152.
 */
package com.sambatech.player.event;

import android.util.Log;
import com.sambatech.player.event.SambaEvent;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;

public class SambaEventBus {
    private static EventBus _eventBus = new EventBus();

    private SambaEventBus() {
    }

    public static void subscribe(Object listener) {
        _eventBus.subscribe(listener);
    }

    public static void unsubscribe(Object listener) {
        _eventBus.unsubscribe(listener);
    }

    public static void post(SambaEvent e) {
        _eventBus.post(e);
    }

    private static class EventBus {
        private HashMap<String, List<Object>> listeners = new HashMap();
        private List<Object> postponedUnsubscribes;

        private EventBus() {
        }

        public void subscribe(Object listener) {
            String type = listener.getClass().getSuperclass().getSimpleName();
            for (Method m : listener.getClass().getDeclaredMethods()) {
                if (!Modifier.isPublic(m.getModifiers())) continue;
                String k = String.format("%s:%s", type, m.getName().substring(2).toLowerCase());
                if (!this.listeners.containsKey(k)) {
                    this.listeners.put(k, new ArrayList());
                }
                this.listeners.get(k).add(listener);
            }
        }

        public void unsubscribe(Object listener) {
            if (this.postponedUnsubscribes != null) {
                this.postponedUnsubscribes.add(listener);
                return;
            }
            String type = listener.getClass().getSuperclass().getSimpleName();
            for (Method m : listener.getClass().getDeclaredMethods()) {
                String k = String.format("%s:%s", type, m.getName().substring(2).toLowerCase());
                if (!this.listeners.containsKey(k)) continue;
                List<Object> ltnList = this.listeners.get(k);
                if (ltnList.contains(listener)) {
                    ltnList.remove(listener);
                }
                if (ltnList.size() != 0) continue;
                this.listeners.remove(k);
            }
        }

        public void post(SambaEvent e) {
            String t = e.getType().toString().toLowerCase();
            String k = String.format("%s:%s", e.getType().getClass().getEnclosingClass().getSimpleName(), t);
            t = t.substring(0, 1).toUpperCase() + t.substring(1);
            if (!this.listeners.containsKey(k)) {
                return;
            }
            try {
                this.postponedUnsubscribes = new ArrayList<Object>();
                ListIterator<Object> iterator = this.listeners.get(k).listIterator();
                while (iterator.hasNext()) {
                    Object listener = iterator.next();
                    listener.getClass().getDeclaredMethod("on" + t, SambaEvent.class).invoke(listener, e);
                }
                List<Object> unsubs = this.postponedUnsubscribes;
                this.postponedUnsubscribes = null;
                if (unsubs != null && unsubs.size() > 0) {
                    for (Object ltn : unsubs) {
                        this.unsubscribe(ltn);
                    }
                    unsubs.clear();
                }
            }
            catch (Exception exp) {
                Log.e((String)this.getClass().getSimpleName(), (String)"Error trying to lookup or invoke method.", (Throwable)exp);
            }
        }
    }
}

