/*
 * Decompiled with CFR 0.152.
 */
package com.sambatech.player;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.widget.FrameLayout;
import com.sambatech.player.R;
import com.sambatech.player.SambaPlayer;
import com.sambatech.player.SambaPlayerController;
import com.sambatech.player.SambaPlayerControllerNull;
import com.sambatech.player.model.SambaMedia;

public class SambaPlayerView
extends FrameLayout
implements SambaPlayer {
    private SambaPlayer controllerInstance = new SambaPlayerController(this);
    private SambaPlayer controller = SambaPlayerControllerNull.getInstance();
    private boolean autoFsMode;
    private boolean enableControls = true;

    public SambaPlayerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.applyAttributes(this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.SambaPlayerView, 0, 0));
    }

    @Override
    public void setMedia(SambaMedia media) {
        this.controller = this.controllerInstance;
        this.controller.setMedia(media);
        this.controller.setAutoFullscreenMode(this.autoFsMode);
        this.controller.setEnableControls(this.enableControls);
    }

    @Override
    public void setEnableControls(boolean flag) {
        this.controller.setEnableControls(flag);
    }

    @Override
    public SambaMedia getMedia() {
        return this.controller.getMedia();
    }

    @Override
    public void play() {
        this.controller.play();
    }

    @Override
    public void pause() {
        this.controller.pause();
    }

    @Override
    public void stop() {
        this.controller.stop();
    }

    @Override
    public void seek(float position) {
        this.controller.seek(position);
    }

    @Override
    public void setFullscreen(boolean flag) {
        this.controller.setFullscreen(flag);
    }

    @Override
    public boolean isFullscreen() {
        return this.controller.isFullscreen();
    }

    @Override
    public void show() {
        this.controller.show();
    }

    @Override
    public void hide() {
        this.controller.hide();
    }

    @Override
    public void setAutoFullscreenMode(boolean flag) {
        this.controller.setAutoFullscreenMode(flag);
    }

    @Override
    public float getCurrentTime() {
        return this.controller.getCurrentTime();
    }

    @Override
    public float getDuration() {
        return this.controller.getDuration();
    }

    @Override
    public boolean hasFinished() {
        return this.controller.hasFinished();
    }

    @Override
    public boolean hasStarted() {
        return this.controller.hasStarted();
    }

    @Override
    public void changeOutput(SambaMedia.Output output) {
        this.controller.changeOutput(output);
    }

    @Override
    public void destroy() {
        this.controller.destroy();
        this.controller = SambaPlayerControllerNull.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyAttributes(TypedArray attrs) {
        try {
            this.autoFsMode = attrs.getBoolean(R.styleable.SambaPlayerView_autoFullscreenMode, false);
            this.enableControls = attrs.getBoolean(R.styleable.SambaPlayerView_enableControls, true);
        }
        finally {
            attrs.recycle();
        }
    }
}

