/*
 * Decompiled with CFR 0.152.
 */
package com.sambatech.player.plugins;

import android.os.AsyncTask;
import android.text.TextUtils;
import android.util.Log;
import com.sambatech.player.SambaPlayer;
import com.sambatech.player.event.SambaEvent;
import com.sambatech.player.event.SambaEventBus;
import com.sambatech.player.event.SambaPlayerListener;
import com.sambatech.player.model.SambaMediaConfig;
import com.sambatech.player.plugins.Plugin;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;

public class Tracking
implements Plugin {
    private SambaPlayer player;
    private SambaMediaConfig media;
    private Sttm sttm;
    private SambaPlayerListener playerListener = new SambaPlayerListener(){

        @Override
        public void onStart(SambaEvent event) {
            Log.e((String)"sttm", (String)"onstart");
            Tracking.this.init();
            if (Tracking.this.sttm != null) {
                Tracking.this.sttm.trackStart();
            }
        }

        @Override
        public void onProgress(SambaEvent event) {
            if (Tracking.this.sttm != null) {
                Tracking.this.sttm.trackProgress(((Float)event.getDataAll()[0]).floatValue(), ((Float)event.getDataAll()[1]).floatValue());
            }
        }

        @Override
        public void onFinish(SambaEvent event) {
            if (Tracking.this.sttm != null) {
                Tracking.this.sttm.trackComplete();
            }
        }
    };

    @Override
    public void onLoad(SambaPlayer player) {
        Log.i((String)"track", (String)"load");
        this.media = (SambaMediaConfig)player.getMedia();
        if (this.media.projectHash != null && this.media.id != null) {
            SambaEventBus.subscribe(this.playerListener);
        }
    }

    @Override
    public void onDestroy() {
        Log.i((String)"track", (String)"destroy");
        SambaEventBus.unsubscribe(this.playerListener);
        if (this.sttm != null) {
            this.sttm.destroy();
            this.sttm = null;
        }
    }

    private void init() {
        if (this.media.sttmUrl != null && this.sttm == null) {
            this.sttm = new Sttm();
        }
    }

    private class Sttm
    extends TimerTask {
        private List<String> targets = new ArrayList<String>();
        private Timer sttmTimer;
        private TreeSet<String> progresses = new TreeSet();
        private HashSet<Integer> trackedRetentions = new HashSet();

        public Sttm() {
            this.sttmTimer = new Timer();
            this.sttmTimer.scheduleAtFixedRate((TimerTask)this, 0L, 5000L);
        }

        @Override
        public void run() {
            if (this.targets.size() == 0) {
                return;
            }
            new UrlTracker().execute(new String[]{String.format("%s?sttmm=%s&sttmk=%s&sttms=%s&sttmu=123&sttmw=%s", ((Tracking)Tracking.this).media.sttmUrl, TextUtils.join((CharSequence)",", this.targets), ((Tracking)Tracking.this).media.sttmKey, ((Tracking)Tracking.this).media.sessionId, String.format("pid:%s/cat:%s/mid:%s", ((Tracking)Tracking.this).media.projectId, ((Tracking)Tracking.this).media.categoryId, ((Tracking)Tracking.this).media.id))});
            this.targets.clear();
        }

        public void trackStart() {
            this.targets.add("play");
        }

        public void trackComplete() {
            this.collectProgress();
            this.targets.add("complete");
        }

        public void trackProgress(float time, float duration) {
            int p = (int)(100.0f * time / duration);
            if (p > 99) {
                p = 99;
            }
            this.progresses.add(this.trackedRetentions.contains(p) ? String.format(Locale.getDefault(), "p%02d", p) : String.format(Locale.getDefault(), "p%02d,r%02d", p, p));
            this.trackedRetentions.add(p);
            if (this.progresses.size() >= 5) {
                this.collectProgress();
            }
        }

        public void destroy() {
            if (this.sttmTimer != null) {
                this.sttmTimer.cancel();
                this.sttmTimer.purge();
                this.sttmTimer = null;
            }
        }

        private void collectProgress() {
            if (this.progresses.size() == 0) {
                return;
            }
            this.targets.add(TextUtils.join((CharSequence)",", this.progresses));
            this.progresses.clear();
        }
    }

    private class UrlTracker
    extends AsyncTask<String, Void, Void> {
        private UrlTracker() {
        }

        protected Void doInBackground(String ... params) {
            try {
                Log.i((String)((Object)((Object)this)).getClass().getSimpleName(), (String)params[0]);
                for (String url : params) {
                    URL myURL = new URL(url);
                    URLConnection conn = myURL.openConnection();
                    conn.setRequestProperty("http.agent", "chrome");
                    conn.setDoOutput(false);
                    conn.setDoInput(true);
                    InputStream is = conn.getInputStream();
                }
            }
            catch (IOException e) {
                Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"Failed to fetch URL", (Throwable)e);
            }
            return null;
        }
    }
}

